/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.dom;

import com.novell.xml.dom.AttrImpl;
import com.novell.xml.dom.DocumentImpl;
import com.novell.xml.sax.DocumentCommentHandler;
import java.io.IOException;
import java.util.Locale;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributeListImpl;

public class DOMtoSAX
implements Parser {
    private final Document document;
    private final boolean novellDOM;
    private DTDHandler dtdHandler;
    private DocumentHandler documentHandler;
    private AttributeListImpl attList = null;

    public DOMtoSAX(Document document) {
        if (document == null) {
            throw new IllegalArgumentException("Null document to DOMtoSAX constructor");
        }
        this.document = document;
        this.novellDOM = document instanceof DocumentImpl;
    }

    public void setLocale(Locale locale) throws SAXException {
    }

    public void setEntityResolver(EntityResolver entityResolver) {
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this.dtdHandler = dTDHandler;
    }

    public void setDocumentHandler(DocumentHandler documentHandler) {
        this.documentHandler = documentHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
    }

    public void parse(InputSource inputSource) throws SAXException, IOException {
        this.parse((String)null);
    }

    public void parse(String string) throws SAXException, IOException {
        if (this.documentHandler == null) {
            return;
        }
        this.parseSubTree(this.document);
    }

    private void parseSubTree(Node node) throws SAXException {
        if (node == null) {
            return;
        }
        switch (node.getNodeType()) {
            case 9: {
                this.documentHandler.startDocument();
                this.parseChildNodes(node);
                this.documentHandler.endDocument();
                break;
            }
            case 1: {
                this.sendElement((Element)node);
                break;
            }
            case 3: 
            case 4: {
                char[] cArray = node.getNodeValue().toCharArray();
                this.documentHandler.characters(cArray, 0, cArray.length);
                break;
            }
            case 7: {
                this.documentHandler.processingInstruction(((ProcessingInstruction)node).getTarget(), ((ProcessingInstruction)node).getData());
                break;
            }
            case 8: {
                if (!(this.documentHandler instanceof DocumentCommentHandler)) break;
                ((DocumentCommentHandler)this.documentHandler).comment(node.getNodeValue());
                break;
            }
            case 10: {
                this.parseNodeMap(((DocumentType)node).getEntities());
                this.parseNodeMap(((DocumentType)node).getNotations());
                break;
            }
            case 6: {
                if (this.dtdHandler == null || ((Entity)node).getNotationName() == null) break;
                this.dtdHandler.unparsedEntityDecl(((Entity)node).getNotationName(), ((Entity)node).getPublicId(), ((Entity)node).getSystemId(), node.getNodeName());
                break;
            }
            case 12: {
                if (this.dtdHandler == null) break;
                this.dtdHandler.notationDecl(node.getNodeName(), ((Notation)node).getPublicId(), ((Notation)node).getSystemId());
                break;
            }
        }
    }

    private void parseChildNodes(Node node) throws SAXException {
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            this.parseSubTree(node2);
            node2 = node2.getNextSibling();
        }
    }

    private void sendElement(Element element) throws SAXException {
        if (this.attList == null) {
            this.attList = new AttributeListImpl();
        } else {
            this.attList.clear();
        }
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = 0;
        while (n < namedNodeMap.getLength()) {
            Attr attr = (Attr)namedNodeMap.item(n);
            if (this.novellDOM && ((AttrImpl)attr).isId()) {
                this.attList.addAttribute(attr.getNodeName(), "ID", attr.getNodeValue());
            } else {
                this.attList.addAttribute(attr.getNodeName(), "CDATA", attr.getNodeValue());
            }
            ++n;
        }
        this.documentHandler.startElement(element.getNodeName(), this.attList);
        this.parseChildNodes(element);
        this.documentHandler.endElement(element.getNodeName());
    }

    private void parseNodeMap(NamedNodeMap namedNodeMap) throws SAXException {
        int n = 0;
        while (n < namedNodeMap.getLength()) {
            this.parseSubTree(namedNodeMap.item(n));
            ++n;
        }
    }
}

