/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.dom;

import com.novell.xml.dom.AttrImpl;
import com.novell.xml.dom.DOMExceptionImpl;
import com.novell.xml.dom.DocumentImpl;
import com.novell.xml.dom.NamedNodeMapImpl;
import com.novell.xml.dom.NamespaceImpl;
import com.novell.xml.dom.NodeImpl;
import com.novell.xml.dom.TagNameNodeList;
import com.novell.xml.dom.TagNameNodeListNS;
import com.novell.xml.util.XMLUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ElementImpl
extends NodeImpl
implements Element {
    private NamedNodeMapImpl attributes = null;
    private NamedNodeMapImpl namespaces = null;
    private boolean isMapped = false;
    private AttrImpl idAttr = null;

    public short getNodeType() {
        return 1;
    }

    public String getTagName() {
        return this.getNodeName();
    }

    public NamedNodeMap getAttributes() {
        if (this.attributes == null) {
            this.attributes = new NamedNodeMapImpl(this);
        }
        return this.attributes;
    }

    public Node cloneNode(boolean bl) {
        ElementImpl elementImpl = (ElementImpl)super.cloneNode(bl);
        if (this.attributes != null) {
            elementImpl.attributes = this.attributes.cloneThis(elementImpl);
        }
        return elementImpl;
    }

    public String getAttribute(String string) {
        Attr attr = this.attributes != null ? (Attr)this.attributes.getNamedItem(string) : null;
        return attr == null ? "" : attr.getValue();
    }

    public void setAttribute(String string, String string2) throws DOMException {
        this.gateModify();
        this.checkName(string);
        if (this.attributes == null) {
            this.attributes = new NamedNodeMapImpl(this);
        }
        AttrImpl attrImpl = (AttrImpl)this.getOwnerDocument().createAttribute(string);
        attrImpl.setNodeValue(string2);
        this.setAttributeNode(attrImpl);
        this.document.setOrderCurrent(false);
    }

    public void removeAttribute(String string) throws DOMException {
        block3: {
            this.gateModify();
            if (this.attributes != null) {
                Attr attr = null;
                try {
                    attr = (Attr)this.attributes.removeNamedItem(string);
                }
                catch (DOMException dOMException) {
                    if (dOMException.code == 8) break block3;
                    throw dOMException;
                }
            }
        }
    }

    public Attr getAttributeNode(String string) {
        return this.attributes == null ? null : (Attr)this.attributes.getNamedItem(string);
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        this.gateModify();
        if (this.attributes == null) {
            this.attributes = new NamedNodeMapImpl(this);
        }
        this.document.setOrderCurrent(false);
        return (Attr)this.attributes.setNamedItem(attr);
    }

    public Attr removeAttributeNode(Attr attr) throws DOMException {
        this.gateModify();
        if (this.attributes != null) {
            Attr attr2 = (Attr)this.attributes.removeNamedItem(attr.getNodeName());
            return attr2;
        }
        throw new DOMExceptionImpl(8, null);
    }

    public NodeList getElementsByTagName(String string) {
        return new TagNameNodeList(this, string);
    }

    public String getAttributeNS(String string, String string2) {
        Attr attr = this.attributes != null ? (Attr)this.attributes.getNamedItemNS(string, string2) : null;
        return attr == null ? "" : attr.getValue();
    }

    public void setAttributeNS(String string, String string2, String string3) throws DOMException {
        this.gateModify();
        if (this.attributes == null) {
            this.attributes = new NamedNodeMapImpl(this);
        }
        AttrImpl attrImpl = (AttrImpl)this.getOwnerDocument().createAttributeNS(string, string2);
        attrImpl.setNodeValue(string3);
        this.setAttributeNodeNS(attrImpl);
        this.document.setOrderCurrent(false);
    }

    public void removeAttributeNS(String string, String string2) throws DOMException {
        block3: {
            this.gateModify();
            if (this.attributes != null) {
                Attr attr = null;
                try {
                    attr = (Attr)this.attributes.removeNamedItemNS(string, string2);
                }
                catch (DOMException dOMException) {
                    if (dOMException.code == 8) break block3;
                    throw dOMException;
                }
            }
        }
    }

    public Attr getAttributeNodeNS(String string, String string2) {
        return this.attributes == null ? null : (Attr)this.attributes.getNamedItemNS(string, string2);
    }

    public Attr setAttributeNodeNS(Attr attr) throws DOMException {
        this.gateModify();
        if (this.attributes == null) {
            this.attributes = new NamedNodeMapImpl(this);
        }
        this.document.setOrderCurrent(false);
        return (Attr)this.attributes.setNamedItemNS(attr);
    }

    public NodeList getElementsByTagNameNS(String string, String string2) {
        return new TagNameNodeListNS(this, string, string2);
    }

    public boolean hasAttribute(String string) {
        return this.getAttributeNode(string) != null;
    }

    public boolean hasAttributeNS(String string, String string2) {
        return this.getAttributeNodeNS(string, string2) != null;
    }

    public Attr getIdAttr() {
        return this.idAttr;
    }

    public NamedNodeMap getNamespaces() {
        if (this.namespaces == null) {
            this.namespaces = new NamedNodeMapImpl(this);
            DocumentImpl documentImpl = (DocumentImpl)this.getOwnerDocument();
            Node node = this;
            while (node != null) {
                NamedNodeMap namedNodeMap = node.getAttributes();
                if (namedNodeMap != null) {
                    Attr attr;
                    int n = 0;
                    while ((attr = (Attr)namedNodeMap.item(n++)) != null) {
                        String string = attr.getNodeName();
                        if (!XMLUtil.isNamespaceDecl(string)) continue;
                        int n2 = string.indexOf(58);
                        String string2 = attr.getNodeValue();
                        NamespaceImpl namespaceImpl = documentImpl.createNamespaceNode(n2 == -1 ? "" : string.substring(n2 + 1, string.length()), string2);
                        this.namespaces.setNamedItem(namespaceImpl);
                    }
                }
                node = node.getParentNode();
            }
            if (this.namespaces.getLength() != 0) {
                NodeImpl nodeImpl;
                double d = this.getDocumentOrder();
                double d2 = this.attributes == null || this.attributes.item(0) == null ? d + 1.0 : ((NodeImpl)this.attributes.item(0)).getDocumentOrder() - d;
                double d3 = (d2 - d) / (double)(this.namespaces.getLength() + 1);
                d += d3;
                int n = 0;
                while ((nodeImpl = (NodeImpl)this.namespaces.item(n++)) != null) {
                    nodeImpl.setDocumentOrder(d);
                    d += d3;
                }
            }
        }
        return this.namespaces;
    }

    protected int updateDocumentOrder(int n) {
        NodeImpl nodeImpl;
        int n2;
        if (this.namespaces != null) {
            n2 = 0;
            while ((nodeImpl = (NodeImpl)this.namespaces.item(n2++)) != null) {
                nodeImpl.setDocumentOrder(n++);
            }
        }
        if (this.attributes != null) {
            n2 = 0;
            while ((nodeImpl = (NodeImpl)this.attributes.item(n2++)) != null) {
                nodeImpl.setDocumentOrder(n++);
            }
        }
        return n;
    }

    protected ElementImpl(DocumentImpl documentImpl, String string) {
        super(documentImpl, string, null);
    }

    protected ElementImpl(DocumentImpl documentImpl, String string, String string2) {
        super(documentImpl, string, string2, null);
    }

    protected void setMapped(boolean bl) {
        this.isMapped = bl;
    }

    protected void checkNamespaceAttr(String string) {
        this.incChangeCount();
        if (XMLUtil.isNamespaceDecl(string)) {
            this.purgeCachedExpandedNames();
        }
    }

    protected void purgeCachedExpandedNames() {
        super.purgeCachedExpandedNames();
        this.namespaces = null;
        if (this.attributes != null) {
            int n = 0;
            AttrImpl attrImpl = (AttrImpl)this.attributes.item(n);
            while (attrImpl != null) {
                attrImpl.purgeCachedExpandedNames();
                attrImpl = (AttrImpl)this.attributes.item(++n);
            }
        }
    }
}

