/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.dom;

import com.novell.xml.dom.AttrImpl;
import com.novell.xml.dom.DOMExceptionImpl;
import com.novell.xml.dom.DOMUtil;
import com.novell.xml.dom.ElementImpl;
import com.novell.xml.dom.NamespaceImpl;
import com.novell.xml.dom.NodeImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NamedNodeMapImpl
implements NamedNodeMap {
    private List nodeList = new ArrayList(1);
    private boolean needSort = false;
    private NodeImpl owner;
    private static NameComparator nameComparator = new NameComparator();

    public Node getNamedItem(String string) {
        int n = this.findItem(string);
        if (n >= 0) {
            return (Node)this.nodeList.get(n);
        }
        return null;
    }

    public Node setNamedItem(Node node) throws DOMException {
        if (node.getOwnerDocument() != this.owner.getOwnerDocument()) {
            throw new DOMExceptionImpl(4, null);
        }
        this.owner.gateModify();
        if (node.getNodeType() == 2 && ((AttrImpl)node).isInUse() && ((AttrImpl)node).getOwnerElement() != this.owner) {
            throw new DOMExceptionImpl(10, null);
        }
        int n = this.findItem(node.getNodeName());
        if (n >= 0) {
            Node node2 = (Node)this.nodeList.get(n);
            this.removeNode(node2);
            this.nodeList.set(n, node);
            this.addNode(node);
            return node2;
        }
        this.nodeList.add(node);
        this.addNode(node);
        this.needSort = true;
        return null;
    }

    public Node removeNamedItem(String string) throws DOMException {
        this.owner.gateModify();
        int n = this.findItem(string);
        if (n >= 0) {
            Node node = (Node)this.nodeList.remove(n);
            this.removeNode(node);
            return node;
        }
        throw new DOMExceptionImpl(8, null);
    }

    public Node item(int n) {
        if (0 > n || n >= this.nodeList.size()) {
            return null;
        }
        if (this.needSort) {
            this.sort();
        }
        return (Node)this.nodeList.get(n);
    }

    public int getLength() {
        return this.nodeList.size();
    }

    public Node getNamedItemNS(String string, String string2) {
        int n = this.findItemNS(string, string2);
        if (n >= 0) {
            return (Node)this.nodeList.get(n);
        }
        return null;
    }

    public Node setNamedItemNS(Node node) throws DOMException {
        if (node.getOwnerDocument() != this.owner.getOwnerDocument()) {
            throw new DOMExceptionImpl(4, null);
        }
        this.owner.gateModify();
        if (node.getNodeType() == 2 && ((AttrImpl)node).isInUse() && ((AttrImpl)node).getOwnerElement() != this.owner) {
            throw new DOMExceptionImpl(10, null);
        }
        int n = this.findItemNS(node.getNamespaceURI(), node.getLocalName());
        if (n >= 0) {
            Node node2 = (Node)this.nodeList.get(n);
            this.removeNode(node2);
            this.nodeList.set(n, node);
            this.addNode(node);
            return node2;
        }
        this.nodeList.add(node);
        this.addNode(node);
        this.needSort = true;
        return null;
    }

    public Node removeNamedItemNS(String string, String string2) throws DOMException {
        this.owner.gateModify();
        int n = this.findItemNS(string, string2);
        if (n >= 0) {
            Node node = (Node)this.nodeList.remove(n);
            this.removeNode(node);
            return node;
        }
        throw new DOMExceptionImpl(8, null);
    }

    public NamedNodeMapImpl cloneThis(NodeImpl nodeImpl) {
        NamedNodeMapImpl namedNodeMapImpl = new NamedNodeMapImpl(nodeImpl);
        int n = this.nodeList.size();
        namedNodeMapImpl.needSort = this.needSort;
        int n2 = 0;
        while (n2 < n) {
            namedNodeMapImpl.nodeList.add(((Node)this.nodeList.get(n2)).cloneNode(true));
            ++n2;
        }
        return namedNodeMapImpl;
    }

    protected NamedNodeMapImpl(NodeImpl nodeImpl) {
        this.owner = nodeImpl;
    }

    protected void sort() {
        Collections.sort(this.nodeList, nameComparator);
        this.needSort = false;
    }

    protected int findItem(String string) {
        if (this.needSort) {
            this.sort();
        }
        return Collections.binarySearch(this.nodeList, string, nameComparator);
    }

    protected int findItemNS(String string, String string2) {
        int n = this.nodeList.size();
        int n2 = 0;
        while (n2 < n) {
            Node node = (Node)this.nodeList.get(n2);
            String string3 = node.getLocalName();
            String string4 = node.getNamespaceURI();
            if (DOMUtil.stringsEqual(string, string4) && DOMUtil.stringsEqual(string2, string3)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    protected void removeNode(Node node) {
        if (this.owner.getNodeType() == 1) {
            short s = node.getNodeType();
            if (s == 2) {
                if (((AttrImpl)node).isId() && this.owner.document != null) {
                    this.owner.document.removeId(node.getNodeValue());
                }
                ((AttrImpl)node).setOwningElement(null);
                this.checkNamespaceAttr((AttrImpl)node);
            } else if (s == -1) {
                ((NamespaceImpl)node).setOwningElement(null);
            }
        }
    }

    protected void addNode(Node node) {
        if (this.owner.getNodeType() == 1) {
            short s = node.getNodeType();
            if (s == 2) {
                if (((AttrImpl)node).isId() && this.owner.document != null) {
                    this.owner.document.addId((ElementImpl)this.owner, node.getNodeValue());
                }
                ((AttrImpl)node).setOwningElement((Element)((Object)this.owner));
                this.checkNamespaceAttr((AttrImpl)node);
            } else if (s == -1) {
                ((NamespaceImpl)node).setOwningElement((Element)((Object)this.owner));
            }
        }
    }

    protected void checkNamespaceAttr(AttrImpl attrImpl) {
        ((ElementImpl)this.owner).checkNamespaceAttr(attrImpl.getNodeName());
    }

    private static class NameComparator
    implements Comparator {
        private NameComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object instanceof String) {
                return ((String)object).compareTo(((Node)object2).getNodeName());
            }
            if (object2 instanceof String) {
                return ((Node)object).getNodeName().compareTo((String)object2);
            }
            return ((Node)object).getNodeName().compareTo(((Node)object2).getNodeName());
        }

        public boolean equals(Object object) {
            return this == object;
        }
    }
}

