/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.parser;

import com.novell.util.URIResolver;
import com.novell.xml.dom.DocumentImpl;
import com.novell.xml.parser.XMLParser;
import com.novell.xml.sax.SAXtoDOM;
import com.novell.xml.util.XMLUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.Vector;
import org.w3c.dom.Document;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SAXParserImpl
implements XMLParser {
    private URL contextURI = null;
    private Vector errorList = new Vector(2, 2);
    private final eHandler errorHandler = new eHandler();
    private final Parser parser = SAXParserImpl.constructParser();
    private boolean fatalErrorDetected = false;
    private SAXtoDOM useConverter = null;

    public SAXParserImpl() {
        try {
            this.parser.setLocale(Locale.getDefault());
            this.parser.setErrorHandler(this.errorHandler);
        }
        catch (SAXException sAXException) {
            this.errorList.addElement(sAXException.getLocalizedMessage());
        }
    }

    public Document parse(InputStream inputStream) {
        try {
            if (this.parser == null) {
                return null;
            }
            this.errorList.removeAllElements();
            this.fatalErrorDetected = false;
            InputSource inputSource = new InputSource(inputStream);
            inputSource.setSystemId(this.contextURI != null ? this.contextURI.toString() : "");
            SAXtoDOM sAXtoDOM = this.useConverter != null ? this.useConverter : new SAXtoDOM(DocumentImpl.newDocument());
            this.parser.setDocumentHandler(sAXtoDOM);
            this.parser.setDTDHandler(sAXtoDOM);
            this.parser.parse(inputSource);
            if (!this.fatalErrorDetected) {
                return sAXtoDOM.getResult();
            }
        }
        catch (IOException iOException) {
            this.errorList.addElement(iOException.getLocalizedMessage());
        }
        catch (SAXException sAXException) {
            this.errorList.addElement(sAXException.getLocalizedMessage());
        }
        return null;
    }

    public Document parse(Reader reader) {
        try {
            if (this.parser == null) {
                return null;
            }
            this.errorList.removeAllElements();
            this.fatalErrorDetected = false;
            InputSource inputSource = new InputSource(reader);
            inputSource.setSystemId(this.contextURI != null ? this.contextURI.toString() : "");
            SAXtoDOM sAXtoDOM = this.useConverter != null ? this.useConverter : new SAXtoDOM(DocumentImpl.newDocument());
            this.parser.setDocumentHandler(sAXtoDOM);
            this.parser.setDTDHandler(sAXtoDOM);
            this.parser.parse(inputSource);
            if (!this.fatalErrorDetected) {
                return sAXtoDOM.getResult();
            }
        }
        catch (IOException iOException) {
            this.errorList.addElement(iOException.getLocalizedMessage());
        }
        catch (SAXException sAXException) {
            this.errorList.addElement(sAXException.getLocalizedMessage());
        }
        return null;
    }

    public Document parse(String string) throws FileNotFoundException, IOException, MalformedURLException {
        this.setContextURI(string);
        return this.parse(this.contextURI.openStream());
    }

    public Document parse(InputSource inputSource) throws FileNotFoundException, IOException {
        this.setContextURI(inputSource.getSystemId());
        if (inputSource.getByteStream() != null) {
            return this.parse(inputSource.getByteStream());
        }
        if (inputSource.getCharacterStream() != null) {
            return this.parse(inputSource.getCharacterStream());
        }
        return this.parse(inputSource.getSystemId());
    }

    public Document parse(File file) throws FileNotFoundException {
        try {
            this.setContextURI(file.getName());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return this.parse(new FileInputStream(file));
    }

    public void setConverter(SAXtoDOM sAXtoDOM) {
        this.useConverter = sAXtoDOM;
    }

    public void setContextURI(String string) throws MalformedURLException {
        URL uRL = XMLUtil.filenameToURL(".");
        String string2 = URIResolver.resolveURI(string, uRL.toString());
        this.contextURI = new URL(string2);
    }

    public boolean anyErrors() {
        return !this.errorList.isEmpty();
    }

    public Vector getErrorMsgs() {
        return this.errorList;
    }

    public String getErrorMsgString() {
        if (this.anyErrors()) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < this.errorList.size()) {
                stringBuffer.append((String)this.errorList.elementAt(n));
                if (n < this.errorList.size() - 1) {
                    stringBuffer.append('\n');
                }
                ++n;
            }
            return stringBuffer.toString();
        }
        return "";
    }

    public void reportErrorMsgs(OutputStream outputStream) {
        PrintWriter printWriter = new PrintWriter(outputStream);
        int n = 0;
        while (n < this.errorList.size()) {
            String string = (String)this.errorList.elementAt(n);
            printWriter.println(string);
            ++n;
        }
        printWriter.flush();
    }

    private static Parser constructParser() {
        String string = System.getProperty("com.novell.xml.parser");
        if (string == null) {
            string = System.getProperty("org.xml.sax.parser");
        }
        if (string == null) {
            string = "com.jclark.xml.sax.CommentDriver";
        }
        try {
            Class<?> clazz = Class.forName(string);
            return (Parser)clazz.newInstance();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString());
        }
    }

    private class eHandler
    extends HandlerBase {
        private eHandler() {
        }

        public void error(SAXParseException sAXParseException) {
        }

        public void fatalError(SAXParseException sAXParseException) {
            StringBuffer stringBuffer = new StringBuffer();
            String string = sAXParseException.getSystemId();
            if (string != null) {
                stringBuffer.append('\'');
                stringBuffer.append(string);
                stringBuffer.append("': ");
            }
            if (sAXParseException.getLineNumber() != -1) {
                stringBuffer.append('(');
                stringBuffer.append(sAXParseException.getLineNumber());
                stringBuffer.append("): ");
            }
            stringBuffer.append(sAXParseException.getLocalizedMessage());
            SAXParserImpl.this.errorList.addElement(stringBuffer.toString());
            SAXParserImpl.this.fatalErrorDetected = true;
        }

        public void warning(SAXParseException sAXParseException) {
        }
    }
}

