/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.util;

import com.novell.io.CharEncodingException;
import com.novell.xml.util.BuiltInRef;
import com.novell.xml.util.XMLCharDefs;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;

public final class XMLUtil {
    public static final String XML_STYLE_SHEET = "xml-stylesheet";
    public static final String DIGITS = "0123456789";
    public static final String HEX_DIGITS = "0123456789abcdefABCDEF";
    private static final String AMP = "amp";
    private static final String APOS = "apos";
    private static final String QUOT = "quot";
    private static final String LT = "lt";
    private static final String GT = "gt";
    private static final String AMP_FULL = "&amp;";
    private static final String APOS_FULL = "&apos;";
    private static final String QUOT_FULL = "&quot;";
    private static final String LT_FULL = "&lt;";
    private static final String GT_FULL = "&gt;";
    private static final int BUILT_IN_REF_COUNT = 5;
    private static final BuiltInRef[] BUILT_IN_REFS = new BuiltInRef[]{new BuiltInRef("amp", '&'), new BuiltInRef("apos", '\''), new BuiltInRef("quot", '\"'), new BuiltInRef("lt", '<'), new BuiltInRef("gt", '>')};

    public static URL filenameToURL(String string) throws MalformedURLException {
        File file = new File(string);
        String string2 = file.getAbsolutePath();
        if (File.separatorChar != '/') {
            string2 = string2.replace(File.separatorChar, '/');
        }
        if (!string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        if (file.isDirectory()) {
            string2 = string2 + "/";
        }
        return new URL("file", "", string2);
    }

    public static String escape(String string) {
        return XMLUtil.escape(string, Integer.MAX_VALUE);
    }

    public static String escape(String string, int n) {
        if (string == null) {
            return "(null)";
        }
        String string2 = XMLUtil.toXML(string);
        if (string2.length() > n) {
            string2 = string2.substring(0, n - 3) + "...";
        }
        return string2;
    }

    public static String quote(String string) {
        return XMLUtil.quote(string, Integer.MAX_VALUE);
    }

    public static String quote(String string, int n) {
        if (string == null) {
            return "(null)";
        }
        String string2 = XMLUtil.toXML(string, "\"");
        if (string2.length() > n - 2) {
            string2 = string2.substring(0, n - 5) + "...";
        }
        return "\"" + string2 + "\"";
    }

    public static String normalizeWhitespace(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (n < string.length() && XMLUtil.isXMLWhitespace(string.charAt(n))) {
            ++n;
        }
        boolean bl = false;
        while (n < string.length()) {
            block4: {
                char c;
                block5: {
                    block3: {
                        c = string.charAt(n);
                        if (!XMLUtil.isXMLWhitespace(c)) break block3;
                        if (bl) break block4;
                        c = ' ';
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
                stringBuffer.append(c);
            }
            ++n;
        }
        if (bl) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    public static boolean isXMLName(String string) {
        if (string.length() == 0) {
            return false;
        }
        char c = string.charAt(0);
        if (!XMLUtil.isXMLName(c)) {
            return false;
        }
        int n = 1;
        while (n < string.length()) {
            if (!XMLCharDefs.isXMLNameChar(string.charAt(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static boolean isXMLName(char c) {
        return XMLCharDefs.isXMLLetter(c) || c == '_' || c == ':';
    }

    public static boolean isXMLNameChar(char c) {
        return XMLCharDefs.isXMLNameChar(c);
    }

    public static boolean isNCName(char c) {
        return XMLCharDefs.isXMLLetter(c) || c == '_';
    }

    public static boolean isNCName(String string) {
        if (string.length() == 0) {
            return false;
        }
        char c = string.charAt(0);
        if (!XMLUtil.isNCName(c)) {
            return false;
        }
        int n = 1;
        while (n < string.length()) {
            if (c == ':' || !XMLCharDefs.isXMLNameChar(string.charAt(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static boolean isNCNameChar(char c) {
        return c != ':' && XMLCharDefs.isXMLNameChar(c);
    }

    public static boolean isQName(String string) {
        int n = string.indexOf(58);
        if (n != -1) {
            if (n == 0 || n == string.length() - 1) {
                return false;
            }
            return XMLUtil.isNCName(string.substring(0, n)) && XMLUtil.isNCName(string.substring(n + 1, string.length()));
        }
        return XMLUtil.isNCName(string);
    }

    public static boolean isPITarget(String string) {
        return XMLUtil.isXMLName(string) && !string.equalsIgnoreCase("xml");
    }

    public static boolean isXMLWhitespace(String string) {
        int n = 0;
        while (n < string.length()) {
            if (!XMLUtil.isXMLWhitespace(string.charAt(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static boolean isXMLWhitespace(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n';
    }

    public static boolean isXMLVersionNum(String string) {
        if (string.length() < 1) {
            return false;
        }
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '.' || c == ':' || c == '-')) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static boolean isXMLEncName(String string) {
        if (string.length() < 1) {
            return false;
        }
        char c = string.charAt(0);
        if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
            return false;
        }
        int n = 1;
        while (n < string.length()) {
            c = string.charAt(n);
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '.' || c == ':' || c == '-')) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static boolean isNamespaceDecl(String string) {
        return string.startsWith("xmlns") && (string.length() <= 5 || string.charAt(5) == ':');
    }

    public static String toXML(String string) {
        return XMLUtil.toXML(string, null);
    }

    public static String toXML(String string, String string2) {
        if (string.length() == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '&') {
                stringBuffer.append(AMP_FULL);
            } else if (c == '<') {
                stringBuffer.append(LT_FULL);
            } else if (c == '>') {
                stringBuffer.append(GT_FULL);
            } else if (c == '\"') {
                stringBuffer.append(QUOT_FULL);
            } else if (c == '\'') {
                stringBuffer.append(APOS_FULL);
            } else if (string2 != null && string2.indexOf(c) != -1) {
                stringBuffer.append("&#x");
                stringBuffer.append(Integer.toHexString(c));
                stringBuffer.append(';');
            } else if (c >= '\ud800' && c <= '\udc00') {
                char c2 = string.charAt(++n);
                int n2 = (c - 55296 << 10) + (c2 - 56320) + 65536;
                stringBuffer.append("&#x");
                stringBuffer.append(Integer.toHexString(n2));
                stringBuffer.append(';');
            } else if (c < ' ' && !XMLUtil.isXMLWhitespace(c)) {
                stringBuffer.append("&#x");
                stringBuffer.append(Integer.toHexString(63743 - c));
                stringBuffer.append(';');
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static void encodeText(Writer writer, String string) throws IOException {
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            int n3;
            try {
                char c = string.charAt(n);
                if (c == '&') {
                    writer.write(AMP_FULL);
                } else if (c == '<') {
                    writer.write(LT_FULL);
                } else if (c >= '\ud800' && c <= '\udc00') {
                    n3 = string.charAt(++n);
                    int n4 = (c - 55296 << 10) + (n3 - 56320) + 65536;
                    writer.write("&#x");
                    writer.write(Integer.toHexString(n4));
                    writer.write(59);
                } else if (c < ' ' && !XMLUtil.isXMLWhitespace(c)) {
                    writer.write("&#x");
                    writer.write(Integer.toHexString(63743 - c));
                    writer.write(59);
                } else {
                    writer.write(c);
                    if (c == ']' && n + 2 < n2 && string.charAt(n + 1) == '[' && string.charAt(n + 2) == '>') {
                        n += 2;
                        writer.write(c);
                        writer.write(GT_FULL);
                    }
                }
                ++n;
            }
            catch (CharEncodingException charEncodingException) {
                writer.write("&#x");
                n3 = charEncodingException.getValue();
                writer.write(Integer.toHexString(n3));
                writer.write(59);
                n += n3 < 65535 ? 1 : 2;
            }
        }
    }

    private static void writeAlreadyEscaped(Writer writer, String string) throws IOException {
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            int n3;
            try {
                char c = string.charAt(n);
                if (c >= '\ud800' && c <= '\udc00') {
                    n3 = string.charAt(++n);
                    int n4 = (c - 55296 << 10) + (n3 - 56320) + 65536;
                    writer.write("&#x");
                    writer.write(Integer.toHexString(n4));
                    writer.write(59);
                } else if (c < ' ' && !XMLUtil.isXMLWhitespace(c)) {
                    writer.write("&#x");
                    writer.write(Integer.toHexString(63743 - c));
                    writer.write(59);
                } else {
                    writer.write(c);
                }
                ++n;
            }
            catch (CharEncodingException charEncodingException) {
                writer.write("&#x");
                n3 = charEncodingException.getValue();
                writer.write(Integer.toHexString(n3));
                writer.write(59);
                n += n3 < 65535 ? 1 : 2;
            }
        }
    }

    public static void encodeAttribute(Writer writer, String string) throws IOException {
        boolean bl;
        boolean bl2 = string.indexOf(34) != -1;
        boolean bl3 = string.indexOf(39) != -1;
        boolean bl4 = string.indexOf(10) != -1;
        boolean bl5 = string.indexOf(13) != -1;
        boolean bl6 = bl = string.indexOf(9) != -1;
        if (bl2 && bl3 || bl4 || bl5 || bl) {
            String string2 = XMLUtil.toXML(string, "\"\n\r\t");
            writer.write(34);
            XMLUtil.writeAlreadyEscaped(writer, string2);
            writer.write(34);
        } else if (bl2) {
            writer.write(39);
            XMLUtil.encodeText(writer, string);
            writer.write(39);
        } else {
            writer.write(34);
            XMLUtil.encodeText(writer, string);
            writer.write(34);
        }
    }

    public static void encodeAsCData(Writer writer, String string) throws IOException {
        int n = 0;
        while (true) {
            try {
                writer.write("<![CDATA[");
                while (n < string.length()) {
                    char c = string.charAt(n);
                    if (c < ' ' && !XMLUtil.isXMLWhitespace(c)) {
                        throw new CharEncodingException(c, n, 0);
                    }
                    writer.write(c);
                    if (c == ']' && n + 2 < string.length() && string.charAt(n + 1) == ']' && string.charAt(n + 2) == '>') {
                        writer.write(string.charAt(++n));
                        writer.write("]]>");
                        writer.write("<![CDATA[");
                    }
                    ++n;
                }
                writer.write("]]>");
                return;
            }
            catch (CharEncodingException charEncodingException) {
                writer.write("]]>");
                writer.write("&#x");
                int n2 = charEncodingException.getValue();
                if (n2 < 32 && !XMLUtil.isXMLWhitespace((char)n2)) {
                    n2 = 63743 - n2;
                }
                writer.write(Integer.toHexString(n2));
                writer.write(59);
                if ((n += n2 < 65535 ? 1 : 2) < string.length()) continue;
                return;
            }
            break;
        }
    }

    public static String replaceBuiltInEntities(String string) {
        StringBuffer stringBuffer = new StringBuffer(64);
        int n = 0;
        while (true) {
            char c;
            int n2;
            if ((n2 = string.indexOf(38, n)) == -1) {
                stringBuffer.append(string.substring(n, string.length()));
                return stringBuffer.toString();
            }
            if (string.charAt(++n2) == '#') {
                String string2;
                if (string.charAt(++n2) == 'x') {
                    string2 = HEX_DIGITS;
                    c = '\u0010';
                } else {
                    string2 = DIGITS;
                    c = '\n';
                }
                int n3 = ++n2;
                while (string2.indexOf(string.charAt(n2)) != -1) {
                    ++n2;
                }
                stringBuffer.append((char)Integer.valueOf(string.substring(n3, n2), c).intValue());
            } else {
                int n4 = string.indexOf(59, n2);
                if (n4 != -1) {
                    c = '\u0000';
                    String string3 = string.substring(n2, n4);
                    int n5 = 0;
                    while (n5 < 5) {
                        if (XMLUtil.BUILT_IN_REFS[n5].reference.equals(string3)) {
                            c = XMLUtil.BUILT_IN_REFS[n5].value;
                            break;
                        }
                        ++n5;
                    }
                    if (c != '\u0000') {
                        stringBuffer.append(c);
                    } else {
                        stringBuffer.append('&');
                        stringBuffer.append(string.substring(n2, n4 + 1));
                        n2 = n4;
                    }
                }
            }
            if (string.charAt(n2) != ';') continue;
            ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getPseudoAttribute(String string, String string2) {
        try {
            char c;
            char c2 = string2.charAt(0);
            int n = 0;
            int n2 = string.length();
            while (n < n2) {
                char c3 = string.charAt(n);
                if (c3 == c2) {
                    if (string2.length() == 1 || string.substring(n, n + string2.length()).equals(string2)) {
                        n += string2.length();
                        break;
                    }
                } else if ((c3 == '\"' || c3 == '\'') && (n = string.indexOf(c3, n + 1)) == -1) {
                    return "";
                }
                ++n;
            }
            if (n >= n2) {
                return "";
            }
            while (true) {
                if (!XMLUtil.isXMLWhitespace(string.charAt(n))) {
                    if (string.charAt(n) == '=') break;
                    return "";
                }
                ++n;
            }
            ++n;
            while (true) {
                if (!XMLUtil.isXMLWhitespace(string.charAt(n))) {
                    c = string.charAt(n);
                    if (c == '\"' || c == '\'') break;
                    return "";
                }
                ++n;
            }
            int n3 = ++n;
            while (true) {
                if (string.charAt(n) == c) {
                    String string3 = string.substring(n3, n);
                    return XMLUtil.replaceBuiltInEntities(string3);
                }
                ++n;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return "";
        }
    }

    public static String getLocalName(String string) {
        int n = string.indexOf(58);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    public static String getPrefix(String string) {
        int n = string.indexOf(58);
        if (n == -1) {
            return "";
        }
        return string.substring(0, n);
    }

    private XMLUtil() {
    }
}

