/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.xpath;

import com.novell.xml.xpath.ContextListMark;
import com.novell.xml.xpath.ContextNodeList;
import com.novell.xml.xpath.WhitespaceStripper;
import com.novell.xml.xpath.XPathEvaluationException;
import org.w3c.dom.Node;

public abstract class Axis
implements ContextNodeList {
    private Node contextNode;
    private int index;
    private int count;
    protected WhitespaceStripper stripper;

    public void setup(Node node, WhitespaceStripper whitespaceStripper) {
        this.contextNode = node;
        this.stripper = whitespaceStripper;
    }

    public void done() {
        this.contextNode = null;
        this.stripper = null;
    }

    public abstract int principalNodeType();

    public abstract String toString();

    public int count() throws XPathEvaluationException {
        if (this.count == -1) {
            ContextListMark contextListMark = this.getMark();
            this.count = this.position();
            while (this.next() != null) {
            }
            int n = this.position();
            this.returnToMark(contextListMark);
            this.count = n;
        }
        return this.count;
    }

    public int position() {
        return this.index;
    }

    public int order() {
        return 1;
    }

    protected void init() {
        this.index = 0;
        this.count = -1;
    }

    protected Node incPosition(Node node) {
        if (node != null) {
            ++this.index;
        }
        return node;
    }

    protected Node getContextNode() {
        return this.contextNode;
    }

    protected boolean stripNode(Node node) {
        switch (node.getNodeType()) {
            case 3: 
            case 4: {
                return this.stripper.stripNode(node);
            }
        }
        return false;
    }

    protected Axis() {
        this.init();
    }

    protected class AxisMark
    implements ContextListMark {
        private int index;
        private int count;
        private Node contextNode;

        public AxisMark(Axis axis2) {
            this.contextNode = axis2.contextNode;
            this.index = axis2.index;
            this.count = axis2.count;
        }

        public void restoreState(Axis axis) {
            axis.contextNode = this.contextNode;
            axis.index = this.index;
            axis.count = this.count;
        }
    }
}

