/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.xpath;

import com.novell.xml.dom.NodeImpl;
import com.novell.xml.util.XMLUtil;
import com.novell.xml.xpath.Axis;
import com.novell.xml.xpath.ContextListMark;
import com.novell.xml.xpath.XPathAttributeNode;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class AxisAttribute
extends Axis {
    NamedNodeMap nodeMap;
    Node lastNode;
    int mapIndex;

    public String toString() {
        return "attribute";
    }

    public Node first() {
        this.init();
        if (this.getContextNode() != null) {
            this.nodeMap = this.getContextNode().getAttributes();
            this.mapIndex = -1;
        }
        return this.next();
    }

    public void done() {
        super.done();
        this.nodeMap = null;
        this.lastNode = null;
    }

    public Node next() {
        Node node = null;
        if (this.nodeMap != null) {
            while ((node = this.nodeMap.item(++this.mapIndex)) != null && !this.isAttributeNode(node)) {
            }
            if (node != null) {
                if (node instanceof NodeImpl) {
                    ((NodeImpl)node).setXPathBehavior(true);
                } else {
                    node = new XPathAttributeNode(node, this.getContextNode());
                }
            }
        }
        this.lastNode = node;
        return this.incPosition(node);
    }

    public int principalNodeType() {
        return 2;
    }

    public ContextListMark getMark() {
        return new Mark(this);
    }

    public Node returnToMark(ContextListMark contextListMark) {
        ((Mark)contextListMark).restoreState(this);
        return this.lastNode;
    }

    private boolean isAttributeNode(Node node) {
        return !XMLUtil.isNamespaceDecl(node.getNodeName());
    }

    protected class Mark
    extends Axis.AxisMark {
        int index;
        Node lastNode;

        public Mark(AxisAttribute axisAttribute2) {
            super(axisAttribute2);
            AxisAttribute.this.mapIndex = axisAttribute2.mapIndex;
            this.lastNode = axisAttribute2.lastNode;
        }

        public void restoreState(AxisAttribute axisAttribute) {
            super.restoreState(axisAttribute);
            axisAttribute.mapIndex = AxisAttribute.this.mapIndex;
            axisAttribute.lastNode = this.lastNode;
        }
    }
}

