/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.xpath;

import com.novell.xml.xpath.Axis;
import com.novell.xml.xpath.AxisElement;
import com.novell.xml.xpath.ContextListMark;
import com.novell.xml.xpath.XPathUtil;
import org.w3c.dom.Node;

public class AxisDescendant
extends AxisElement {
    protected Node child;

    public String toString() {
        return "descendant";
    }

    public void done() {
        super.done();
        this.child = null;
    }

    public Node first() {
        this.init();
        this.child = this.getContextNode();
        this.child = this.child.getNodeType() == 2 ? null : this.child.getFirstChild();
        return this.incPosition(this.child);
    }

    public Node next() {
        if (this.child != null) {
            Node node = this.child;
            do {
                if (this.child.hasChildNodes()) {
                    node = this.child = this.child.getFirstChild();
                    continue;
                }
                this.child = XPathUtil.getNextSibling(this.child);
                while (this.child == null && node != null) {
                    node = this.child = node.getParentNode();
                    if (this.child != this.getContextNode() && this.child != null) {
                        this.child = XPathUtil.getNextSibling(this.child);
                        continue;
                    }
                    this.child = null;
                    node = null;
                }
            } while (this.child != null && this.stripNode(this.child));
        }
        return this.incPosition(this.child);
    }

    public ContextListMark getMark() {
        return new Mark(this);
    }

    public Node returnToMark(ContextListMark contextListMark) {
        ((Mark)contextListMark).restoreState(this);
        return this.child;
    }

    protected class Mark
    extends Axis.AxisMark {
        private Node child;

        public Mark(AxisDescendant axisDescendant2) {
            super(axisDescendant2);
            this.child = axisDescendant2.child;
        }

        public void restoreState(AxisDescendant axisDescendant) {
            super.restoreState(axisDescendant);
            axisDescendant.child = this.child;
        }
    }
}

