/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.xpath;

import com.novell.xml.xpath.Binder;
import com.novell.xml.xpath.Token;

public class AxisNameToken
extends Token {
    public static final int NOT_AXIS = 0;
    public static final int ANCESTOR = 1;
    public static final int ANCESTOR_OR_SELF = 2;
    public static final int ATTRIBUTE = 3;
    public static final int CHILD = 4;
    public static final int DESCENDANT = 5;
    public static final int DESCENDANT_OR_SELF = 6;
    public static final int FOLLOWING = 7;
    public static final int FOLLOWING_SIBLING = 8;
    public static final int NAMESPACE = 9;
    public static final int PARENT = 10;
    public static final int PRECEDING = 11;
    public static final int PRECEDING_SIBLING = 12;
    public static final int SELF = 13;
    private static final int AXIS_COUNT = 13;
    public static final String ANCESTOR_STRING = "ancestor";
    public static final String ANCESTOR_OR_SELF_STRING = "ancestor-or-self";
    public static final String ATTRIBUTE_STRING = "attribute";
    public static final String CHILD_STRING = "child";
    public static final String DESCENDANT_STRING = "descendant";
    public static final String DESCENDANT_OR_SELF_STRING = "descendant-or-self";
    public static final String FOLLOWING_STRING = "following";
    public static final String FOLLOWING_SIBLING_STRING = "following-sibling";
    public static final String NAMESPACE_STRING = "namespace";
    public static final String PARENT_STRING = "parent";
    public static final String PRECEDING_STRING = "preceding";
    public static final String PRECEDING_SIBLING_STRING = "preceding-sibling";
    public static final String SELF_STRING = "self";
    private static final Binder[] BINDER = new Binder[]{new Binder(1, "ancestor"), new Binder(2, "ancestor-or-self"), new Binder(3, "attribute"), new Binder(4, "child"), new Binder(5, "descendant"), new Binder(6, "descendant-or-self"), new Binder(7, "following"), new Binder(8, "following-sibling"), new Binder(9, "namespace"), new Binder(10, "parent"), new Binder(11, "preceding"), new Binder(12, "preceding-sibling"), new Binder(13, "self")};
    private int id;

    public AxisNameToken(int n) {
        super(14);
        if (n <= 0 || n > 13) {
            throw new Error("AxisNameToken: Invalid Axis name id in constructor");
        }
        this.id = n;
    }

    public AxisNameToken(String string) {
        super(14);
        this.id = AxisNameToken.getAxisIdentifier(string);
        if (this.id == 0) {
            throw new Error("AxisNameToken: Invalid Axis name string in constructor");
        }
    }

    public boolean equals(Token token) {
        return super.equals(token) && this.getId() == ((AxisNameToken)token).getId();
    }

    public static int getAxisIdentifier(String string) {
        char c = string.charAt(0);
        int n = 0;
        while (n < 13) {
            char c2 = AxisNameToken.BINDER[n].text.charAt(0);
            if (c < c2) break;
            if (c == c2 && string.equals(AxisNameToken.BINDER[n].text)) {
                return AxisNameToken.BINDER[n].id;
            }
            ++n;
        }
        return 0;
    }

    public static String getAxisName(int n) {
        if (n <= 0 || n > 13) {
            return "";
        }
        return AxisNameToken.BINDER[n - 1].text;
    }

    public int getId() {
        return this.id;
    }

    public String toString() {
        return super.toString() + "{" + AxisNameToken.getAxisName(this.getId()) + "}";
    }
}

