/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.xpath;

import com.novell.xml.dom.DOMUtil;
import com.novell.xml.util.ExpandedQName;
import com.novell.xml.util.NamespaceName;
import com.novell.xml.xpath.Axis;
import com.novell.xml.xpath.AxisAncestor;
import com.novell.xml.xpath.AxisAncestorOrSelf;
import com.novell.xml.xpath.AxisAttribute;
import com.novell.xml.xpath.AxisChild;
import com.novell.xml.xpath.AxisDescendant;
import com.novell.xml.xpath.AxisDescendantOrSelf;
import com.novell.xml.xpath.AxisFollowing;
import com.novell.xml.xpath.AxisFollowingSibling;
import com.novell.xml.xpath.AxisNameToken;
import com.novell.xml.xpath.AxisNamespace;
import com.novell.xml.xpath.AxisParent;
import com.novell.xml.xpath.AxisPreceding;
import com.novell.xml.xpath.AxisPrecedingSibling;
import com.novell.xml.xpath.AxisSelf;
import com.novell.xml.xpath.ContextListMark;
import com.novell.xml.xpath.ContextNodeList;
import com.novell.xml.xpath.ExpressionContext;
import com.novell.xml.xpath.NamespaceContext;
import com.novell.xml.xpath.NodeTest;
import com.novell.xml.xpath.NodeType;
import com.novell.xml.xpath.NodeTypePI;
import com.novell.xml.xpath.NodeTypeToken;
import com.novell.xml.xpath.WildcardName;
import com.novell.xml.xpath.WildcardNameToken;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xml.xpath.XPathException;
import org.w3c.dom.Node;

public class Basis
implements ContextNodeList {
    private Node contextNode = null;
    private ExpressionContext context = null;
    private Node currentNode = null;
    private Axis axis;
    private NodeTest nodeTest;
    private int index;
    private int count;

    public Basis(Axis axis, NodeTest nodeTest) {
        this.axis = axis;
        this.nodeTest = nodeTest;
        if (this.nodeTest instanceof WildcardName) {
            ((WildcardName)this.nodeTest).setPrincipalNodeType(this.axis.principalNodeType());
        }
    }

    public Basis(AxisNameToken axisNameToken, NodeTest nodeTest) {
        this.createAxis(axisNameToken);
        this.nodeTest = nodeTest;
        if (nodeTest instanceof WildcardName) {
            ((WildcardName)nodeTest).setPrincipalNodeType(this.axis.principalNodeType());
        }
    }

    public Basis(AxisNameToken axisNameToken, NodeTypeToken nodeTypeToken) {
        this.createAxis(axisNameToken);
        this.nodeTest = new NodeType(nodeTypeToken);
    }

    public Basis(AxisNameToken axisNameToken, NodeTypeToken nodeTypeToken, String string) throws XPathException, Exception {
        this.createAxis(axisNameToken);
        if (nodeTypeToken.getNodeType() != 3) {
            throw new Exception("Only pi() may have a literal argument");
        }
        this.nodeTest = new NodeTypePI(string);
    }

    public Basis(AxisNameToken axisNameToken, WildcardNameToken wildcardNameToken, NamespaceContext namespaceContext) throws XPathException {
        this.createAxis(axisNameToken);
        this.nodeTest = new WildcardName(wildcardNameToken, namespaceContext);
        ((WildcardName)this.nodeTest).setPrincipalNodeType(this.axis.principalNodeType());
    }

    public String toString() {
        return this.axis.toString() + "::" + this.nodeTest.toString();
    }

    public void setup(Node node, ExpressionContext expressionContext) {
        this.contextNode = node;
        this.context = expressionContext;
    }

    public void done() {
        this.contextNode = null;
        this.context = null;
        this.axis.done();
    }

    public Node first() throws XPathEvaluationException {
        this.init();
        if (this.contextNode == null) {
            return null;
        }
        this.axis.setup(this.contextNode, this.context);
        this.currentNode = this.axis.first();
        if (this.currentNode != null) {
            while (this.currentNode != null && !this.nodeTest.evaluate(this.currentNode)) {
                this.currentNode = this.axis.next();
            }
        }
        return this.incPosition(this.currentNode);
    }

    public Node next() throws XPathEvaluationException {
        this.currentNode = this.axis.next();
        while (this.currentNode != null && !this.nodeTest.evaluate(this.currentNode)) {
            this.currentNode = this.axis.next();
        }
        return this.incPosition(this.currentNode);
    }

    public int count() throws XPathEvaluationException {
        if (this.count == -1) {
            if (this.nodeTest instanceof NodeType && ((NodeType)this.nodeTest).getNodeType() == 2) {
                this.count = this.axis.count();
            } else {
                ContextListMark contextListMark = this.getMark();
                while (this.next() != null) {
                }
                int n = this.position();
                this.returnToMark(contextListMark);
                this.count = n;
            }
        }
        return this.count;
    }

    public int position() {
        return this.index;
    }

    public int order() {
        return this.axis.order();
    }

    public ContextListMark getMark() {
        return new Mark(this);
    }

    public Node returnToMark(ContextListMark contextListMark) {
        ((Mark)contextListMark).restoreState(this);
        return this.currentNode;
    }

    public NamespaceName getNamespaceName(String string) {
        if (string == null || string.length() <= 0 || this.contextNode == null) {
            return NamespaceName.NULL_NAMESPACE;
        }
        return new NamespaceName(DOMUtil.getURIforNSPrefix(string, this.contextNode));
    }

    public ExpandedQName getExpandedName(String string) {
        return new ExpandedQName(string, this.contextNode);
    }

    protected void createAxis(AxisNameToken axisNameToken) {
        switch (axisNameToken.getId()) {
            case 1: {
                this.axis = new AxisAncestor();
                break;
            }
            case 2: {
                this.axis = new AxisAncestorOrSelf();
                break;
            }
            case 3: {
                this.axis = new AxisAttribute();
                break;
            }
            case 5: {
                this.axis = new AxisDescendant();
                break;
            }
            case 6: {
                this.axis = new AxisDescendantOrSelf();
                break;
            }
            case 7: {
                this.axis = new AxisFollowing();
                break;
            }
            case 8: {
                this.axis = new AxisFollowingSibling();
                break;
            }
            case 9: {
                this.axis = new AxisNamespace();
                break;
            }
            case 10: {
                this.axis = new AxisParent();
                break;
            }
            case 11: {
                this.axis = new AxisPreceding();
                break;
            }
            case 12: {
                this.axis = new AxisPrecedingSibling();
                break;
            }
            case 13: {
                this.axis = new AxisSelf();
                break;
            }
            default: {
                this.axis = new AxisChild();
            }
        }
    }

    protected void init() {
        this.index = 0;
        this.count = -1;
    }

    protected Node incPosition(Node node) {
        if (node != null) {
            ++this.index;
        }
        return node;
    }

    private class Mark
    implements ContextListMark {
        private Node contextNode;
        private Node currentNode;
        private ContextListMark axisMark;
        private int index;
        private int count;

        public Mark(Basis basis2) {
            this.contextNode = basis2.contextNode;
            this.currentNode = basis2.currentNode;
            this.axisMark = basis2.axis.getMark();
            this.index = basis2.index;
            this.count = basis2.count;
        }

        public void restoreState(Basis basis) {
            basis.contextNode = this.contextNode;
            basis.currentNode = this.currentNode;
            basis.axis.returnToMark(this.axisMark);
            basis.index = this.index;
            basis.count = this.count;
        }
    }
}

