/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.xpath;

import com.novell.xml.xpath.BooleanExpr;
import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.NodeSet;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xml.xpath.XPathUtil;
import org.w3c.dom.Node;

public abstract class ComparisonExpr
extends BooleanExpr
implements Expression {
    protected ComparisonExpr(Expression expression, Expression expression2) {
        super(expression, expression2);
    }

    protected boolean compareOperands(ExpressionValue expressionValue, ExpressionValue expressionValue2, int n) throws XPathEvaluationException {
        boolean bl = false;
        int n2 = expressionValue.getValueType();
        int n3 = expressionValue2.getValueType();
        if (n2 == 3 || n3 == 3) {
            if (n3 == 3 && n2 != 3) {
                int n4 = n2;
                n2 = n3;
                n3 = n4;
                ExpressionValue expressionValue3 = expressionValue;
                expressionValue = expressionValue2;
                expressionValue2 = expressionValue3;
                n = -n;
            }
            switch (n3) {
                case 0: {
                    bl = this.compareBooleans(expressionValue.getBooleanValue(), expressionValue2.getBooleanValue(), n);
                    break;
                }
                case 1: {
                    bl = this.compareNodeSetAndNumber(expressionValue.getNodeSetValue(), expressionValue2.getNumberValue(), n);
                    break;
                }
                case 2: {
                    bl = this.compareNodeSetAndString(expressionValue.getNodeSetValue(), expressionValue2.getStringValue(), n);
                    break;
                }
                case 3: {
                    bl = this.compareNodeSets(expressionValue.getNodeSetValue(), expressionValue2.getNodeSetValue(), n);
                    break;
                }
                default: {
                    bl = this.compareNodeSetAndString(expressionValue.getNodeSetValue(), expressionValue2.getStringValue(), n);
                    break;
                }
            }
        } else {
            bl = n2 == 0 || n3 == 0 ? this.compareBooleans(expressionValue.getBooleanValue(), expressionValue2.getBooleanValue(), n) : (n2 == 1 || n3 == 1 ? this.compareNumbers(expressionValue.getNumberValue(), expressionValue2.getNumberValue(), n) : (n != 0 && n != 3 && n != -3 ? this.compareNumbers(expressionValue.getNumberValue(), expressionValue2.getNumberValue(), n) : this.compareStrings(expressionValue.getStringValue(), expressionValue2.getStringValue(), n)));
        }
        return bl;
    }

    protected boolean compareNodeSets(NodeSet nodeSet, NodeSet nodeSet2, int n) {
        if (nodeSet.isEmpty() || nodeSet2.isEmpty()) {
            return false;
        }
        Node node = nodeSet.first();
        while (node != null) {
            String string = XPathUtil.getNodeValue(node);
            Node node2 = nodeSet2.first();
            while (node2 != null) {
                if (this.compareStrings(string, XPathUtil.getNodeValue(node2), n)) {
                    return true;
                }
                node2 = nodeSet2.next();
            }
            node = nodeSet.next();
        }
        return false;
    }

    protected boolean compareNodeSetAndString(NodeSet nodeSet, String string, int n) {
        if (nodeSet.isEmpty()) {
            return false;
        }
        Node node = nodeSet.first();
        while (node != null) {
            if (this.compareStrings(XPathUtil.getNodeValue(node), string, n)) {
                return true;
            }
            node = nodeSet.next();
        }
        return false;
    }

    protected boolean compareNodeSetAndNumber(NodeSet nodeSet, double d, int n) {
        if (nodeSet.isEmpty()) {
            return false;
        }
        Node node = nodeSet.first();
        while (node != null) {
            double d2 = Double.valueOf(XPathUtil.getNodeValue(node));
            if (this.compareNumbers(d2, d, n)) {
                return true;
            }
            node = nodeSet.next();
        }
        return false;
    }

    protected boolean compareBooleans(boolean bl, boolean bl2, int n) {
        boolean bl3;
        boolean bl4 = bl;
        boolean bl5 = bl3 = bl2;
        if (n == -3 || n == 3) {
            return bl4 != bl3;
        }
        if (n == -2) {
            return bl4 < bl3;
        }
        if (n == -1) {
            return bl4 <= bl3;
        }
        if (n == 0) {
            return bl4 == bl3;
        }
        if (n == 1) {
            return bl4 >= bl3;
        }
        if (n == 2) {
            return bl4 > bl3;
        }
        return false;
    }

    protected boolean compareNumbers(double d, double d2, int n) {
        if (n == -3 || n == 3) {
            return d != d2;
        }
        if (n == -2) {
            return d < d2;
        }
        if (n == -1) {
            return d <= d2;
        }
        if (n == 0) {
            return d == d2;
        }
        if (n == 1) {
            return d >= d2;
        }
        if (n == 2) {
            return d > d2;
        }
        return false;
    }

    protected boolean compareStrings(String string, String string2, int n) {
        int n2 = string.compareTo(string2);
        if (n == -3 || n == 3) {
            return n2 != 0;
        }
        if (n2 < 0) {
            return n < 0;
        }
        if (n2 > 0) {
            return n > 0;
        }
        if (n2 == 0) {
            return n >= -1 && n <= 1;
        }
        return false;
    }
}

