/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.xpath;

import com.novell.xml.dom.DOMUtil;
import com.novell.xml.util.ExpandedQName;
import com.novell.xml.util.NamespaceName;
import com.novell.xml.xpath.ContextListMark;
import com.novell.xml.xpath.ContextNodeList;
import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.NamespaceContext;
import com.novell.xml.xpath.WhitespaceStripper;
import com.novell.xml.xpath.XPathEvaluationException;
import java.util.Stack;
import org.w3c.dom.Node;

public class ExpressionContext
implements NamespaceContext,
ContextNodeList,
WhitespaceStripper {
    private ContextNodeList contextNodeList;
    private Node namespaceContext;
    private Stack stack = new Stack();
    private Node currentNode;

    public ExpressionContext() {
    }

    public ExpressionContext(ExpressionContext expressionContext) {
        this.namespaceContext = expressionContext.namespaceContext;
        this.contextNodeList = expressionContext.contextNodeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExpressionValue evaluate(Node node, Expression expression) throws XPathEvaluationException {
        ExpressionValue expressionValue;
        this.currentNode = node;
        try {
            expressionValue = expression.evaluate(node, this);
            Object var5_4 = null;
            this.currentNode = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.currentNode = null;
            throw throwable;
        }
        return expressionValue;
    }

    public void pushState() {
        this.stack.push(new State(this));
    }

    public void popState() {
        ((State)this.stack.pop()).restoreState(this);
    }

    public void setContextNodeList(ContextNodeList contextNodeList) {
        this.contextNodeList = contextNodeList;
    }

    public void setNamespaceContext(Node node) {
        this.namespaceContext = node;
    }

    public Node getCurrentNode() {
        return this.currentNode;
    }

    public NamespaceName getNamespaceName(String string) {
        Node node = this.getNamespaceContext();
        if (string == null || string.length() <= 0 || node == null) {
            return NamespaceName.NULL_NAMESPACE;
        }
        String string2 = DOMUtil.getURIforNSPrefix(string, node);
        if (string2 == null) {
            return NamespaceName.NULL_NAMESPACE;
        }
        return new NamespaceName(string2);
    }

    public ExpandedQName getExpandedName(String string) {
        return new ExpandedQName(string, this.getNamespaceContext());
    }

    public Node first() throws XPathEvaluationException {
        return this.contextNodeList == null ? null : this.contextNodeList.first();
    }

    public Node next() throws XPathEvaluationException {
        return this.contextNodeList == null ? null : this.contextNodeList.next();
    }

    public int count() throws XPathEvaluationException {
        return this.contextNodeList == null ? 0 : this.contextNodeList.count();
    }

    public int position() {
        return this.contextNodeList == null ? 0 : this.contextNodeList.position();
    }

    public int order() {
        return this.contextNodeList == null ? 1 : this.contextNodeList.order();
    }

    public ContextListMark getMark() {
        return this.contextNodeList == null ? null : this.contextNodeList.getMark();
    }

    public Node returnToMark(ContextListMark contextListMark) {
        if (this.contextNodeList != null) {
            return this.contextNodeList.returnToMark(contextListMark);
        }
        return null;
    }

    public boolean stripNode(Node node) {
        return false;
    }

    protected Node getNamespaceContext() {
        return this.namespaceContext;
    }

    protected class State {
        private ContextNodeList contextNodeList;
        private Node namespaceContext;

        public State(ExpressionContext expressionContext2) {
            this.contextNodeList = expressionContext2.contextNodeList;
            this.namespaceContext = expressionContext2.namespaceContext;
        }

        public void restoreState(ExpressionContext expressionContext) {
            expressionContext.contextNodeList = this.contextNodeList;
            expressionContext.namespaceContext = this.namespaceContext;
        }
    }
}

