/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.xpath;

import com.novell.xml.xpath.ContextListMark;
import com.novell.xml.xpath.ContextNodeList;
import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.ExpressionContext;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.XPathEvaluationException;
import org.w3c.dom.Node;

public class Predicate
implements ContextNodeList {
    private Expression expr;
    private ExpressionContext context = null;
    private Node currentNode;
    private int index;
    private int count;

    public Predicate(Expression expression) {
        this.expr = expression;
    }

    public String toString() {
        return "[" + this.expr.toString() + "]";
    }

    public void setup(ExpressionContext expressionContext) {
        this.context = expressionContext;
    }

    public void done() {
        this.context = null;
    }

    public Node first() throws XPathEvaluationException {
        this.init();
        if (this.context == null) {
            return null;
        }
        this.currentNode = this.context.first();
        while (this.currentNode != null && !this.evaluate(this.currentNode)) {
            this.currentNode = this.context.next();
        }
        return this.incPosition(this.currentNode);
    }

    public Node next() throws XPathEvaluationException {
        if (this.context == null) {
            return null;
        }
        this.currentNode = this.context.next();
        while (this.currentNode != null && !this.evaluate(this.currentNode)) {
            this.currentNode = this.context.next();
        }
        return this.incPosition(this.currentNode);
    }

    public int position() {
        return this.index;
    }

    public int count() throws XPathEvaluationException {
        if (this.count == -1) {
            ContextListMark contextListMark = this.getMark();
            this.count = this.position();
            while (this.next() != null) {
            }
            int n = this.position();
            this.returnToMark(contextListMark);
            this.count = n;
        }
        return this.count;
    }

    public int order() {
        return this.context == null ? 1 : this.context.order();
    }

    public ContextListMark getMark() {
        return new Mark(this);
    }

    public Node returnToMark(ContextListMark contextListMark) {
        ((Mark)contextListMark).restoreState(this);
        return this.currentNode;
    }

    private Node incPosition(Node node) {
        if (node != null) {
            ++this.index;
        }
        return node;
    }

    private boolean evaluate(Node node) throws XPathEvaluationException {
        int n = this.context.position();
        ExpressionValue expressionValue = this.expr.evaluate(node, this.context);
        if (expressionValue.getValueType() == 1) {
            return (double)n == expressionValue.getNumberValue();
        }
        return expressionValue.getBooleanValue();
    }

    private void init() {
        this.index = 0;
        this.count = -1;
        this.currentNode = null;
    }

    private class Mark
    implements ContextListMark {
        private int index;
        private int count;
        private ContextListMark contextMark;
        private Node currentNode;

        public Mark(Predicate predicate2) {
            this.index = predicate2.index;
            this.count = predicate2.count;
            this.contextMark = predicate2.context.getMark();
            this.currentNode = predicate2.currentNode;
        }

        public void restoreState(Predicate predicate) {
            predicate.index = this.index;
            predicate.count = this.count;
            predicate.context.returnToMark(this.contextMark);
            predicate.currentNode = this.currentNode;
        }
    }
}

