/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.xpath;

import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.ExpressionContext;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.NodeSet;
import com.novell.xml.xpath.NodeSetExpr;
import com.novell.xml.xpath.Step;
import com.novell.xml.xpath.XPathEvaluationException;
import org.w3c.dom.Node;

public class RelativeLocationPath
extends NodeSetExpr
implements Expression {
    private Step[] steps;

    public RelativeLocationPath(Step step) {
        this.steps = new Step[1];
        this.steps[0] = step;
    }

    public RelativeLocationPath(Step[] stepArray) {
        this.steps = stepArray;
    }

    public RelativeLocationPath(RelativeLocationPath relativeLocationPath, RelativeLocationPath relativeLocationPath2) {
        this.steps = new Step[relativeLocationPath.steps.length + relativeLocationPath2.steps.length];
        int n = 0;
        while (n < relativeLocationPath.steps.length) {
            this.steps[n] = relativeLocationPath.steps[n];
            ++n;
        }
        int n2 = 0;
        while (n2 < relativeLocationPath2.steps.length) {
            this.steps[n] = relativeLocationPath2.steps[n2];
            ++n;
            ++n2;
        }
    }

    public String toString() {
        String string = this.steps[0].toString();
        int n = 1;
        while (n < this.steps.length) {
            string = string + "/" + this.steps[n].toString();
            ++n;
        }
        return string;
    }

    public ExpressionValue evaluate(Node node, ExpressionContext expressionContext) throws XPathEvaluationException {
        NodeSet nodeSet = new NodeSet();
        this.evalStep(nodeSet, 0, node, expressionContext);
        return nodeSet;
    }

    protected void evalStep(NodeSet nodeSet, int n, Node node, ExpressionContext expressionContext) throws XPathEvaluationException {
        if (n >= this.steps.length) {
            nodeSet.add(node);
            return;
        }
        this.steps[n].setup(node, expressionContext);
        Node node2 = this.steps[n].first();
        while (node2 != null) {
            this.evalStep(nodeSet, n + 1, node2, expressionContext);
            node2 = this.steps[n].next();
        }
        this.steps[n].done();
    }
}

