/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.xpath;

import com.novell.xml.util.XMLUtil;
import com.novell.xml.xpath.AxisNameToken;
import com.novell.xml.xpath.FunctionNameToken;
import com.novell.xml.xpath.LiteralToken;
import com.novell.xml.xpath.NodeTypeToken;
import com.novell.xml.xpath.NumberToken;
import com.novell.xml.xpath.OperatorToken;
import com.novell.xml.xpath.QName;
import com.novell.xml.xpath.Token;
import com.novell.xml.xpath.VariableRefToken;
import com.novell.xml.xpath.WildcardNameToken;
import com.novell.xml.xpath.XPathParserException;
import java.util.Vector;

public class Scanner {
    private String input;
    private int index;
    private Vector tokens;
    private final int[] posStack = new int[8];
    private int stackTop;
    protected static final char EAT_CHAR = '\ufffd';

    public Scanner(String string) {
        this.input = string;
        this.index = 0;
        this.tokens = new Vector(8, 8);
    }

    public Token[] scan() throws XPathParserException {
        char c;
        this.reset();
        while ((c = this.getNextXMLChar()) != '\u0000') {
            if (XMLUtil.isNCName(c)) {
                this.handleQName(this.scanQName(c));
                continue;
            }
            if (c == '\"' || c == '\'') {
                this.handleLiteral(c);
                continue;
            }
            if (this.isDigit(c)) {
                this.handleNumber(c);
                continue;
            }
            this.handleChar(c);
        }
        this.done();
        return this.returnTokens();
    }

    public static double scanNumber(String string) {
        boolean bl = false;
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '.') {
                if (bl) {
                    return Double.NaN;
                }
                bl = true;
            } else if (c < '0' || c > '9') {
                return Double.NaN;
            }
            ++n;
        }
        return Double.valueOf(string);
    }

    protected char prescanChar(char c) {
        return c;
    }

    protected void done() {
    }

    protected void handleQName(QName qName) throws XPathParserException {
        char c;
        if (qName.getPrefix().length() == 0) {
            this.pushPos();
            c = this.getNextXMLChar();
            if (c == ':') {
                c = this.getNextChar();
                if (c == '*') {
                    this.tossPos();
                    this.appendToken(new WildcardNameToken(qName.getName(), "*"));
                    return;
                }
                if (c == ':') {
                    this.popPos();
                    int n = AxisNameToken.getAxisIdentifier(qName.getName());
                    if (n == 0) {
                        throw new XPathParserException("pe1");
                    }
                    this.appendToken(new AxisNameToken(n));
                    return;
                }
            }
            this.popPos();
        }
        this.pushPos();
        c = this.getNextXMLChar();
        this.popPos();
        if (qName.getPrefix().length() == 0) {
            int n = OperatorToken.getOpType(qName.getName());
            if (n != 0 && this.checkOpNameMulOpState()) {
                this.appendToken(new OperatorToken(n));
                return;
            }
            n = NodeTypeToken.getTypeFromName(qName.getName());
            if (n != 0 && c == '(') {
                this.appendToken(new NodeTypeToken(n));
                return;
            }
        }
        if (c == '(') {
            this.appendToken(new FunctionNameToken(qName.getPrefix(), qName.getName()));
        } else {
            this.appendToken(new WildcardNameToken(qName.getPrefix(), qName.getName()));
        }
    }

    protected void handleChar(char c) throws XPathParserException {
        switch (c) {
            case '(': {
                this.appendToken(new Token(1));
                break;
            }
            case ')': {
                this.appendToken(new Token(2));
                break;
            }
            case '[': {
                this.appendToken(new Token(3));
                break;
            }
            case ']': {
                this.appendToken(new Token(4));
                break;
            }
            case '.': {
                this.pushPos();
                char c2 = this.getNextChar();
                if (c2 == '.') {
                    this.tossPos();
                    this.appendToken(new Token(6));
                    break;
                }
                if (this.isDigit(c2)) {
                    this.popPos();
                    this.handleNumber('.');
                    break;
                }
                this.popPos();
                this.appendToken(new Token(5));
                break;
            }
            case '@': {
                this.appendToken(new Token(7));
                break;
            }
            case ',': {
                this.appendToken(new Token(8));
                break;
            }
            case ':': {
                this.pushPos();
                if (this.getNextChar() == ':') {
                    this.tossPos();
                    this.appendToken(new Token(9));
                    break;
                }
                throw new XPathParserException("pe3", c);
            }
            case '*': {
                if (this.checkOpNameMulOpState()) {
                    this.appendToken(new OperatorToken(2));
                    break;
                }
                this.appendToken(new WildcardNameToken("", "*"));
                break;
            }
            case '/': {
                this.pushPos();
                if (this.getNextChar() == '/') {
                    this.tossPos();
                    this.appendToken(new OperatorToken(6));
                    break;
                }
                this.popPos();
                this.appendToken(new OperatorToken(5));
                break;
            }
            case '|': {
                this.appendToken(new OperatorToken(16));
                break;
            }
            case '+': {
                this.appendToken(new OperatorToken(3));
                break;
            }
            case '-': {
                this.appendToken(new OperatorToken(4));
                break;
            }
            case '=': {
                this.appendToken(new OperatorToken(9));
                break;
            }
            case '!': {
                if (this.getNextChar() != '=') {
                    throw new XPathParserException("pe4", "=");
                }
                this.appendToken(new OperatorToken(1));
                break;
            }
            case '<': {
                this.pushPos();
                if (this.getNextChar() == '=') {
                    this.tossPos();
                    this.appendToken(new OperatorToken(8));
                    break;
                }
                this.popPos();
                this.appendToken(new OperatorToken(7));
                break;
            }
            case '>': {
                this.pushPos();
                if (this.getNextChar() == '=') {
                    this.tossPos();
                    this.appendToken(new OperatorToken(11));
                    break;
                }
                this.popPos();
                this.appendToken(new OperatorToken(10));
                break;
            }
            case '$': {
                QName qName;
                char c3 = this.getNextChar();
                if (c3 == '\u0000' || (qName = this.scanQName(c3)).isEmpty()) {
                    throw new XPathParserException("pe2");
                }
                this.appendToken(new VariableRefToken(qName.getPrefix(), qName.getName()));
                break;
            }
            case '\ufffd': {
                break;
            }
            default: {
                throw new XPathParserException("pe3", c);
            }
        }
    }

    protected void handleLiteral(char c) {
        char c2;
        StringBuffer stringBuffer = new StringBuffer(128);
        while ((c2 = this.getNextChar()) != '\u0000' && c2 != c) {
            stringBuffer.append(c2);
        }
        this.appendToken(new LiteralToken(stringBuffer.toString()));
    }

    protected void handleNumber(char c) {
        StringBuffer stringBuffer = new StringBuffer(16);
        stringBuffer.append(c);
        boolean bl = c == '.';
        while (true) {
            this.pushPos();
            char c2 = this.getNextChar();
            if (c2 == '.') {
                if (bl) {
                    this.popPos();
                    break;
                }
                bl = true;
            } else if (!this.isDigit(c2)) {
                this.popPos();
                break;
            }
            this.tossPos();
            stringBuffer.append(c2);
        }
        this.appendToken(new NumberToken(Double.valueOf(stringBuffer.toString())));
    }

    protected boolean checkOpNameMulOpState() {
        if (this.tokens.isEmpty()) {
            return false;
        }
        Token token = (Token)this.tokens.lastElement();
        int n = token.getType();
        return n != 7 && n != 1 && n != 3 && n != 10 && n != 9;
    }

    protected QName scanQName(char c) {
        String string = this.scanNCName(c);
        this.pushPos();
        if (this.getNextChar() == ':' && XMLUtil.isNCNameChar(c = this.getNextChar())) {
            this.tossPos();
            return new QName(string, this.scanNCName(c));
        }
        this.popPos();
        return new QName("", string);
    }

    protected String scanNCName(char c) {
        StringBuffer stringBuffer = new StringBuffer(32);
        stringBuffer.append(c);
        while (true) {
            this.pushPos();
            char c2 = this.getNextChar();
            if (!XMLUtil.isNCNameChar(c2)) break;
            stringBuffer.append(c2);
            this.tossPos();
        }
        this.popPos();
        return stringBuffer.toString();
    }

    protected char getNextXMLChar() {
        while (this.index < this.input.length()) {
            char c;
            if ((c = this.prescanChar(this.input.charAt(this.index++))) == '\u0000' || XMLUtil.isXMLWhitespace(c)) continue;
            return c;
        }
        return '\u0000';
    }

    protected char getNextChar() {
        if (this.index < this.input.length()) {
            return this.input.charAt(this.index++);
        }
        return '\u0000';
    }

    protected boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    protected void reset() {
        this.tokens.removeAllElements();
        this.stackTop = 0;
        this.index = 0;
    }

    protected void pushPos() {
        this.posStack[this.stackTop++] = this.index;
    }

    protected void tossPos() {
        --this.stackTop;
    }

    protected void popPos() {
        this.index = this.posStack[--this.stackTop];
    }

    protected final void appendToken(Token token) {
        this.tokens.addElement(token);
    }

    protected final Token lastToken() {
        if (this.tokens.isEmpty()) {
            return null;
        }
        return (Token)this.tokens.lastElement();
    }

    protected Token[] returnTokens() {
        Token[] tokenArray = new Token[this.tokens.size()];
        int n = 0;
        while (n < tokenArray.length) {
            tokenArray[n] = (Token)this.tokens.elementAt(n);
            ++n;
        }
        return tokenArray;
    }
}

