/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.xpath;

import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.ExpressionContext;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.NodeSet;
import com.novell.xml.xpath.NumberValue;
import com.novell.xml.xpath.XPathConversionException;
import com.novell.xml.xpath.XPathResetRegistrar;
import com.novell.xml.xpath.XPathUtil;
import java.io.PrintWriter;
import org.w3c.dom.Node;

public class StringValue
implements ExpressionValue,
Expression,
Comparable {
    private String value;
    private static final Class argType = XPathUtil.doGetClass("com.novell.xml.xpath.StringValue");

    public StringValue(String string) {
        this.value = string;
    }

    public StringValue() {
        this.value = "";
    }

    public static Class getArgType() {
        return argType;
    }

    public String toString() {
        return this.getStringValue();
    }

    public ExpressionValue evaluate(Node node, ExpressionContext expressionContext) {
        return this;
    }

    public boolean isConstant() {
        return true;
    }

    public Class getResultType() {
        return StringValue.getArgType();
    }

    public void registerForReset(XPathResetRegistrar xPathResetRegistrar) {
    }

    public void dump(PrintWriter printWriter, int n) {
        XPathUtil.dump(this, printWriter, n);
    }

    public int getValueType() {
        return 2;
    }

    public void castFrom(Object object) throws XPathConversionException {
        this.value = object instanceof ExpressionValue ? ((ExpressionValue)object).getStringValue() : object.toString();
    }

    public boolean getBooleanValue() throws XPathConversionException {
        return this.value.length() > 0;
    }

    public double getNumberValue() throws XPathConversionException {
        return NumberValue.convertToNumber(this.value);
    }

    public String getStringValue() {
        return this.value;
    }

    public NodeSet getNodeSetValue() throws XPathConversionException {
        throw new XPathConversionException("vce1");
    }

    public Object getNativeValue() {
        return this.value;
    }

    public void dump(PrintWriter printWriter) {
        printWriter.println("\"" + this.value + "\"");
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object object) {
        Object var2_2 = null;
        if (object instanceof StringValue) {
            return this.value.equals(((StringValue)object).value);
        }
        if (object instanceof String) {
            return this.value.equals((String)object);
        }
        return false;
    }

    public int compareTo(Object object) {
        if (object instanceof StringValue) {
            return this.value.compareTo(((StringValue)object).value);
        }
        return this.value.compareTo((String)object);
    }
}

