/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.xpath;

import com.novell.xml.dom.DOMUtil;
import com.novell.xml.util.ExpandedQName;
import com.novell.xml.util.NamespaceName;
import com.novell.xml.xpath.NamespaceContext;
import com.novell.xml.xpath.NodeTest;
import com.novell.xml.xpath.WildcardNameToken;
import com.novell.xml.xpath.XPathException;
import com.novell.xml.xpath.XPathParserException;
import org.w3c.dom.Node;

public class WildcardName
implements NodeTest {
    ExpandedQName name;
    private final boolean fullWild;
    private final boolean localWild;
    private int principalNodeType = 1;

    public WildcardName(WildcardNameToken wildcardNameToken, NamespaceContext namespaceContext) throws XPathException {
        String string = wildcardNameToken.getPrefix();
        String string2 = wildcardNameToken.getNCName();
        this.localWild = string2.equals("*");
        this.fullWild = string.length() == 0 && this.localWild;
        this.initName(string, string2, namespaceContext);
    }

    public WildcardName(String string, NamespaceContext namespaceContext) throws XPathException {
        String string2;
        String string3;
        int n = string.indexOf(58);
        if (n > 0) {
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1, string.length());
        } else {
            string3 = "";
            string2 = string;
        }
        this.localWild = string2.equals("*");
        this.fullWild = string3.length() == 0 && this.localWild;
        this.initName(string3, string2, namespaceContext);
    }

    public void setPrincipalNodeType(int n) {
        this.principalNodeType = n;
    }

    public boolean evaluate(Node node) {
        if (node.getNodeType() != this.principalNodeType) {
            return false;
        }
        if (this.fullWild) {
            return true;
        }
        ExpandedQName expandedQName = DOMUtil.getExpandedName(node);
        if (this.localWild) {
            return this.name.namespaceNameEquals(expandedQName);
        }
        return this.name.equals(expandedQName);
    }

    public ExpandedQName getName() {
        return this.name;
    }

    public String getPrefix() {
        return this.name.getPrefix();
    }

    public String getLocalPart() {
        return this.name.getLocalPart();
    }

    public NamespaceName getNamespaceName() {
        return this.name.getNamespaceName();
    }

    public boolean isFullWild() {
        return this.fullWild;
    }

    public boolean isLocalWild() {
        return this.localWild;
    }

    public String toString() {
        return this.name.getQName();
    }

    protected void initName(String string, String string2, NamespaceContext namespaceContext) throws XPathException {
        NamespaceName namespaceName;
        if (string.length() > 0) {
            namespaceName = namespaceContext.getNamespaceName(string);
            if (namespaceName.isEmpty()) {
                throw new XPathParserException("pe13", string);
            }
        } else {
            namespaceName = NamespaceName.NULL_NAMESPACE;
        }
        this.name = new ExpandedQName(namespaceName, string2, string);
    }
}

