/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.xpath;

import com.novell.xml.dom.DOMUtil;
import java.io.PrintWriter;
import org.w3c.dom.Node;

public final class XPathUtil {
    public static short getNodeType(Node node) {
        short s = node.getNodeType();
        if (s == 4) {
            s = 3;
        }
        return (short)s;
    }

    public static String getNodeValue(Node node) {
        String string;
        if (node == null) {
            return "";
        }
        switch (XPathUtil.getNodeType(node)) {
            case 1: {
                string = XPathUtil.getStringValue(node);
                break;
            }
            case 2: {
                string = node.getNodeValue();
                break;
            }
            case 9: {
                string = XPathUtil.getStringValue(node);
                break;
            }
            case 11: {
                string = XPathUtil.getNodeValue(node.getFirstChild());
                break;
            }
            case 3: {
                Node node2 = node.getPreviousSibling();
                while (node2 != null && XPathUtil.getNodeType(node2) == 3) {
                    node = node2;
                    node2 = node2.getPreviousSibling();
                }
                node2 = node.getNextSibling();
                if (node2 == null || XPathUtil.getNodeType(node2) != 3) {
                    string = node.getNodeValue();
                    break;
                }
                StringBuffer stringBuffer = new StringBuffer();
                do {
                    stringBuffer.append(node.getNodeValue());
                } while ((node = node.getNextSibling()) != null && XPathUtil.getNodeType(node) == 3);
                string = stringBuffer.toString();
                break;
            }
            default: {
                string = node.getNodeValue();
            }
        }
        return string != null ? string : "";
    }

    private static String getStringValue(Node node) {
        Node node2 = node.getFirstChild();
        if (node2 == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(256);
        XPathUtil.getStringValue(node, stringBuffer);
        return stringBuffer.toString();
    }

    private static void getStringValue(Node node, StringBuffer stringBuffer) {
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            switch (XPathUtil.getNodeType(node2)) {
                case 1: {
                    XPathUtil.getStringValue(node2, stringBuffer);
                    break;
                }
                case 3: {
                    stringBuffer.append(node2.getNodeValue());
                }
            }
            node2 = node2.getNextSibling();
        }
    }

    public static Node getNextSibling(Node node) {
        short s = XPathUtil.getNodeType(node);
        node = node.getNextSibling();
        if (s == 3) {
            while (node != null && XPathUtil.getNodeType(node) == 3) {
                node = node.getNextSibling();
            }
        }
        return node;
    }

    public static Node getPreviousSibling(Node node) {
        block3: {
            block2: {
                short s = XPathUtil.getNodeType(node);
                node = node.getPreviousSibling();
                if (s != 3) break block2;
                while (node != null && XPathUtil.getNodeType(node) == 3) {
                    node = node.getPreviousSibling();
                }
                break block3;
            }
            if (node == null || XPathUtil.getNodeType(node) != 3) break block3;
            while (node.getPreviousSibling() != null && XPathUtil.getNodeType(node.getPreviousSibling()) == 3) {
                node = node.getPreviousSibling();
            }
        }
        return node;
    }

    public static Class doGetClass(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException.getMessage());
        }
    }

    public static String describeNode(Node node) {
        if (node.getNodeType() == -1) {
            return "<xmlns" + (node.getNodeName().length() > 0 ? ":" : "") + node.getNodeName() + "=\"" + node.getNodeValue() + "\">";
        }
        return DOMUtil.describeNode(node);
    }

    public static void dump(Object object, PrintWriter printWriter, int n) {
        int n2 = 0;
        while (n2 < n) {
            printWriter.print("\t");
            ++n2;
        }
        printWriter.println(object.toString());
    }

    private XPathUtil() {
    }
}

