/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.xpath.functions;

import com.novell.xml.util.ExpandedQName;
import com.novell.xml.xpath.BooleanValue;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.Function;
import com.novell.xml.xpath.FunctionSignature;
import com.novell.xml.xpath.StringValue;
import com.novell.xml.xpath.XPathEvaluationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class xpathLang
extends Function {
    public xpathLang() {
        super(xpathLang.createSignature());
    }

    public ExpressionValue invoke(Object[] objectArray) throws XPathEvaluationException {
        try {
            Node node = (Node)objectArray[0];
            String string = ((ExpressionValue)objectArray[2]).getStringValue();
            String string2 = this.findLang(node);
            if (string.equalsIgnoreCase(string2)) {
                return new BooleanValue(true);
            }
            int n = string2.lastIndexOf(45);
            if (n != -1) {
                return new BooleanValue(string.equalsIgnoreCase(string2.substring(0, n)));
            }
            return new BooleanValue(false);
        }
        catch (ClassCastException classCastException) {
            throw new XPathEvaluationException("pe11");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new XPathEvaluationException("pe9");
        }
    }

    private String findLang(Node node) {
        while (node != null) {
            Attr attr;
            if (node.getNodeType() == 1 && (attr = ((Element)node).getAttributeNode("xml:lang")) != null) {
                return attr.getValue();
            }
            node = node.getParentNode();
        }
        return "";
    }

    private static FunctionSignature createSignature() {
        Class[] classArray = new Class[]{FunctionSignature.getContextArgTypes()[0], FunctionSignature.getContextArgTypes()[1], StringValue.getArgType()};
        return new FunctionSignature(new ExpandedQName("", "lang"), BooleanValue.getArgType(), classArray);
    }
}

