/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.xpath.functions;

import com.novell.xml.dom.DOMUtil;
import com.novell.xml.util.ExpandedQName;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.Function;
import com.novell.xml.xpath.FunctionSignature;
import com.novell.xml.xpath.NodeSet;
import com.novell.xml.xpath.StringValue;
import com.novell.xml.xpath.XPathEvaluationException;
import org.w3c.dom.Node;

public class xpathNamespaceUri
extends Function {
    public xpathNamespaceUri() {
        super(xpathNamespaceUri.createSignature());
    }

    public ExpressionValue invoke(Object[] objectArray) throws XPathEvaluationException {
        try {
            Node node = objectArray.length > 2 ? ((NodeSet)objectArray[2]).first() : (Node)objectArray[0];
            if (node != null) {
                switch (node.getNodeType()) {
                    case 1: 
                    case 2: {
                        return new StringValue(DOMUtil.getNamespaceName(node).getString());
                    }
                }
            }
            return new StringValue("");
        }
        catch (ClassCastException classCastException) {
            throw new XPathEvaluationException("pe11");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new XPathEvaluationException("pe9");
        }
    }

    public String toString() {
        return "namespace-uri";
    }

    private static FunctionSignature createSignature() {
        Class[] classArray = new Class[]{NodeSet.getArgType()};
        return new FunctionSignature(new ExpandedQName("", "namespace-uri"), StringValue.getArgType(), FunctionSignature.getContextArgTypes(), classArray);
    }
}

