/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl;

import com.novell.xsl.ErrorHandler;
import com.novell.xsl.XSLException;
import java.io.PrintWriter;

public class DefaultErrorHandler
implements ErrorHandler {
    private PrintWriter output;
    private boolean logErrors = true;
    private boolean logWarnings = true;
    private int errorCount = 0;
    private int warningCount = 0;

    public DefaultErrorHandler() {
        this.createOutput();
    }

    public DefaultErrorHandler(PrintWriter printWriter) {
        this.output = printWriter;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public int getWarningCount() {
        return this.warningCount;
    }

    public void resetCounts() {
        this.errorCount = 0;
        this.warningCount = 0;
    }

    public void setLogErrors(boolean bl) {
        this.logErrors = bl;
    }

    public void setLogWarnings(boolean bl) {
        this.logWarnings = bl;
    }

    public void error(String string) throws XSLException {
        ++this.errorCount;
        if (this.logErrors) {
            String string2 = XSLException.constructMessage("e1", new String[]{string});
            this.output.println(string2);
            this.output.flush();
        }
    }

    public void warning(String string) {
        ++this.warningCount;
        if (this.logWarnings) {
            String string2 = XSLException.constructMessage("e2", new String[]{string});
            this.output.println(string2);
            this.output.flush();
        }
    }

    private void createOutput() {
        this.output = new PrintWriter(System.err);
    }
}

