/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl;

import com.novell.util.URIResolver;
import com.novell.xml.dom.DOMUtil;
import com.novell.xml.dom.DocumentFactory;
import com.novell.xml.dom.DocumentImpl;
import com.novell.xml.dom.NodeImpl;
import com.novell.xml.parser.XMLParser;
import com.novell.xml.parser.XMLParserFactory;
import com.novell.xml.util.ExpandedQName;
import com.novell.xml.util.NamespaceName;
import com.novell.xml.util.StylesheetAssociation;
import com.novell.xml.util.XMLUtil;
import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.ExpressionContext;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.NodeSet;
import com.novell.xml.xpath.Parser;
import com.novell.xml.xpath.VariableBindings;
import com.novell.xml.xpath.XPathConversionException;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xml.xpath.XPathParserException;
import com.novell.xml.xpath.XPathResetCache;
import com.novell.xml.xpath.XPathResetRegistrar;
import com.novell.xsl.DefaultErrorHandler;
import com.novell.xsl.DefaultMessageHandler;
import com.novell.xsl.ErrorHandler;
import com.novell.xsl.MessageHandler;
import com.novell.xsl.XSLException;
import com.novell.xsl.XmlHook;
import com.novell.xsl.extensions.JavaInstance;
import com.novell.xsl.parser.StylesheetParser;
import com.novell.xsl.parser.XSLTParserException;
import com.novell.xsl.parser.XsltFunctionLibrary;
import com.novell.xsl.process.AttributeSet;
import com.novell.xsl.process.Context;
import com.novell.xsl.process.Key;
import com.novell.xsl.process.Mode;
import com.novell.xsl.process.ProcessingEnv;
import com.novell.xsl.process.RuleCollection;
import com.novell.xsl.process.StripList;
import com.novell.xsl.process.TopLevelVariableTemplate;
import com.novell.xsl.result.DOMResult;
import com.novell.xsl.result.DOMResultHandler;
import com.novell.xsl.result.DefaultSerializer;
import com.novell.xsl.result.HTMLSerializer;
import com.novell.xsl.result.ResultException;
import com.novell.xsl.result.ResultHandler;
import com.novell.xsl.result.Serializer;
import com.novell.xsl.result.SerializerOptions;
import com.novell.xsl.result.TextSerializer;
import com.novell.xsl.result.XMLSerializer;
import com.novell.xsl.util.Util;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Stylesheet
implements XPathResetRegistrar,
VariableBindings {
    public static final NamespaceName NAMESPACE = new NamespaceName("http://www.w3.org/1999/XSL/Transform");
    public static final String VERSION = "1.0";
    public static final NamespaceName NXSL_NAMESPACE = new NamespaceName("http://www.novell.com/nxsl");
    public static final String EXTENSION_FUNCTION_MAGIC = "http://www.novell.com/nxsl/java/";
    public static final String XSLT_VERSION = "1.0";
    private URL baseURI = null;
    private Node stylesheetDocument;
    private String id;
    private boolean isLoaded;
    private RuleCollection templateRules = new RuleCollection();
    private StripList stripList = new StripList();
    private Map decimalFormatMap = null;
    private static final ExpandedQName defaultDecimalFormatName = new ExpandedQName(NAMESPACE, "#default#");
    private Map keyMap = null;
    private Map attributeSetMap = null;
    private Map namespaceAliasMap = null;
    private List resetList = new ArrayList();
    private int invocationCount;
    private ErrorHandler errorHandler = new DefaultErrorHandler();
    private MessageHandler messageHandler = new DefaultMessageHandler();
    private Context context;
    private Map topLevelVariables = null;
    private List actualParameters = new ArrayList();
    private SerializerOptions serializerOptions = null;
    private int serializerOptionsImportance;
    private ResultHandler resultHandler = null;
    private OutputStream serializerStream = null;
    private String[] mimeTypes = SUPPORTED_MIME_TYPES;
    private XmlHook documentHook = null;
    private boolean brokenMode = false;
    private static final String[] SUPPORTED_MIME_TYPES = new String[]{new String("text/xml"), new String("application/xml")};

    public Stylesheet() {
        this.context = new Context(this, new XsltFunctionLibrary());
    }

    public Stylesheet(ClassLoader classLoader) {
        this.context = new Context(this, new XsltFunctionLibrary(classLoader));
    }

    public Stylesheet(Document document) throws XSLException {
        this.context = new Context(this, new XsltFunctionLibrary());
        this.load(document);
    }

    public Stylesheet(Document document, boolean bl) throws XSLException {
        this.context = new Context(this, new XsltFunctionLibrary());
        this.setBrokenMode(bl);
        this.load(document);
    }

    public Stylesheet(Document document, ClassLoader classLoader) throws XSLException {
        this.context = new Context(this, new XsltFunctionLibrary(classLoader));
        this.load(document);
    }

    public Stylesheet(Document document, ClassLoader classLoader, boolean bl) throws XSLException {
        this.context = new Context(this, new XsltFunctionLibrary(classLoader));
        this.setBrokenMode(bl);
        this.load(document);
    }

    public Stylesheet(Document document, String string) throws XSLException {
        this.context = new Context(this, new XsltFunctionLibrary());
        try {
            this.setBaseURI(string);
        }
        catch (MalformedURLException malformedURLException) {
            this.errorHandler.error(malformedURLException.toString());
        }
        this.load(document);
    }

    public Stylesheet(Document document, String string, boolean bl) throws XSLException {
        this.context = new Context(this, new XsltFunctionLibrary());
        this.setBrokenMode(bl);
        try {
            this.setBaseURI(string);
        }
        catch (MalformedURLException malformedURLException) {
            this.errorHandler.error(malformedURLException.toString());
        }
        this.load(document);
    }

    public Stylesheet(Document document, String string, ClassLoader classLoader) throws XSLException {
        this.context = new Context(this, new XsltFunctionLibrary(classLoader));
        try {
            this.setBaseURI(string);
        }
        catch (MalformedURLException malformedURLException) {
            this.errorHandler.error(malformedURLException.toString());
        }
        this.load(document);
    }

    public Stylesheet(Document document, String string, ClassLoader classLoader, boolean bl) throws XSLException {
        this.context = new Context(this, new XsltFunctionLibrary(classLoader));
        this.setBrokenMode(bl);
        try {
            this.setBaseURI(string);
        }
        catch (MalformedURLException malformedURLException) {
            this.errorHandler.error(malformedURLException.toString());
        }
        this.load(document);
    }

    public boolean setBrokenMode(boolean bl) {
        boolean bl2 = this.brokenMode;
        this.brokenMode = bl;
        return bl2;
    }

    public void setResultHandler(ResultHandler resultHandler) {
        this.resultHandler = resultHandler;
    }

    public ResultHandler getResultHandler() {
        return this.resultHandler;
    }

    public void setSerializerStream(OutputStream outputStream) {
        this.serializerStream = outputStream;
    }

    public OutputStream getSerializerStream() {
        return this.serializerStream;
    }

    public void setParameter(String string, String string2) {
        this.actualParameters.add(new StringParameter(string, string2));
    }

    public void setParameter(String string, Object object) {
        this.actualParameters.add(new ValueParameter(string, object));
    }

    public void clearParameters() {
        this.actualParameters.clear();
    }

    public XmlHook setXmlHook(XmlHook xmlHook) {
        XmlHook xmlHook2 = this.documentHook;
        this.documentHook = xmlHook;
        return xmlHook2;
    }

    public XmlHook getXmlHook() {
        return this.documentHook;
    }

    public URL getBaseURI() {
        return this.baseURI;
    }

    public void setBaseURI(URL uRL) {
        this.baseURI = uRL;
    }

    public void setBaseURI(String string) throws MalformedURLException {
        URL uRL = XMLUtil.filenameToURL(".");
        String string2 = URIResolver.resolveURI(string, uRL.toString());
        this.baseURI = new URL(string2);
    }

    public String getID() {
        return this.id;
    }

    public void setID(String string) {
        this.id = string;
    }

    public RuleCollection getTemplateRules() {
        return this.templateRules;
    }

    public StripList getStripList() {
        return this.stripList;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        if (errorHandler == null) {
            throw new IllegalArgumentException("null error handler");
        }
        this.errorHandler = errorHandler;
    }

    public MessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    public void setMessageHandler(MessageHandler messageHandler) {
        if (messageHandler == null) {
            throw new IllegalArgumentException("null message handler");
        }
        this.messageHandler = messageHandler;
    }

    public SerializerOptions getSerializerOptions() {
        return this.serializerOptions;
    }

    public void setSerializerOptions(SerializerOptions serializerOptions, int n) {
        if (this.serializerOptions != null) {
            if (n >= this.serializerOptionsImportance) {
                serializerOptions.merge(this.serializerOptions);
                this.serializerOptions = serializerOptions;
                this.serializerOptionsImportance = n;
            } else {
                this.serializerOptions.merge(serializerOptions);
            }
        } else {
            this.serializerOptions = serializerOptions;
        }
    }

    public void setTopLevelVariable(TopLevelVariableTemplate topLevelVariableTemplate) throws XSLException {
        TopLevelVariableTemplate topLevelVariableTemplate2;
        if (this.topLevelVariables == null) {
            this.topLevelVariables = new HashMap();
        }
        if ((topLevelVariableTemplate2 = (TopLevelVariableTemplate)this.topLevelVariables.get(topLevelVariableTemplate.getName())) != null) {
            if (topLevelVariableTemplate2.getImportance() > topLevelVariableTemplate.getImportance()) {
                topLevelVariableTemplate.replace(topLevelVariableTemplate2);
                return;
            }
            if (topLevelVariableTemplate2.getImportance() == topLevelVariableTemplate.getImportance()) {
                throw new XSLException(XSLTParserException.constructMessage("spe7", new String[]{topLevelVariableTemplate.getName().getQName()}));
            }
            topLevelVariableTemplate2 = (TopLevelVariableTemplate)this.topLevelVariables.remove(topLevelVariableTemplate.getName());
            topLevelVariableTemplate2.replace(topLevelVariableTemplate);
        }
        this.topLevelVariables.put(topLevelVariableTemplate.getName(), topLevelVariableTemplate);
    }

    public TopLevelVariableTemplate getTopLevelVariable(ExpandedQName expandedQName) {
        return this.topLevelVariables != null ? (TopLevelVariableTemplate)this.topLevelVariables.get(expandedQName) : null;
    }

    public void setDecimalFormat(ExpandedQName expandedQName, DecimalFormatSymbols decimalFormatSymbols) {
        if (expandedQName == null) {
            expandedQName = defaultDecimalFormatName;
        }
        if (this.decimalFormatMap == null) {
            this.decimalFormatMap = new HashMap();
        } else {
            this.decimalFormatMap.remove(expandedQName);
        }
        this.decimalFormatMap.put(expandedQName, decimalFormatSymbols);
    }

    public DecimalFormatSymbols getDecimalFormat(ExpandedQName expandedQName) {
        DecimalFormatSymbols decimalFormatSymbols;
        if (expandedQName == null) {
            expandedQName = defaultDecimalFormatName;
        }
        DecimalFormatSymbols decimalFormatSymbols2 = decimalFormatSymbols = this.decimalFormatMap != null ? (DecimalFormatSymbols)this.decimalFormatMap.get(expandedQName) : null;
        if (decimalFormatSymbols == null && expandedQName.equals(defaultDecimalFormatName)) {
            decimalFormatSymbols = new DecimalFormatSymbols();
            this.setDecimalFormat(null, decimalFormatSymbols);
        }
        return decimalFormatSymbols;
    }

    public void setKey(Key key) {
        if (this.keyMap == null) {
            this.keyMap = new HashMap();
        } else {
            this.keyMap.remove(key.getName());
            this.resetList.remove(key);
        }
        this.keyMap.put(key.getName(), key);
        this.resetList.add(key);
    }

    public Key getKey(ExpandedQName expandedQName) {
        return this.keyMap != null ? (Key)this.keyMap.get(expandedQName) : null;
    }

    public void setAttributeSet(AttributeSet attributeSet) throws XSLException {
        AttributeSet attributeSet2;
        if (this.attributeSetMap == null) {
            this.attributeSetMap = new HashMap();
        }
        if ((attributeSet2 = (AttributeSet)this.attributeSetMap.get(attributeSet.getName())) != null) {
            attributeSet2.merge(attributeSet);
        } else {
            this.attributeSetMap.put(attributeSet.getName(), attributeSet);
        }
    }

    public AttributeSet getAttributeSet(ExpandedQName expandedQName) {
        return this.attributeSetMap != null ? (AttributeSet)this.attributeSetMap.get(expandedQName) : null;
    }

    public void setNamespaceAlias(NamespaceName namespaceName, NamespaceName namespaceName2, String string, int n) {
        ResultNamespace resultNamespace;
        if (this.namespaceAliasMap == null) {
            this.namespaceAliasMap = new HashMap();
        }
        if ((resultNamespace = (ResultNamespace)this.namespaceAliasMap.get(namespaceName)) != null) {
            if (resultNamespace.getImportance() > n) {
                return;
            }
            this.namespaceAliasMap.remove(namespaceName);
        }
        this.namespaceAliasMap.put(namespaceName, new ResultNamespace(namespaceName2, string, n));
    }

    public NamespaceName getAliasedNamespace(NamespaceName namespaceName) {
        ResultNamespace resultNamespace = this.namespaceAliasMap != null ? (ResultNamespace)this.namespaceAliasMap.get(namespaceName) : null;
        return resultNamespace == null ? null : resultNamespace.getResultName();
    }

    public String getAliasedPrefix(NamespaceName namespaceName) {
        ResultNamespace resultNamespace = this.namespaceAliasMap != null ? (ResultNamespace)this.namespaceAliasMap.get(namespaceName) : null;
        return resultNamespace == null ? null : resultNamespace.getResultPrefix();
    }

    public void setMimeTypes(String[] stringArray) {
        this.mimeTypes = stringArray;
    }

    public void load(Document document) throws XSLTParserException {
        if (this.isLoaded) {
            throw new RuntimeException("stylesheet already loaded");
        }
        if (this.baseURI == null && document instanceof NodeImpl && ((NodeImpl)((Object)document)).getBaseURI() != null) {
            try {
                this.setBaseURI(((NodeImpl)((Object)document)).getBaseURI());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        this.stylesheetDocument = document;
        StylesheetParser stylesheetParser = new StylesheetParser(this, this.context.getFunctionLibrary(), this.brokenMode);
        stylesheetParser.setBuiltInDefinitions(document);
        stylesheetParser.parse(document, this.baseURI);
        this.templateRules.optimize();
        this.stripList.optimize();
        this.isLoaded = true;
        this.invocationCount = 0;
    }

    public void loadFromSource(Document document, String string) throws XSLTParserException {
        Object object;
        if (this.isLoaded) {
            throw new RuntimeException("stylesheet already loaded");
        }
        StylesheetParser stylesheetParser = new StylesheetParser(this, this.context.getFunctionLibrary(), this.brokenMode);
        StylesheetAssociation[] stylesheetAssociationArray = DOMUtil.getStylesheetAssociations(document, string);
        if (stylesheetAssociationArray.length < 1) {
            stylesheetParser.reportError(document, "spe22");
            return;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < stylesheetAssociationArray.length) {
            object = stylesheetAssociationArray[n2].getType();
            int n3 = 0;
            while (n3 < this.mimeTypes.length) {
                if (((String)object).equals(this.mimeTypes[n3])) {
                    ++n;
                }
                ++n3;
            }
            ++n2;
        }
        if (n == 0) {
            stylesheetParser.reportError(document, "spe23");
        }
        object = null;
        if (n == 1) {
            XMLParser xMLParser = XMLParserFactory.newParser();
            int n4 = 0;
            while (n4 < stylesheetAssociationArray.length) {
                String string2 = stylesheetAssociationArray[n4].getType();
                boolean bl = false;
                int n5 = 0;
                while (n5 < this.mimeTypes.length) {
                    if (string2.equals(this.mimeTypes[n5])) {
                        bl = true;
                        break;
                    }
                    ++n5;
                }
                if (bl && !stylesheetAssociationArray[n4].isAlternate()) {
                    try {
                        object = xMLParser.parse(stylesheetAssociationArray[n4].getHref());
                        if (xMLParser.anyErrors()) {
                            stylesheetParser.reportError(xMLParser.getErrorMsgString());
                            return;
                        }
                        this.setBaseURI(stylesheetAssociationArray[n4].getHref());
                    }
                    catch (IOException iOException) {
                        stylesheetParser.reportError(iOException.toString());
                        return;
                    }
                }
                ++n4;
            }
        } else {
            object = DocumentFactory.newDocument();
            ((DocumentImpl)object).setBaseURI(string);
            Element element = object.createElement("xsl:stylesheet");
            object.appendChild(element);
            element.setAttribute("xmlns:xsl", NAMESPACE.getString());
            element.setAttribute("version", "1.0");
            int n6 = 0;
            while (n6 < stylesheetAssociationArray.length) {
                String string3 = stylesheetAssociationArray[n6].getType();
                boolean bl = false;
                int n7 = 0;
                while (n7 < this.mimeTypes.length) {
                    if (string3.equals(this.mimeTypes[n7])) {
                        bl = true;
                        break;
                    }
                    ++n7;
                }
                if (bl && !stylesheetAssociationArray[n6].isAlternate()) {
                    Element element2 = object.createElement("xsl:include");
                    element.appendChild(element2);
                    element2.setAttribute("href", stylesheetAssociationArray[n6].getHref());
                }
                ++n6;
            }
        }
        this.load((Document)object);
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public void processStripped(Node node, URL uRL) throws XSLException {
        this.process(node, uRL, true);
    }

    public void process(Node node, URL uRL) throws XSLException {
        this.process(node, uRL, false);
    }

    public void process(Node node, URL uRL, boolean bl) throws XSLException {
        short s;
        if (node == null || (s = node.getNodeType()) != 9 && s != 11) {
            throw new IllegalArgumentException("Illegal sourceDocument argument");
        }
        if (!this.isLoaded) {
            new StylesheetParser(this, this.context.getFunctionLibrary(), this.brokenMode).setBuiltInDefinitions(node);
            this.templateRules.optimize();
            this.stripList.optimize();
            this.isLoaded = true;
            this.invocationCount = 0;
        } else if (++this.invocationCount > 1) {
            this.reset();
        }
        this.context.setStripList(bl ? null : this.stripList);
        try {
            Object object;
            this.setupResultHandler();
            Document document = this.resultHandler instanceof DOMResult ? ((DOMResult)((Object)this.resultHandler)).getDocument() : DocumentFactory.newDocument();
            ProcessingEnv processingEnv = new ProcessingEnv(this, this.context, document, this.errorHandler, this.messageHandler, this.resultHandler);
            NodeSet nodeSet = new NodeSet();
            nodeSet.add(node);
            this.context.setContextNodeList(nodeSet);
            this.context.clearBaseURIs();
            if (uRL != null) {
                this.context.addBaseURI(node, uRL);
            }
            this.context.addBaseURI(this.stylesheetDocument, this.baseURI);
            Context context = new Context(this.context);
            context.setNamespaceContext(this.stylesheetDocument);
            ProcessingEnv processingEnv2 = new ProcessingEnv(this, context, document, this.errorHandler, this.messageHandler, this.resultHandler);
            Iterator<Object> iterator = this.actualParameters.iterator();
            while (iterator.hasNext()) {
                object = (ActualParameter)iterator.next();
                ExpandedQName expandedQName = this.context.getExpandedName(((ActualParameter)object).getQName());
                if (this.topLevelVariables == null || !this.topLevelVariables.containsKey(expandedQName)) continue;
                try {
                    processingEnv2.bindParameter(expandedQName, ((ActualParameter)object).evaluate(node, this.context));
                }
                catch (XPathEvaluationException xPathEvaluationException) {
                    this.errorHandler.error(XSLException.constructMessage("e3", new String[]{xPathEvaluationException.getMessage()}));
                }
            }
            if (this.topLevelVariables != null) {
                iterator = this.topLevelVariables.values().iterator();
                while (iterator.hasNext()) {
                    object = (TopLevelVariableTemplate)iterator.next();
                    ((TopLevelVariableTemplate)object).setLazyEnv(processingEnv2);
                }
            }
            this.resultHandler.startDocument();
            processingEnv.process(node, Mode.DEFAULT_MODE, this.resultHandler);
            this.resultHandler.endDocument();
        }
        catch (ResultException resultException) {
            this.errorHandler.error(resultException.toString());
        }
    }

    public void dump(PrintWriter printWriter) {
        this.dump(printWriter, 0);
    }

    public void dump(PrintWriter printWriter, int n) {
        Iterator iterator;
        Util.indent(printWriter, n);
        printWriter.println("stylesheet id=" + this.id);
        int n2 = 0;
        while (n2 < n) {
            printWriter.print("\t");
            ++n2;
        }
        printWriter.println("\ttemplate rules");
        this.templateRules.dump(printWriter, n + 1);
        printWriter.println("\nstrip/preserve-space elements");
        this.stripList.dump(printWriter, n + 1);
        printWriter.println("\nkeys");
        if (this.keyMap != null) {
            iterator = this.keyMap.keySet().iterator();
            while (iterator.hasNext()) {
                ((Key)this.keyMap.get(iterator.next())).dump(printWriter, n + 1);
            }
        }
        printWriter.println("\ndecimal-format objects");
        if (this.decimalFormatMap != null) {
            iterator = this.decimalFormatMap.keySet().iterator();
            while (iterator.hasNext()) {
                Util.indent(printWriter, n);
                this.decimalFormatMap.get(iterator.next()).toString();
                printWriter.println();
            }
        }
    }

    private void setupResultHandler() {
        if (this.resultHandler == null) {
            if (this.serializerStream != null) {
                ExpandedQName expandedQName;
                ExpandedQName expandedQName2 = expandedQName = this.serializerOptions == null ? null : this.serializerOptions.getMethod();
                if (expandedQName == null) {
                    this.resultHandler = new DefaultSerializer();
                } else if (expandedQName.getNamespaceName().isEmpty()) {
                    String string = expandedQName.getLocalPart();
                    if (string.equals("xml")) {
                        this.resultHandler = new XMLSerializer();
                    } else if (string.equals("html")) {
                        this.resultHandler = new HTMLSerializer();
                    } else if (string.equals("text")) {
                        this.resultHandler = new TextSerializer();
                    }
                } else if (expandedQName.getNamespaceName().getString().startsWith(EXTENSION_FUNCTION_MAGIC)) {
                    String string = expandedQName.getNamespaceName().getString();
                    String string2 = string.substring(EXTENSION_FUNCTION_MAGIC.length(), string.length());
                    try {
                        Class<?> clazz = Class.forName(string2);
                        if (Class.forName("com.novell.xsl.result.Serializer").isAssignableFrom(clazz) && Class.forName("com.novell.xsl.result.ResultHandler").isAssignableFrom(clazz)) {
                            this.resultHandler = (ResultHandler)clazz.newInstance();
                        } else {
                            this.errorHandler.warning(XSLException.constructMessage("e4", new String[]{string2}));
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        this.errorHandler.warning(XSLException.constructMessage("e4", new String[]{string2}));
                    }
                    catch (InstantiationException instantiationException) {
                        this.errorHandler.warning(XSLException.constructMessage("e4", new String[]{string2}));
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
                if (this.resultHandler == null) {
                    this.resultHandler = new DefaultSerializer();
                }
            } else {
                this.resultHandler = new DOMResultHandler(DocumentFactory.newDocument());
            }
        }
        if (this.resultHandler instanceof Serializer) {
            if (this.serializerOptions != null) {
                ((Serializer)((Object)this.resultHandler)).setOptions(this.serializerOptions);
            }
            if (this.serializerStream != null) {
                ((Serializer)((Object)this.resultHandler)).setStream(this.serializerStream);
            }
        }
    }

    public void registerResetCache(XPathResetCache xPathResetCache) {
        this.resetList.add(xPathResetCache);
    }

    private void reset() {
        Iterator iterator = this.resetList.iterator();
        while (iterator.hasNext()) {
            ((XPathResetCache)iterator.next()).resetCache();
        }
    }

    public Expression getVariable(ExpandedQName expandedQName) {
        return (Expression)this.topLevelVariables.get(expandedQName);
    }

    private class ValueParameter
    extends ActualParameter {
        private final ExpressionValue value;

        public ValueParameter(String string, Object object) {
            super(string);
            if (object instanceof ExpressionValue) {
                this.value = (ExpressionValue)object;
            } else if (object instanceof Node) {
                NodeSet nodeSet = new NodeSet();
                nodeSet.add((Node)object);
                this.value = nodeSet;
            } else {
                Class clazz = JavaInstance.getReturnType(object.getClass());
                try {
                    this.value = (ExpressionValue)clazz.newInstance();
                    this.value.castFrom(object);
                }
                catch (XPathConversionException xPathConversionException) {
                    throw new Error(xPathConversionException.getMessage());
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new Error(illegalAccessException.getMessage());
                }
                catch (InstantiationException instantiationException) {
                    throw new Error(instantiationException.getMessage());
                }
            }
        }

        public ExpressionValue evaluate(Node node, ExpressionContext expressionContext) {
            return this.value;
        }
    }

    private class StringParameter
    extends ActualParameter {
        private final String expString;

        public StringParameter(String string, String string2) {
            super(string);
            this.expString = string2;
        }

        public ExpressionValue evaluate(Node node, ExpressionContext expressionContext) throws XPathEvaluationException {
            Parser parser = new Parser(Stylesheet.this, ((Context)expressionContext).getFunctionLibrary(), expressionContext);
            try {
                return parser.parse(this.expString).evaluate(node, expressionContext);
            }
            catch (XPathParserException xPathParserException) {
                throw new XPathEvaluationException(xPathParserException.getMessage());
            }
        }
    }

    private abstract class ActualParameter {
        private final String qName;

        public ActualParameter(String string) {
            this.qName = string;
        }

        public abstract ExpressionValue evaluate(Node var1, ExpressionContext var2) throws XPathEvaluationException;

        public String getQName() {
            return this.qName;
        }
    }

    private static class ResultNamespace {
        private NamespaceName resultName;
        private String resultPrefix;
        private int importance;

        public ResultNamespace(NamespaceName namespaceName, String string, int n) {
            this.resultName = namespaceName;
            this.resultPrefix = string;
            this.importance = n;
        }

        public int getImportance() {
            return this.importance;
        }

        public NamespaceName getResultName() {
            return this.resultName;
        }

        public String getResultPrefix() {
            return this.resultPrefix;
        }
    }
}

