/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.extensions;

import com.novell.xml.util.ExpandedQName;
import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.StringValue;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xsl.XSLException;
import com.novell.xsl.debug.Trace;
import com.novell.xsl.parser.AttrDef;
import com.novell.xsl.parser.StylesheetParser;
import com.novell.xsl.parser.XSLTParserException;
import com.novell.xsl.process.ProcessingEnv;
import com.novell.xsl.process.ResultTreeFragment;
import com.novell.xsl.process.Template;
import com.novell.xsl.process.VariablePlaceholder;
import com.novell.xsl.process.VariableTemplate;
import com.novell.xsl.result.FragmentHandler;
import com.novell.xsl.result.ResultHandler;
import com.novell.xsl.util.Util;
import java.io.PrintWriter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AssignVariableTemplate
extends VariableTemplate {
    protected Expression variable;
    private static AttrDef[] nxslAssignVariableAttr = new AttrDef[]{new AttrDef("name", 1, null, 6), new AttrDef("select", 0, null, 11)};

    public static Template parse(StylesheetParser stylesheetParser, Element element) throws XSLTParserException {
        Object[] objectArray = AttrDef.parseAttributes(stylesheetParser, element, nxslAssignVariableAttr);
        if (objectArray[0] == null) {
            return null;
        }
        ExpandedQName expandedQName = (ExpandedQName)objectArray[0];
        Expression expression = stylesheetParser.getVariables().getVariable(expandedQName);
        Expression expression2 = (Expression)objectArray[1];
        Template[] templateArray = stylesheetParser.parseTemplates(element.getFirstChild(), false);
        return new AssignVariableTemplate(expandedQName, expression2, templateArray, expression, (Node)element);
    }

    protected AssignVariableTemplate(ExpandedQName expandedQName, Expression expression, Template[] templateArray, Expression expression2, Node node) {
        super(expandedQName, expression, templateArray, node);
        this.variable = expression2;
    }

    public void instantiate(ProcessingEnv processingEnv, Node node, ResultHandler resultHandler) throws XSLException {
        Trace.traceTemplate("assign-variable");
        try {
            ExpressionValue expressionValue;
            if (this.getSelect() != null) {
                expressionValue = processingEnv.getContext().evaluate(node, this.getSelect());
                Trace.traceSelect(this.getSelect(), expressionValue);
            } else if (this.getTemplates().length == 0) {
                expressionValue = new StringValue();
            } else {
                FragmentHandler fragmentHandler = new FragmentHandler(processingEnv.getNodeFactory());
                this.instantiateTemplates(processingEnv, node, fragmentHandler);
                expressionValue = new ResultTreeFragment(fragmentHandler.getFragment());
            }
            if (this.variable instanceof VariableTemplate) {
                ((VariableTemplate)this.variable).setCurrentValue(expressionValue);
            } else if (this.variable instanceof VariablePlaceholder) {
                ((VariablePlaceholder)this.variable).setCurrentValue(expressionValue);
            }
        }
        catch (XPathEvaluationException xPathEvaluationException) {
            processingEnv.reportError(this.getNamespaceContext(), "pe2", xPathEvaluationException.getMessage());
        }
    }

    public void dump(PrintWriter printWriter, int n) {
        Util.indent(printWriter, n);
        printWriter.println("assign-variable");
        super.dump(printWriter, n + 1);
    }
}

