/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.extensions;

import com.novell.xml.xpath.BooleanValue;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.Function;
import com.novell.xml.xpath.FunctionSignature;
import com.novell.xml.xpath.NodeSet;
import com.novell.xml.xpath.NumberValue;
import com.novell.xml.xpath.StringValue;
import com.novell.xml.xpath.XPathUtil;
import com.novell.xsl.extensions.JavaObject;
import com.novell.xsl.extensions.JavaVoid;

public abstract class JavaInstance
extends Function {
    protected ExpressionValue returnWrapper = null;
    protected static final Class interfaceExpressionValue = XPathUtil.doGetClass("com.novell.xml.xpath.ExpressionValue");
    protected static final Class interfaceNode = XPathUtil.doGetClass("org.w3c.dom.Node");
    protected static final Class classString = XPathUtil.doGetClass("java.lang.String");
    protected static final Class classNumber = XPathUtil.doGetClass("java.lang.Number");
    protected static final Class classBoolean = XPathUtil.doGetClass("java.lang.Boolean");

    protected JavaInstance(FunctionSignature functionSignature) {
        super(functionSignature);
    }

    public String toString() {
        return this.getSignature().getName().getQName();
    }

    public Class getWrappedResultType() {
        if (this.returnWrapper == null || !(this.returnWrapper instanceof JavaObject)) {
            return this.getSignature().getReturnType();
        }
        return ((JavaObject)this.returnWrapper).getWrappedType();
    }

    public static Class getReturnType(Class clazz) {
        if (interfaceExpressionValue.isAssignableFrom(clazz)) {
            return clazz;
        }
        if (Void.TYPE.isAssignableFrom(clazz)) {
            return JavaVoid.getArgType();
        }
        if (Boolean.TYPE.isAssignableFrom(clazz) || classBoolean.isAssignableFrom(clazz)) {
            return BooleanValue.getArgType();
        }
        if (clazz.isPrimitive() || classNumber.isAssignableFrom(clazz)) {
            return NumberValue.getArgType();
        }
        if (classString.isAssignableFrom(clazz)) {
            return StringValue.getArgType();
        }
        if (interfaceNode.isAssignableFrom(clazz)) {
            return NodeSet.getArgType();
        }
        return JavaObject.getArgType();
    }
}

