/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.extensions.functions;

import com.novell.xml.dom.DocumentFactory;
import com.novell.xml.dom.DocumentFragmentImpl;
import com.novell.xml.util.ExpandedQName;
import com.novell.xml.util.NamespaceName;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.Function;
import com.novell.xml.xpath.FunctionSignature;
import com.novell.xml.xpath.NodeSet;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xsl.Stylesheet;
import com.novell.xsl.process.ResultTreeFragment;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class nxslNodeSet
extends Function {
    public nxslNodeSet() {
        super(nxslNodeSet.createSignature(Stylesheet.NXSL_NAMESPACE));
    }

    protected nxslNodeSet(NamespaceName namespaceName) {
        super(nxslNodeSet.createSignature(namespaceName));
    }

    public ExpressionValue invoke(Object[] objectArray) throws XPathEvaluationException {
        try {
            NodeSet nodeSet;
            ExpressionValue expressionValue = (ExpressionValue)objectArray[0];
            if (expressionValue instanceof ResultTreeFragment) {
                ResultTreeFragment resultTreeFragment = (ResultTreeFragment)expressionValue;
                nodeSet = new NodeSet();
                Node node = resultTreeFragment.getRoot();
                if (node instanceof DocumentFragmentImpl) {
                    ((DocumentFragmentImpl)node).updateDocumentOrder();
                }
                nodeSet.add(node);
            } else if (expressionValue instanceof NodeSet) {
                nodeSet = (NodeSet)expressionValue;
            } else {
                Document document = DocumentFactory.newDocument();
                Text text = document.createTextNode(expressionValue.getStringValue());
                nodeSet = new NodeSet();
                nodeSet.add(text);
            }
            return nodeSet;
        }
        catch (ClassCastException classCastException) {
            throw new XPathEvaluationException("pe11");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new XPathEvaluationException("pe9");
        }
    }

    public String toString() {
        return "node-set";
    }

    protected static FunctionSignature createSignature(NamespaceName namespaceName) {
        try {
            Class[] classArray = new Class[]{Class.forName("com.novell.xml.xpath.ExpressionValue")};
            return new FunctionSignature(new ExpandedQName(namespaceName, "node-set"), NodeSet.getArgType(), classArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new Error(classNotFoundException.getLocalizedMessage());
        }
    }
}

