/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.number;

import com.novell.xsl.number.NumberFormatter;
import com.novell.xsl.util.Util;

public class DecimalNumberFormatter
implements NumberFormatter {
    private final char firstDigit;
    private final int minDigits;

    public DecimalNumberFormatter(char c, int n) {
        if (Character.digit(c, 10) != 0) {
            throw new IllegalArgumentException("illegal first digit: " + Util.unicodeEscape(c));
        }
        if (n < 0) {
            throw new IllegalArgumentException("illegal minimum number of digits: " + n);
        }
        this.firstDigit = c;
        this.minDigits = n;
    }

    public String format(int n) throws IllegalArgumentException {
        char[] cArray;
        if (n <= 0) {
            throw new IllegalArgumentException("illegal value: " + n);
        }
        String string = Integer.toString(n);
        int n2 = string.length();
        if (n2 >= this.minDigits && this.firstDigit == '0') {
            return string;
        }
        if (n2 >= this.minDigits) {
            cArray = new char[n2];
        } else {
            cArray = new char[this.minDigits];
            int n3 = this.minDigits - n2 - 1;
            while (n3 >= 0) {
                cArray[n3] = this.firstDigit;
                --n3;
            }
        }
        char[] cArray2 = string.toCharArray();
        int n4 = this.firstDigit - 48;
        int n5 = cArray.length;
        do {
            cArray[--n5] = (char)(cArray2[--n2] + n4);
        } while (n2 > 0);
        return new String(cArray);
    }
}

