/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.number;

import com.novell.xsl.number.AlphabeticNumberFormatter;
import com.novell.xsl.number.DecimalNumberFormatter;
import com.novell.xsl.number.NumberFormatter;
import com.novell.xsl.number.RomanNumberFormatter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class NumberFormatters {
    private static final HashMap numericMap = new HashMap();
    private static final HashMap langMap = new HashMap();
    private static final LanguageMap enMap = new LanguageMap();
    private static final NumberFormatter defaultFormatter = new DecimalNumberFormatter('0', 1);

    private NumberFormatters() {
    }

    public static void add(String string, String string2, String string3, NumberFormatter numberFormatter) throws IllegalArgumentException {
        boolean bl = NumberFormatters.isDecimalFormatToken(string);
        if (string == null || string.equals("") || string.equals("A") || string.equals("a") || string.equals("I") || string.equals("i") || bl) {
            throw new IllegalArgumentException("illegal format token: " + string);
        }
        LanguageMap languageMap = NumberFormatters.createLanguageMap(string2);
        languageMap.setFormatter(numberFormatter, string, string3 == null || "alphabetic".equals(string3));
    }

    public static NumberFormatter get(String string, String string2, String string3) {
        NumberFormatter numberFormatter = null;
        boolean bl = NumberFormatters.isDecimalFormatToken(string);
        if (bl) {
            numberFormatter = (NumberFormatter)numericMap.get(string);
            if (numberFormatter == null) {
                int n = string.length();
                char c = (char)(string.charAt(n - 1) - '\u0001');
                numberFormatter = new DecimalNumberFormatter(c, n);
                numericMap.put(string, numberFormatter);
            }
        } else if (string.equals("A") || string.equals("a") || string.equals("I") || string.equals("i")) {
            numberFormatter = enMap.getFormatter(string, true);
        } else {
            LanguageMap languageMap = NumberFormatters.getLanguageMap(string2);
            if (languageMap != null) {
                numberFormatter = languageMap.getFormatter(string, string3 == null || "alphabetic".equals(string3));
            }
        }
        if (numberFormatter == null) {
            numberFormatter = defaultFormatter;
        }
        return numberFormatter;
    }

    private static boolean isDecimalFormatToken(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        if (n == 0) {
            return false;
        }
        char c = string.charAt(n - 1);
        if (Character.digit(c, 10) != 1) {
            return false;
        }
        int n2 = 0;
        while (n2 < n - 1) {
            if (string.charAt(n2) != c - '\u0001') {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static LanguageMap createLanguageMap(String string) {
        String string2 = string.toUpperCase(Locale.US);
        LanguageMap languageMap = (LanguageMap)langMap.get(string2);
        if (languageMap == null) {
            langMap.put(string2, new LanguageMap());
        }
        return languageMap;
    }

    private static LanguageMap getLanguageMap(String string) {
        String string2 = string.toUpperCase(Locale.US);
        LanguageMap languageMap = (LanguageMap)langMap.get(string2);
        if (languageMap == null) {
            int n;
            while (languageMap == null && (n = string2.lastIndexOf(45)) > 0) {
                string2 = string2.substring(0, n);
                languageMap = (LanguageMap)langMap.get(string2);
            }
        }
        return languageMap;
    }

    static {
        numericMap.put("1", defaultFormatter);
        enMap.setFormatter(new AlphabeticNumberFormatter("ABCDEFGHIJKLMNOPQRSTUVWXYZ"), "A", true);
        enMap.setFormatter(new AlphabeticNumberFormatter("abcdefghijklmnopqrstuvwxyz"), "a", true);
        enMap.setFormatter(new RomanNumberFormatter(false), "I", true);
        enMap.setFormatter(new RomanNumberFormatter(true), "i", true);
        langMap.put("EN", enMap);
        langMap.put("EN-US", enMap);
    }

    private static class LanguageMap {
        private Map alphabeticFormatters = null;
        private Map traditionalFormatters = null;

        private LanguageMap() {
        }

        public NumberFormatter getFormatter(String string, boolean bl) {
            if (bl) {
                if (this.alphabeticFormatters != null) {
                    return (NumberFormatter)this.alphabeticFormatters.get(string);
                }
            } else if (this.traditionalFormatters != null) {
                return (NumberFormatter)this.traditionalFormatters.get(string);
            }
            return null;
        }

        public void setFormatter(NumberFormatter numberFormatter, String string, boolean bl) {
            if (bl) {
                if (this.alphabeticFormatters == null) {
                    this.alphabeticFormatters = new HashMap();
                }
                this.alphabeticFormatters.put(string, numberFormatter);
            } else {
                if (this.traditionalFormatters == null) {
                    this.traditionalFormatters = new HashMap();
                }
                this.traditionalFormatters.put(string, numberFormatter);
            }
        }
    }
}

