/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.parser;

import com.novell.xml.util.ExpandedQName;
import com.novell.xml.util.XMLUtil;
import com.novell.xsl.parser.AttrDef;
import com.novell.xsl.parser.StylesheetParser;
import com.novell.xsl.parser.XSLTParserException;
import com.novell.xsl.result.SerializerOptions;
import java.util.Collection;
import org.w3c.dom.Element;

public class OutputParser {
    private static AttrDef[] outputAttr = new AttrDef[]{new AttrDef("method", 0, null, 6), new AttrDef("version", 0, null, 9), new AttrDef("indent", 0, -1, new String[]{"no", "yes"}), new AttrDef("encoding", 0, null, 9), new AttrDef("media-type", 0, null, 9), new AttrDef("doctype-system", 0, null, 9), new AttrDef("doctype-public", 0, null, 9), new AttrDef("omit-xml-declaration", 0, 0, new String[]{"no", "yes"}), new AttrDef("standalone", 0, 0, new String[]{"no", "yes"}), new AttrDef("cdata-section-elements", 0, null, 9)};

    public static void parse(StylesheetParser stylesheetParser, Element element) throws XSLTParserException {
        Object[] objectArray = AttrDef.parseAttributes(stylesheetParser, element, outputAttr);
        SerializerOptions serializerOptions = new SerializerOptions();
        if (objectArray[0] != null) {
            serializerOptions.setMethod((ExpandedQName)objectArray[0]);
        }
        if (objectArray[1] != null) {
            serializerOptions.setVersion((String)objectArray[1]);
        }
        if (objectArray[2] != null) {
            serializerOptions.setIndent((Integer)objectArray[2] != 0);
        }
        if (objectArray[3] != null) {
            if (!XMLUtil.isXMLEncName((String)objectArray[3])) {
                stylesheetParser.reportInvalidAttributeValue(element, "encoding", false, (String)objectArray[3]);
            } else {
                serializerOptions.setEncoding((String)objectArray[3]);
            }
        }
        if (objectArray[4] != null) {
            serializerOptions.setMediaType((String)objectArray[4]);
        }
        if (objectArray[5] != null) {
            serializerOptions.setDoctypeSystem((String)objectArray[5]);
        }
        if (objectArray[6] != null) {
            serializerOptions.setDoctypePublic((String)objectArray[6]);
        }
        if (objectArray[7] != null) {
            serializerOptions.setDeclaration((Integer)objectArray[7] == 0);
        }
        if (objectArray[8] != null) {
            serializerOptions.setStandalone((Integer)objectArray[8] != 0);
        }
        if (objectArray[9] != null) {
            Collection collection = stylesheetParser.parseQNames(element.getAttributeNode("cdata-section-elements"), (String)objectArray[9]);
            serializerOptions.setCdataSectionElements(collection);
        }
        stylesheetParser.getStylesheet().setSerializerOptions(serializerOptions, stylesheetParser.getImportPrecedence());
    }
}

