/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.parser;

import com.novell.xml.util.ExpandedQName;
import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.VariableBindings;
import com.novell.xsl.process.VariablePlaceholder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public class ParserVariables
implements VariableBindings {
    private Map globalVariables = null;
    private Map templateVariables = null;
    private Stack stack = null;

    public Expression getVariable(ExpandedQName expandedQName) {
        Expression expression;
        if (this.templateVariables != null && (expression = (Expression)this.templateVariables.get(expandedQName)) != null) {
            return expression;
        }
        this.ensureGlobals();
        expression = (Expression)this.globalVariables.get(expandedQName);
        if (expression != null) {
            return expression;
        }
        expression = new VariablePlaceholder(expandedQName);
        this.globalVariables.put(expandedQName, expression);
        return expression;
    }

    public void bindTopLevelVariable(ExpandedQName expandedQName, Expression expression) {
        this.ensureGlobals();
        Expression expression2 = (Expression)this.globalVariables.get(expandedQName);
        if (expression2 != null && expression2 instanceof VariablePlaceholder) {
            ((VariablePlaceholder)expression2).setVariable(expression);
        }
        this.globalVariables.put(expandedQName, expression);
    }

    public void bindTemplateVariable(ExpandedQName expandedQName, Expression expression) {
        if (this.templateVariables == null) {
            this.templateVariables = new HashMap();
        } else if (!this.stack.empty() && this.templateVariables == (Map)this.stack.peek()) {
            this.templateVariables = new HashMap(this.templateVariables);
        }
        this.templateVariables.put(expandedQName, expression);
    }

    public boolean haveTemplateVariable(ExpandedQName expandedQName) {
        return this.templateVariables != null && this.templateVariables.containsKey(expandedQName);
    }

    public void resetTemplateVariables() {
        if (this.templateVariables != null) {
            this.templateVariables.clear();
        }
    }

    public void pushTemplateVariables() {
        if (this.stack == null) {
            this.stack = new Stack();
        }
        this.stack.push(this.templateVariables);
    }

    public void popTemplateVariables() {
        if (this.stack != null && !this.stack.empty()) {
            this.templateVariables = (Map)this.stack.pop();
        }
    }

    public Collection getTemplateVariables() {
        return this.templateVariables != null ? this.templateVariables.values() : null;
    }

    public Collection getTopLevelVariables() {
        return this.globalVariables != null ? this.globalVariables.values() : null;
    }

    private void ensureGlobals() {
        if (this.globalVariables == null) {
            this.globalVariables = new HashMap();
        }
    }
}

