/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.parser;

import com.novell.xml.dom.DOMUtil;
import com.novell.xml.dom.NodeImpl;
import com.novell.xml.parser.XMLParser;
import com.novell.xml.parser.XMLParserFactory;
import com.novell.xml.util.ExpandedQName;
import com.novell.xml.util.NamespaceName;
import com.novell.xml.util.XMLUtil;
import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.Function;
import com.novell.xml.xpath.FunctionLibrary;
import com.novell.xml.xpath.NamespaceContext;
import com.novell.xml.xpath.Parser;
import com.novell.xml.xpath.WildcardName;
import com.novell.xml.xpath.XPathException;
import com.novell.xml.xpath.XPathParserException;
import com.novell.xml.xpath.XPathUtil;
import com.novell.xsl.Stylesheet;
import com.novell.xsl.XSLException;
import com.novell.xsl.extensions.AssignVariableTemplate;
import com.novell.xsl.extensions.BadExpression;
import com.novell.xsl.extensions.BadFunction;
import com.novell.xsl.extensions.BadTemplate;
import com.novell.xsl.extensions.TraceMessageTemplate;
import com.novell.xsl.parser.AVT;
import com.novell.xsl.parser.ApplyImportsParser;
import com.novell.xsl.parser.ApplyTemplatesParser;
import com.novell.xsl.parser.AttrDef;
import com.novell.xsl.parser.AttributeParser;
import com.novell.xsl.parser.AttributeSetParser;
import com.novell.xsl.parser.CallTemplateParser;
import com.novell.xsl.parser.ChooseParser;
import com.novell.xsl.parser.CommentParser;
import com.novell.xsl.parser.CopyOfParser;
import com.novell.xsl.parser.CopyParser;
import com.novell.xsl.parser.DecimalFormatParser;
import com.novell.xsl.parser.ElementParser;
import com.novell.xsl.parser.ExpressionParser;
import com.novell.xsl.parser.ForEachParser;
import com.novell.xsl.parser.IfParser;
import com.novell.xsl.parser.KeyParser;
import com.novell.xsl.parser.MessageParser;
import com.novell.xsl.parser.NamespaceAliasParser;
import com.novell.xsl.parser.NumberParser;
import com.novell.xsl.parser.OutputParser;
import com.novell.xsl.parser.ParserVariables;
import com.novell.xsl.parser.PreserveSpaceParser;
import com.novell.xsl.parser.ProcessingInstructionParser;
import com.novell.xsl.parser.StripSpaceParser;
import com.novell.xsl.parser.TemplateParser;
import com.novell.xsl.parser.TemplateVariableParser;
import com.novell.xsl.parser.TextParser;
import com.novell.xsl.parser.TopLevelParamParser;
import com.novell.xsl.parser.TopLevelVariableParser;
import com.novell.xsl.parser.ValueOfParser;
import com.novell.xsl.parser.XSLTParserException;
import com.novell.xsl.parser.XsltFunctionLibrary;
import com.novell.xsl.pattern.Pattern;
import com.novell.xsl.process.BuiltInTemplateRule;
import com.novell.xsl.process.ElementMatch;
import com.novell.xsl.process.FallbackTemplate;
import com.novell.xsl.process.FallbackTemplatesTemplate;
import com.novell.xsl.process.IdentityExpr;
import com.novell.xsl.process.LiteralElementTemplate;
import com.novell.xsl.process.Mode;
import com.novell.xsl.process.ProcessException;
import com.novell.xsl.process.ProcessingEnv;
import com.novell.xsl.process.RuleCollection;
import com.novell.xsl.process.SortKey;
import com.novell.xsl.process.Template;
import com.novell.xsl.process.TemplateRule;
import com.novell.xsl.process.TextTemplate;
import com.novell.xsl.process.ValueOfTemplate;
import com.novell.xsl.process.VariablePlaceholder;
import com.novell.xsl.util.Util;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class StylesheetParser
implements NamespaceContext,
FunctionLibrary {
    private static AttrDef[] fallbackAttr = new AttrDef[0];
    private static AttrDef[] importAttr = new AttrDef[]{new AttrDef("href", 1, null, 9)};
    private static AttrDef[] includeAttr = new AttrDef[]{new AttrDef("href", 1, null, 9)};
    private static AttrDef[] sortAttr = new AttrDef[]{new AttrDef("select", 0, null, 11), new AttrDef("order", 0, null, 0), new AttrDef("lang", 0, null, 0), new AttrDef("data-type", 0, null, 0), new AttrDef("case-order", 0, null, 0)};
    private static AttrDef[] stylesheetAttr = new AttrDef[]{new AttrDef("version", 1, null, 9), new AttrDef("id", 0, null, 5), new AttrDef("extension-element-prefixes", 0, null, 9), new AttrDef("exclude-result-prefixes", 0, null, 9)};
    private Stylesheet stylesheet;
    private FunctionLibrary library;
    private int importance;
    private int nextImportPrecedence;
    private static final int IMPORT_GAP = 64;
    private int elementNumber;
    private Set extElementNamespaces = new HashSet();
    private Set excludedResultNamespaces = new HashSet();
    private Stack namespacesStack = new Stack();
    private Stack baseURIStack = new Stack();
    private com.novell.xsl.pattern.Parser patternParser;
    private ExpressionParser xpathParser;
    private ParserVariables variables = new ParserVariables();
    private Stack nsContextStack = new Stack();
    private Stack includeStack = new Stack();
    private boolean forwardsCompatibleMode = false;
    private Map namedObjects = null;
    private static Class[] PARSER_ARGS = new Class[]{XPathUtil.doGetClass("com.novell.xsl.parser.StylesheetParser"), XPathUtil.doGetClass("org.w3c.dom.Element")};

    public StylesheetParser(Stylesheet stylesheet) {
        this(stylesheet, new XsltFunctionLibrary());
    }

    public StylesheetParser(Stylesheet stylesheet, FunctionLibrary functionLibrary) {
        this(stylesheet, functionLibrary, false);
    }

    public StylesheetParser(Stylesheet stylesheet, FunctionLibrary functionLibrary, boolean bl) {
        this.stylesheet = stylesheet;
        this.library = functionLibrary;
        this.patternParser = new com.novell.xsl.pattern.Parser(this, this.variables, this, this);
        this.xpathParser = new ExpressionParser(this, this.variables, this, this);
        this.patternParser.setBrokenMode(bl);
        this.xpathParser.setBrokenMode(bl);
    }

    public void setBuiltInDefinitions(Node node) throws XSLTParserException {
        try {
            RuleCollection ruleCollection = this.stylesheet.getTemplateRules();
            TemplateRule templateRule = new BuiltInTemplateRule(this.patternParser.parsePattern("*", true), -1, null, this.elementNumber++, node);
            ruleCollection.setBuiltIn(templateRule, 1);
            templateRule = (TemplateRule)templateRule.cloneForUnion(this.patternParser.parsePattern("/", true));
            ruleCollection.setBuiltIn(templateRule, 9);
            ValueOfTemplate valueOfTemplate = new ValueOfTemplate(new IdentityExpr(), false, node);
            templateRule = new TemplateRule(this.patternParser.parsePattern("text()", true), null, new Template[]{valueOfTemplate}, null, Mode.ANY_MODE, -1, null, this.elementNumber++, node);
            ruleCollection.setBuiltIn(templateRule, 3);
            ruleCollection.setBuiltIn(templateRule, 4);
            templateRule = (TemplateRule)templateRule.cloneForUnion(this.patternParser.parsePattern("@*", true));
        }
        catch (XPathParserException xPathParserException) {
            this.reportError(xPathParserException.getMessage());
        }
    }

    public void parse(Document document, URL uRL) throws XSLTParserException {
        this.importance = Integer.MAX_VALUE;
        this.nextImportPrecedence = this.importance / 2;
        this.includeStylesheet(document, uRL);
        this.checkVariables();
    }

    public boolean isForwardsCompatibleMode() {
        return this.forwardsCompatibleMode;
    }

    public Stylesheet getStylesheet() {
        return this.stylesheet;
    }

    public Parser getXPathParser() {
        return this.xpathParser;
    }

    public com.novell.xsl.pattern.Parser getPatternParser() {
        return this.patternParser;
    }

    public int getImportPrecedence() {
        return this.importance;
    }

    public int getElementNumber() {
        return this.elementNumber++;
    }

    public ParserVariables getVariables() {
        return this.variables;
    }

    public void setNamedObject(String string, Object object) {
        if (this.namedObjects == null) {
            this.namedObjects = new HashMap();
        }
        this.namedObjects.put(string, object);
    }

    public Object getNamedObject(String string) {
        return this.namedObjects == null ? null : this.namedObjects.get(string);
    }

    public Object removeNamedObject(String string) {
        return this.namedObjects == null ? null : this.namedObjects.remove(string);
    }

    protected void checkVariables() throws XSLTParserException {
        Collection collection = this.variables.getTopLevelVariables();
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Expression expression = (Expression)iterator.next();
                if (!(expression instanceof VariablePlaceholder)) continue;
                this.reportError(null, "spe1", ((VariablePlaceholder)expression).getName().getQName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void includeStylesheet(Document document, URL uRL) throws XSLTParserException {
        block4: {
            this.baseURIStack.push(uRL);
            try {
                Element element = document.getDocumentElement();
                if (element == null) {
                    this.reportError(document, "spe2");
                    break block4;
                }
                ExpandedQName expandedQName = DOMUtil.getExpandedName(element);
                if (!expandedQName.namespaceNameEquals(Stylesheet.NAMESPACE) || !expandedQName.localPartEquals("stylesheet") && !expandedQName.localPartEquals("transform")) {
                    this.pushNSContext(element);
                    this.simplifiedStylesheet(element, this.stylesheet.getTemplateRules());
                    this.popNSContext();
                    Object var6_5 = null;
                    this.baseURIStack.pop();
                    return;
                }
                this.pushNSContext(element);
                this.parseStylesheet(element);
                this.popNSContext();
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.baseURIStack.pop();
                throw throwable;
            }
        }
        Object var6_6 = null;
        this.baseURIStack.pop();
    }

    public Function getFunction(ExpandedQName expandedQName) throws XPathParserException {
        try {
            return this.library.getFunction(expandedQName);
        }
        catch (XPathParserException xPathParserException) {
            if (this.forwardsCompatibleMode && expandedQName.getNamespaceName().isEmpty()) {
                return new BadFunction(xPathParserException.getMessage());
            }
            throw xPathParserException;
        }
    }

    public boolean isFunctionAvailable(ExpandedQName expandedQName) {
        return this.library.isFunctionAvailable(expandedQName);
    }

    public void addFunction(Function function) {
        this.library.addFunction(function);
    }

    public NamespaceName getNamespaceName(String string) {
        if (string == null || string.length() <= 0 || this.nsContextStack.empty()) {
            return NamespaceName.NULL_NAMESPACE;
        }
        String string2 = DOMUtil.getURIforNSPrefix(string, (Node)this.nsContextStack.peek());
        if (string2 == null) {
            return NamespaceName.NULL_NAMESPACE;
        }
        return new NamespaceName(string2);
    }

    private Node getNamespaceContext() {
        return this.nsContextStack.empty() ? null : (Node)this.nsContextStack.peek();
    }

    public ExpandedQName getExpandedName(String string) {
        int n = string.indexOf(58);
        if (n == -1) {
            return new ExpandedQName("", string);
        }
        String string2 = string.substring(n + 1, string.length());
        String string3 = string.substring(0, n);
        return new ExpandedQName(this.getNamespaceName(string3), string2, string3);
    }

    public void pushNSContext(Node node) {
        this.nsContextStack.push(node);
    }

    public Node popNSContext() {
        if (this.nsContextStack.empty()) {
            return null;
        }
        return (Node)this.nsContextStack.pop();
    }

    private void pushIncludeState() {
        this.includeStack.push(this.forwardsCompatibleMode ? Boolean.TRUE : Boolean.FALSE);
        this.includeStack.push(this.nsContextStack);
        this.nsContextStack = new Stack();
        this.includeStack.push(this.extElementNamespaces);
        this.includeStack.push(this.excludedResultNamespaces);
        this.extElementNamespaces = new HashSet();
    }

    private void popIncludeState() {
        this.excludedResultNamespaces = (Set)this.includeStack.pop();
        this.extElementNamespaces = (Set)this.includeStack.pop();
        this.nsContextStack = (Stack)this.includeStack.pop();
        this.forwardsCompatibleMode = (Boolean)this.includeStack.pop();
    }

    protected void parseStylesheet(Element element) throws XSLTParserException {
        Object object;
        Object[] objectArray;
        Attr attr;
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = 0;
        while ((attr = (Attr)namedNodeMap.item(n++)) != null) {
            objectArray = DOMUtil.getExpandedName(attr);
            if (!objectArray.getNamespaceName().isEmpty() || !objectArray.localPartEquals("version")) continue;
            this.forwardsCompatibleMode = !attr.getNodeValue().equals("1.0");
            break;
        }
        objectArray = AttrDef.parseAttributes(this, element, stylesheetAttr);
        if (objectArray[0] == null) {
            return;
        }
        if (objectArray[1] != null) {
            this.stylesheet.setID((String)objectArray[1]);
        }
        if (objectArray[2] != null) {
            object = this.parseElementPrefixes(element, (String)objectArray[2]);
            n = 0;
            while (n < ((NamespaceName[])object).length) {
                this.extElementNamespaces.add(object[n]);
                ++n;
            }
        }
        if (objectArray[3] != null) {
            object = this.parseElementPrefixes(element, (String)objectArray[3]);
            n = 0;
            while (n < ((NamespaceName[])object).length) {
                this.excludedResultNamespaces.add(object[n]);
                ++n;
            }
        }
        object = element.getFirstChild();
        boolean bl = true;
        while (object != null) {
            switch (object.getNodeType()) {
                case 1: {
                    Element element2 = (Element)object;
                    ExpandedQName expandedQName = DOMUtil.getExpandedName(element2);
                    if (expandedQName.namespaceNameEquals(Stylesheet.NAMESPACE)) {
                        if (expandedQName.localPartEquals("import")) {
                            if (bl) {
                                this.parseImport(element2);
                                break;
                            }
                            this.reportError(element, element2, "spe3");
                            break;
                        }
                        bl = false;
                        this.pushNSContext(element2);
                        if (expandedQName.localPartEquals("template")) {
                            TemplateParser.parse(this, element2);
                        } else if (expandedQName.localPartEquals("variable")) {
                            TopLevelVariableParser.parse(this, element2);
                        } else if (expandedQName.localPartEquals("param")) {
                            TopLevelParamParser.parse(this, element2);
                        } else if (expandedQName.localPartEquals("attribute-set")) {
                            AttributeSetParser.parse(this, element2);
                        } else if (expandedQName.localPartEquals("include")) {
                            this.parseInclude(element2);
                        } else if (expandedQName.localPartEquals("preserve-space")) {
                            PreserveSpaceParser.parse(this, element2);
                        } else if (expandedQName.localPartEquals("strip-space")) {
                            StripSpaceParser.parse(this, element2);
                        } else if (expandedQName.localPartEquals("key")) {
                            KeyParser.parse(this, element2);
                        } else if (expandedQName.localPartEquals("decimal-format")) {
                            DecimalFormatParser.parse(this, element2);
                        } else if (expandedQName.localPartEquals("output")) {
                            OutputParser.parse(this, element2);
                        } else if (expandedQName.localPartEquals("namespace-alias")) {
                            NamespaceAliasParser.parse(this, element2);
                        } else if (!this.forwardsCompatibleMode) {
                            this.reportError(element, element2, "spe4");
                        }
                        this.popNSContext();
                        break;
                    }
                    if (expandedQName.getNamespaceName().isEmpty()) {
                        if (this.forwardsCompatibleMode) break;
                        this.reportError(element, element2, "spe4");
                        break;
                    }
                    this.parseTopLevelExtElement(element, expandedQName.getNamespaceName());
                    break;
                }
                case 7: 
                case 8: {
                    break;
                }
                case 3: 
                case 4: {
                    if (XMLUtil.isXMLWhitespace(object.getNodeValue())) break;
                    this.reportError((Node)object, "spe4");
                    break;
                }
                default: {
                    this.reportError((Node)object, "spe4");
                }
            }
            object = object.getNextSibling();
        }
    }

    protected void simplifiedStylesheet(Element element, RuleCollection ruleCollection) throws XSLTParserException {
        try {
            Template[] templateArray;
            Object object;
            NamedNodeMap namedNodeMap = element.getAttributes();
            boolean bl = false;
            int n = 0;
            while (n < namedNodeMap.getLength()) {
                object = (Attr)namedNodeMap.item(n);
                templateArray = DOMUtil.getExpandedName((Node)object);
                if (templateArray.namespaceNameEquals(Stylesheet.NAMESPACE) && templateArray.localPartEquals("version")) {
                    bl = true;
                    this.forwardsCompatibleMode = !object.getNodeValue().equals("1.0");
                }
                ++n;
            }
            if (!bl) {
                this.reportError((Node)element, "spe5", "xsl:version");
            }
            object = this.patternParser.parsePattern("/", true);
            templateArray = this.parseTemplates(element, false);
            ruleCollection.add(new TemplateRule((Pattern)object, null, templateArray, null, Mode.DEFAULT_MODE, this.importance, null, this.elementNumber++, element));
        }
        catch (XPathParserException xPathParserException) {
            this.reportError(element, xPathParserException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseImport(Element element) throws XSLTParserException {
        URL[] uRLArray = new URL[1];
        Document document = this.parseIncludeOrImport(element, uRLArray);
        if (document != null) {
            int n = this.importance;
            int n2 = this.nextImportPrecedence;
            this.pushIncludeState();
            this.importance = this.nextImportPrecedence;
            this.nextImportPrecedence -= 63;
            try {
                this.includeStylesheet(document, uRLArray[0]);
                Object var7_6 = null;
                this.popIncludeState();
                this.nextImportPrecedence = n2 + 64;
                this.importance = n;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.popIncludeState();
                this.nextImportPrecedence = n2 + 64;
                this.importance = n;
                throw throwable;
            }
        }
    }

    protected void parseInclude(Element element) throws XSLTParserException {
        URL[] uRLArray = new URL[1];
        Document document = this.parseIncludeOrImport(element, uRLArray);
        if (document != null) {
            this.pushIncludeState();
            this.includeStylesheet(document, uRLArray[0]);
            this.popIncludeState();
        }
    }

    protected Document parseIncludeOrImport(Element element, URL[] uRLArray) throws XSLTParserException {
        Object[] objectArray = AttrDef.parseAttributes(this, element, importAttr);
        if (objectArray[0] == null) {
            return null;
        }
        String string = (String)objectArray[0];
        if (element.hasChildNodes()) {
            this.reportError(element, "spe4");
        }
        try {
            XMLParser xMLParser = XMLParserFactory.newParser();
            uRLArray[0] = string.length() > 0 ? new URL((URL)this.baseURIStack.peek(), string) : (URL)this.baseURIStack.peek();
            if (this.baseURIStack.contains(uRLArray[0])) {
                this.reportError((Node)element, "spe9", string);
                return null;
            }
            xMLParser.setContextURI(uRLArray[0].toString());
            Document document = xMLParser.parse(uRLArray[0].openStream());
            if (xMLParser.anyErrors()) {
                this.reportError(element, xMLParser.getErrorMsgString());
            }
            if (this.getStylesheet().getXmlHook() != null) {
                document = this.getStylesheet().getXmlHook().processDocument(document);
            }
            return document;
        }
        catch (MalformedURLException malformedURLException) {
            this.reportError(element, malformedURLException.toString());
            return null;
        }
        catch (IOException iOException) {
            this.reportError(element, iOException.toString());
            return null;
        }
        catch (Exception exception) {
            this.reportError(element, exception.toString());
            return null;
        }
    }

    public void parseStrippingList(Element element, String string, boolean bl) throws XSLTParserException {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            try {
                WildcardName wildcardName = new WildcardName(string2, (NamespaceContext)this);
                ElementMatch elementMatch = new ElementMatch(wildcardName, bl, this.importance, this.elementNumber++);
                this.stylesheet.getStripList().add(elementMatch);
            }
            catch (XPathException xPathException) {
                this.reportError(element, xPathException.getLocalizedMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Template[] parseTemplates(Node node, boolean bl) throws XSLTParserException {
        this.variables.pushTemplateVariables();
        try {
            Template[] templateArray;
            Object object;
            ArrayList<Template[]> arrayList = new ArrayList<Template[]>();
            while (node != null) {
                object = null;
                switch (node.getNodeType()) {
                    case 1: {
                        templateArray = (Template[])node;
                        ExpandedQName expandedQName = DOMUtil.getExpandedName((Node)templateArray);
                        if (expandedQName.namespaceNameEquals(Stylesheet.NAMESPACE)) {
                            this.pushNSContext((Node)templateArray);
                            if (expandedQName.localPartEquals("apply-templates")) {
                                object = ApplyTemplatesParser.parse(this, (Element)templateArray);
                            } else if (expandedQName.localPartEquals("call-template")) {
                                object = CallTemplateParser.parse(this, (Element)templateArray);
                            } else if (expandedQName.localPartEquals("apply-imports")) {
                                object = ApplyImportsParser.parse(this, (Element)templateArray);
                            } else if (expandedQName.localPartEquals("variable")) {
                                object = TemplateVariableParser.parse(this, (Element)templateArray);
                            } else if (expandedQName.localPartEquals("param")) {
                                this.reportError((Node)templateArray, "spe3");
                            } else if (expandedQName.localPartEquals("for-each")) {
                                object = ForEachParser.parse(this, (Element)templateArray);
                            } else if (expandedQName.localPartEquals("text")) {
                                object = TextParser.parse(this, (Element)templateArray);
                            } else if (expandedQName.localPartEquals("value-of")) {
                                object = ValueOfParser.parse(this, (Element)templateArray);
                            } else if (expandedQName.localPartEquals("if")) {
                                object = IfParser.parse(this, (Element)templateArray);
                            } else if (expandedQName.localPartEquals("choose")) {
                                object = ChooseParser.parse(this, (Element)templateArray);
                            } else if (expandedQName.localPartEquals("element")) {
                                object = ElementParser.parse(this, (Element)templateArray);
                            } else if (expandedQName.localPartEquals("attribute")) {
                                object = AttributeParser.parse(this, (Element)templateArray);
                            } else if (expandedQName.localPartEquals("number")) {
                                object = NumberParser.parse(this, (Element)templateArray);
                            } else if (expandedQName.localPartEquals("copy")) {
                                object = CopyParser.parse(this, (Element)templateArray);
                            } else if (expandedQName.localPartEquals("copy-of")) {
                                object = CopyOfParser.parse(this, (Element)templateArray);
                            } else if (expandedQName.localPartEquals("comment")) {
                                object = CommentParser.parse(this, (Element)templateArray);
                            } else if (expandedQName.localPartEquals("processing-instruction")) {
                                object = ProcessingInstructionParser.parse(this, (Element)templateArray);
                            } else if (expandedQName.localPartEquals("sort")) {
                                this.reportError((Node)templateArray, bl ? "spe3" : "spe4");
                            } else if (expandedQName.localPartEquals("message")) {
                                object = MessageParser.parse(this, (Element)templateArray);
                            } else if (this.forwardsCompatibleMode) {
                                object = this.handleElementFallback((Element)templateArray);
                            } else {
                                this.reportError((Node)templateArray, "spe4");
                            }
                            this.popNSContext();
                            break;
                        }
                        if (this.extElementNamespaces.contains(expandedQName.getNamespaceName())) {
                            this.pushNSContext((Node)templateArray);
                            object = this.parseExtElement((Element)templateArray, expandedQName.getNamespaceName());
                            this.popNSContext();
                            break;
                        }
                        this.pushNSContext((Node)templateArray);
                        object = this.parseLiteralElement((Element)templateArray);
                        this.popNSContext();
                        break;
                    }
                    case 7: 
                    case 8: {
                        break;
                    }
                    case 3: 
                    case 4: {
                        if (Util.stripWhitespaceNode(node)) break;
                        object = new TextTemplate(node.getNodeValue(), false, node);
                        break;
                    }
                    default: {
                        this.reportError(node, "spe4");
                    }
                }
                if (object != null) {
                    arrayList.add((Template[])object);
                }
                node = node.getNextSibling();
            }
            object = new Template[arrayList.size()];
            arrayList.toArray((T[])object);
            templateArray = object;
            Object var8_7 = null;
            this.variables.popTemplateVariables();
            return templateArray;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.variables.popTemplateVariables();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected Template parseLiteralElement(Element var1_1) throws XSLTParserException {
        block18: {
            var2_2 = null;
            var3_3 = null;
            var4_4 = null;
            var5_5 = var1_1.getAttributes();
            var6_6 = new String[var5_5.getLength()];
            var7_7 = new Expression[var5_5.getLength()];
            var8_8 = 0;
            while (var8_8 < var5_5.getLength()) {
                block20: {
                    block19: {
                        var9_9 = var5_5.item(var8_8);
                        var10_12 = var9_9.getNodeName();
                        if (!var10_12.startsWith("xmlns")) break block19;
                        var6_6[var8_8] = null;
                        var7_7[var8_8] = null;
                        break block20;
                    }
                    var11_13 = var10_12.indexOf(58);
                    if (var11_13 <= 0 || !(var13_16 = this.getNamespaceName(var12_14 = var10_12.substring(0, var11_13))).equals(Stylesheet.NAMESPACE)) ** GOTO lbl36
                    var14_17 = DOMUtil.getLocalName((Node)var9_9);
                    if (var14_17.equals("extension-element-prefixes")) {
                        var2_2 = this.parseElementPrefixes((Node)var9_9, var9_9.getNodeValue());
                        var6_6[var8_8] = null;
                        var7_7[var8_8] = null;
                    } else if (var14_17.equals("exclude-result-prefixes")) {
                        var3_3 = this.parseElementPrefixes((Node)var9_9, var9_9.getNodeValue());
                        var6_6[var8_8] = null;
                        var7_7[var8_8] = null;
                    } else if (var14_17.equals("use-attribute-sets")) {
                        var4_4 = this.parseQNames((Node)var9_9, var9_9.getNodeValue());
                        var6_6[var8_8] = null;
                        var7_7[var8_8] = null;
                    } else {
                        if (var14_17.equals("version")) {
                            this.forwardsCompatibleMode = var9_9.getNodeValue().equals("1.0") == false;
                        }
lbl36:
                        // 4 sources

                        var6_6[var8_8] = var9_9.getNodeName();
                        try {
                            var7_7[var8_8] = AVT.parse(var9_9.getNodeValue(), this.xpathParser, this.stylesheet.getErrorHandler());
                            var7_7[var8_8].registerForReset(this.stylesheet);
                        }
                        catch (XPathParserException var12_15) {
                            this.reportAttributeExpressionError(var1_1, var9_9.getNodeName(), var12_15);
                            return null;
                        }
                    }
                }
                ++var8_8;
            }
            if (var2_2 != null) {
                this.namespacesStack.push(new HashSet<E>(this.extElementNamespaces));
                var9_10 = 0;
                while (var9_10 < var2_2.length) {
                    this.extElementNamespaces.add(var2_2[var9_10]);
                    ++var9_10;
                }
            }
            if (var3_3 != null) {
                this.namespacesStack.push(new HashSet<E>(this.excludedResultNamespaces));
                var9_11 = 0;
                while (var9_11 < var3_3.length) {
                    this.excludedResultNamespaces.add(var3_3[var9_11]);
                    ++var9_11;
                }
            }
            try {
                var9_9 = this.parseTemplates(var1_1.getFirstChild(), false);
                var10_12 = new LiteralElementTemplate(var1_1.getTagName(), var6_6, var7_7, this.extElementNamespaces, this.excludedResultNamespaces, var4_4, var9_9, var1_1);
                var16_18 = null;
                if (var3_3 == null) break block18;
            }
            catch (Throwable var15_20) {
                block21: {
                    var16_19 = null;
                    if (var3_3 != null) {
                        this.excludedResultNamespaces = (Set)this.namespacesStack.pop();
                    }
                    if (var2_2 == null) break block21;
                    this.extElementNamespaces = (Set)this.namespacesStack.pop();
                }
                throw var15_20;
            }
            this.excludedResultNamespaces = (Set)this.namespacesStack.pop();
        }
        if (var2_2 != null) {
            this.extElementNamespaces = (Set)this.namespacesStack.pop();
        }
        return var10_12;
    }

    protected Template parseExtElement(Element element, NamespaceName namespaceName) throws XSLTParserException {
        if (namespaceName.equals(Stylesheet.NXSL_NAMESPACE)) {
            String string = DOMUtil.getLocalName(element);
            if (string.equals("assign-variable")) {
                return AssignVariableTemplate.parse(this, element);
            }
            if (string.equals("trace-message")) {
                return TraceMessageTemplate.parse(this, element);
            }
        } else if (namespaceName.getString().startsWith("http://www.novell.com/nxsl/java/")) {
            Method method;
            Object[] objectArray;
            String string = namespaceName.getString().substring("http://www.novell.com/nxsl/java/".length(), namespaceName.getString().length());
            try {
                objectArray = Class.forName(string);
                method = objectArray.getMethod("parse", PARSER_ARGS);
                if (!Modifier.isStatic(method.getModifiers())) {
                    throw new NoSuchMethodException("public static Template parse(StylesheetParser,Element)");
                }
            }
            catch (Throwable throwable) {
                this.reportWarning(element, throwable.toString());
                return this.handleElementFallback(element);
            }
            objectArray = new Object[]{this, element};
            try {
                return (Template)method.invoke(null, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw (XSLTParserException)invocationTargetException.getTargetException();
            }
            catch (Throwable throwable) {
                this.reportError(element, throwable.toString());
                return null;
            }
        }
        return this.handleElementFallback(element);
    }

    protected void parseTopLevelExtElement(Element element, NamespaceName namespaceName) throws XSLTParserException {
        if (namespaceName.getString().startsWith("http://www.novell.com/nxsl/java/")) {
            Method method;
            Object[] objectArray;
            String string = namespaceName.getString().substring("http://www.novell.com/nxsl/java/".length(), namespaceName.getString().length());
            try {
                objectArray = Class.forName(string);
                method = objectArray.getMethod("parse", PARSER_ARGS);
                if (!Modifier.isStatic(method.getModifiers())) {
                    throw new NoSuchMethodException("public static void parse(StylesheetParser,Element)");
                }
            }
            catch (Throwable throwable) {
                this.reportWarning(element, throwable.toString());
                return;
            }
            objectArray = new Object[]{this, element};
            try {
                method.invoke(null, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw (XSLTParserException)invocationTargetException.getTargetException();
            }
            catch (Throwable throwable) {
                this.reportError(element, throwable.toString());
                return;
            }
        }
    }

    protected Template handleElementFallback(Element element) throws XSLTParserException {
        Comparable comparable;
        Node node = element.getFirstChild();
        while (node != null) {
            comparable = DOMUtil.getExpandedName(node);
            if (((ExpandedQName)comparable).namespaceNameEquals(Stylesheet.NAMESPACE) && ((ExpandedQName)comparable).localPartEquals("fallback")) {
                return this.parseFallbackTemplates((Element)node, element);
            }
            node = node.getNextSibling();
        }
        comparable = ProcessingEnv.buildMsgPrologue(null, element);
        ((StringBuffer)comparable).append(ProcessException.constructMessage("pe17", new String[]{element.getTagName()}));
        return new BadTemplate(((StringBuffer)comparable).toString(), element);
    }

    protected FallbackTemplatesTemplate parseFallbackTemplates(Node node, Node node2) throws XSLTParserException {
        Object object;
        ArrayList<FallbackTemplate> arrayList = new ArrayList<FallbackTemplate>(4);
        while (node != null) {
            FallbackTemplate fallbackTemplate;
            if (node.getNodeType() == 1 && ((ExpandedQName)(object = DOMUtil.getExpandedName(node))).namespaceNameEquals(Stylesheet.NAMESPACE) && ((ExpandedQName)object).localPartEquals("fallback") && (fallbackTemplate = this.parseFallbackTemplate((Element)node)) != null) {
                arrayList.add(fallbackTemplate);
            }
            node = node.getNextSibling();
        }
        object = new Template[arrayList.size()];
        arrayList.toArray((T[])object);
        return new FallbackTemplatesTemplate((Template[])object, node2);
    }

    protected FallbackTemplate parseFallbackTemplate(Element element) throws XSLTParserException {
        AttrDef.parseAttributes(this, element, fallbackAttr);
        Template[] templateArray = this.parseTemplates(element.getFirstChild(), false);
        return new FallbackTemplate(templateArray, element);
    }

    public SortKey parseSortElement(Element element) throws XSLTParserException {
        Object[] objectArray = AttrDef.parseAttributes(this, element, sortAttr);
        return new SortKey((Expression)objectArray[0], (Expression)objectArray[1], (Expression)objectArray[2], (Expression)objectArray[3], (Expression)objectArray[4]);
    }

    public NamespaceName[] parseElementPrefixes(Node node, String string) throws XSLTParserException {
        Object object;
        ArrayList<NamespaceName> arrayList = new ArrayList<NamespaceName>();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            NamespaceName namespaceName;
            object = stringTokenizer.nextToken();
            if (((String)object).equals("#default")) {
                object = "";
            }
            if ((namespaceName = this.getNamespaceName((String)object)) != null && !namespaceName.isEmpty()) {
                arrayList.add(namespaceName);
                continue;
            }
            if (((String)object).length() == 0) {
                object = "#default";
            }
            this.reportError(node, "spe17", (String)object);
        }
        object = new NamespaceName[arrayList.size()];
        arrayList.toArray((T[])object);
        return object;
    }

    public Collection parseQNames(Node node, String string) throws XSLTParserException {
        TreeSet<ExpandedQName> treeSet = new TreeSet<ExpandedQName>();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!XMLUtil.isQName(string2)) {
                this.reportError(node, "spe18", string2);
                continue;
            }
            ExpandedQName expandedQName = new ExpandedQName(string2, this.getNamespaceContext());
            treeSet.add(expandedQName);
        }
        return treeSet;
    }

    public void reportError(String string) throws XSLTParserException {
        try {
            this.stylesheet.getErrorHandler().error(string);
        }
        catch (XSLException xSLException) {
            throw new XSLTParserException(xSLException.getMessage());
        }
    }

    public void reportError(Element element, Node node, String string, Object[] objectArray) throws XSLTParserException {
        StringBuffer stringBuffer = this.buildErrorPrologue(null, element, node);
        stringBuffer = this.buildErrorPrologue(stringBuffer, node, null);
        stringBuffer.append(XSLTParserException.constructMessage(string, objectArray));
        this.reportError(stringBuffer.toString());
    }

    public void reportError(Element element, Node node, String string, String string2) throws XSLTParserException {
        this.reportError(element, node, string, new String[]{string2});
    }

    public void reportError(Element element, Node node, String string) throws XSLTParserException {
        this.reportError(element, node, string, (Object[])null);
    }

    public void reportError(Node node, String string, Object[] objectArray) throws XSLTParserException {
        StringBuffer stringBuffer = this.buildErrorPrologue(null, node, node);
        stringBuffer.append(XSLTParserException.constructMessage(string, objectArray));
        this.reportError(stringBuffer.toString());
    }

    public void reportError(Node node, String string, String string2) throws XSLTParserException {
        this.reportError(node, string, new String[]{string2});
    }

    public void reportError(Node node, String string) throws XSLTParserException {
        this.reportError(node, string, (Object[])null);
    }

    public void reportInvalidAttributeValue(Element element, String string, boolean bl, String string2) throws XSLTParserException {
        if (this.forwardsCompatibleMode && !bl) {
            return;
        }
        this.reportError((Node)element, "spe19", new String[]{string, string2});
    }

    public Expression reportAttributeExpressionError(Element element, String string, XPathParserException xPathParserException) throws XSLTParserException {
        StringBuffer stringBuffer = this.buildErrorPrologue(null, element, element);
        stringBuffer.append(XSLTParserException.constructMessage("spe20", new String[]{string, xPathParserException.getLocalizedMessage()}));
        if (this.forwardsCompatibleMode) {
            return new BadExpression(stringBuffer.toString());
        }
        this.reportError(stringBuffer.toString());
        return null;
    }

    public StringBuffer buildErrorPrologue(StringBuffer stringBuffer, Node node, Node node2) {
        Object object;
        if (stringBuffer == null) {
            stringBuffer = new StringBuffer();
        }
        if (node == null) {
            return stringBuffer;
        }
        if (node2 != null) {
            object = node2 instanceof NodeImpl ? ((NodeImpl)node2).getBaseURI() : ((URL)this.baseURIStack.peek()).toString();
            stringBuffer.append((String)object);
            if (node2 instanceof NodeImpl && ((NodeImpl)node2).getLineNumber() != -1) {
                stringBuffer.append(" (");
                stringBuffer.append(((NodeImpl)node2).getLineNumber());
                stringBuffer.append(')');
            }
            stringBuffer.append(": ");
        }
        object = node;
        if (node.getNodeType() != 1) {
            object = node.getParentNode();
        }
        if (object != null && object.getNodeType() == 1) {
            stringBuffer.append('<');
            stringBuffer.append(((Element)object).getTagName());
            stringBuffer.append(">: ");
        }
        if (node != object && node.getNodeType() == 2) {
            stringBuffer.append('\'');
            stringBuffer.append(node.getNodeName());
            stringBuffer.append("': ");
        }
        return stringBuffer;
    }

    public void reportWarning(Node node, String string) {
        StringBuffer stringBuffer = this.buildErrorPrologue(null, node, node);
        stringBuffer.append(string);
        this.stylesheet.getErrorHandler().warning(stringBuffer.toString());
    }
}

