/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.pattern;

import com.novell.xml.util.ExpandedQName;
import com.novell.xml.xpath.ArgumentList;
import com.novell.xml.xpath.AxisNameToken;
import com.novell.xml.xpath.FunctionCall;
import com.novell.xml.xpath.FunctionLibrary;
import com.novell.xml.xpath.FunctionNameToken;
import com.novell.xml.xpath.NamespaceContext;
import com.novell.xml.xpath.StringValue;
import com.novell.xml.xpath.Token;
import com.novell.xml.xpath.VariableBindings;
import com.novell.xml.xpath.XPathParserException;
import com.novell.xsl.parser.ExpressionParser;
import com.novell.xsl.parser.StylesheetParser;
import com.novell.xsl.pattern.AbsolutePathPattern;
import com.novell.xsl.pattern.IdKeyPattern;
import com.novell.xsl.pattern.NodeTestPattern;
import com.novell.xsl.pattern.OrPattern;
import com.novell.xsl.pattern.Pattern;
import com.novell.xsl.pattern.PatternParserException;
import com.novell.xsl.pattern.RelativePathPattern;
import com.novell.xsl.pattern.StepPattern;

public class Parser
extends ExpressionParser {
    public Parser(StylesheetParser stylesheetParser, VariableBindings variableBindings, FunctionLibrary functionLibrary, NamespaceContext namespaceContext) {
        super(stylesheetParser, variableBindings, functionLibrary, namespaceContext);
    }

    public Pattern parsePattern(String string, boolean bl) throws XPathParserException {
        Object object;
        this.tokenize(string);
        Token[] tokenArray = this.getTokens();
        int n = 0;
        while (n < tokenArray.length) {
            if (bl && tokenArray[n].getType() == 17) {
                throw new PatternParserException(PatternParserException.NO_VARIABLE_REFS);
            }
            if (tokenArray[n].getType() == 13 && ((FunctionNameToken)(object = (FunctionNameToken)tokenArray[n])).getLocalPart().equals("current") && ((FunctionNameToken)object).getPrefix().length() == 0) {
                throw new PatternParserException(PatternParserException.NO_CURRENT_FUNC);
            }
            ++n;
        }
        object = this.parsePattern();
        if (this.peekToken().getType() != 0) {
            throw new PatternParserException("pe5");
        }
        return object;
    }

    protected Pattern parsePattern() throws XPathParserException {
        Token token;
        Pattern pattern = this.parseLocationPathPattern();
        while (this.getOperator(token = this.peekToken()) == 16) {
            this.nextToken();
            pattern = new OrPattern(pattern, this.parseLocationPathPattern());
        }
        return pattern;
    }

    protected Pattern parseLocationPathPattern() throws XPathParserException {
        Token token = this.peekToken();
        int n = this.getOperator(token);
        if (n == 5) {
            this.nextToken();
            token = this.peekToken();
            n = this.getOperator(token);
            if (token.getType() != 0 && n != 16) {
                return new AbsolutePathPattern(this.parseRelativePathPattern());
            }
            return new AbsolutePathPattern();
        }
        if (n == 6) {
            this.nextToken();
            return this.parseRelativePathPattern();
        }
        if (token.getType() == 13) {
            return this.parseIdKeyPattern();
        }
        return this.parseRelativePathPattern();
    }

    protected Pattern parseIdKeyPattern() throws XPathParserException {
        ExpandedQName expandedQName;
        Token token = this.peekToken();
        this.nextToken();
        String string = ((FunctionNameToken)token).getPrefix();
        String string2 = ((FunctionNameToken)token).getLocalPart();
        if (!string.equals("") || !string2.equals("id") && !string2.equals("key")) {
            throw new PatternParserException(PatternParserException.BAD_ID_KEY);
        }
        ArgumentList argumentList = this.parseArgumentList();
        if (string2.equals("id")) {
            if (argumentList.count() != 1 || !(argumentList.getArgument(0) instanceof StringValue)) {
                throw new PatternParserException(PatternParserException.BAD_ID_KEY);
            }
            expandedQName = new ExpandedQName("", "id", "");
        } else {
            if (argumentList.count() != 2 || !(argumentList.getArgument(0) instanceof StringValue) || !(argumentList.getArgument(1) instanceof StringValue)) {
                throw new PatternParserException(PatternParserException.BAD_ID_KEY);
            }
            expandedQName = new ExpandedQName("", "key", "");
        }
        FunctionCall functionCall = new FunctionCall(this.getLibrary().getFunction(expandedQName), argumentList);
        token = this.peekToken();
        int n = this.getOperator(token);
        if (n == 5 || n == 6) {
            this.nextToken();
            return new IdKeyPattern(functionCall, n, this.parseRelativePathPattern());
        }
        return new IdKeyPattern(functionCall);
    }

    protected RelativePathPattern parseRelativePathPattern() throws XPathParserException {
        RelativePathPattern relativePathPattern = new RelativePathPattern(this.parseStepPattern());
        while (true) {
            Token token;
            int n;
            if ((n = this.getOperator(token = this.peekToken())) == 5) {
                this.nextToken();
                relativePathPattern = new RelativePathPattern(relativePathPattern, 5, this.parseStepPattern());
                continue;
            }
            if (n != 6) break;
            this.nextToken();
            relativePathPattern = new RelativePathPattern(relativePathPattern, 6, this.parseStepPattern());
        }
        return relativePathPattern;
    }

    protected StepPattern parseStepPattern() throws XPathParserException {
        StepPattern stepPattern = new StepPattern(this.parseAxisSpecifier());
        Token token = this.peekToken();
        while (token.getType() == 3) {
            this.nextToken();
            stepPattern = new StepPattern(stepPattern, this.parsePredicate());
            token = this.peekToken();
        }
        return stepPattern;
    }

    protected NodeTestPattern parseAxisSpecifier() throws XPathParserException {
        Token token = this.peekToken();
        int n = token.getType();
        if (n == 7) {
            this.nextToken();
            return new NodeTestPattern(this.parseNodeTest(), 2);
        }
        if (n == 14) {
            this.nextToken();
            int n2 = ((AxisNameToken)token).getId();
            if (n2 != 4 && n2 != 3) {
                throw new PatternParserException(PatternParserException.BAD_AXIS);
            }
            token = this.peekToken();
            if (token.getType() != 9) {
                throw new PatternParserException("pe4", "::");
            }
            this.nextToken();
            if (n2 == 3) {
                return new NodeTestPattern(this.parseNodeTest(), 2);
            }
        }
        return new NodeTestPattern(this.parseNodeTest());
    }
}

