/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.pattern;

import com.novell.xml.xpath.ContextListMark;
import com.novell.xml.xpath.ContextNodeList;
import com.novell.xml.xpath.ExpressionContext;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xsl.pattern.Pattern;
import org.w3c.dom.Node;

class SiblingList
implements ContextNodeList {
    private Node contextNode;
    private Pattern pattern;
    private ExpressionContext context;
    private Node sibling = null;
    private int position = 0;
    private int count = -1;

    public SiblingList(Node node, Pattern pattern, ExpressionContext expressionContext) {
        this.contextNode = node;
        this.pattern = pattern;
        this.context = expressionContext;
    }

    public Node first() throws XPathEvaluationException {
        Node node = this.contextNode.getParentNode();
        this.sibling = node != null ? node.getFirstChild() : null;
        while (this.sibling != null && !this.pattern.match(this.sibling, this.context)) {
            this.sibling = this.sibling.getNextSibling();
        }
        return this.incPosition(this.sibling);
    }

    public Node next() throws XPathEvaluationException {
        if (this.sibling != null) {
            do {
                this.sibling = this.sibling.getNextSibling();
            } while (this.sibling != null && !this.pattern.match(this.sibling, this.context));
        }
        return this.incPosition(this.sibling);
    }

    public int count() throws XPathEvaluationException {
        if (this.count == -1) {
            ContextListMark contextListMark = this.getMark();
            if (this.position() < 1) {
                this.first();
            }
            while (this.next() != null) {
            }
            int n = this.position();
            this.returnToMark(contextListMark);
            this.count = n;
        }
        return this.count;
    }

    public int position() {
        return this.position;
    }

    public int order() {
        return 1;
    }

    public ContextListMark getMark() {
        return new Mark(this);
    }

    public Node returnToMark(ContextListMark contextListMark) {
        ((Mark)contextListMark).restoreState(this);
        return this.sibling;
    }

    private Node incPosition(Node node) {
        if (node != null) {
            ++this.position;
        }
        return node;
    }

    private class Mark
    implements ContextListMark {
        private Node sibling = null;
        private int position = 0;
        private int count = -1;

        public Mark(SiblingList siblingList2) {
            this.sibling = siblingList2.sibling;
            this.position = siblingList2.position;
            this.count = siblingList2.count;
        }

        public void restoreState(SiblingList siblingList) {
            siblingList.sibling = this.sibling;
            siblingList.position = this.position;
            siblingList.count = this.count;
        }
    }
}

