/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.process;

import com.novell.xml.util.ExpandedQName;
import com.novell.xsl.XSLException;
import com.novell.xsl.process.AttributeSetCollection;
import com.novell.xsl.process.AttributeTemplate;
import com.novell.xsl.process.ProcessingEnv;
import com.novell.xsl.process.Template;
import com.novell.xsl.result.ResultHandler;
import com.novell.xsl.util.Util;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Node;

public class AttributeSet
implements Template {
    private ExpandedQName name;
    private AttributeSetCollection attributeSets;
    private List attributes;
    private int importance;
    private Node nsContext;
    private int nesting = 0;

    public AttributeSet(ExpandedQName expandedQName, Collection collection, Template[] templateArray, int n, Node node) {
        this.name = expandedQName;
        this.attributeSets = collection != null && collection.size() != 0 ? new AttributeSetCollection(collection) : null;
        this.importance = n;
        this.nsContext = node;
        this.attributes = new ArrayList();
        int n2 = 0;
        while (n2 < templateArray.length) {
            this.attributes.add(templateArray[n2]);
            ++n2;
        }
    }

    public ExpandedQName getName() {
        return this.name;
    }

    public void merge(AttributeSet attributeSet) throws XSLException {
        Iterator iterator = attributeSet.attributes.iterator();
        while (iterator.hasNext()) {
            this.attributes.add(iterator.next());
        }
        Collections.sort(this.attributes, new AttributeTemplateComparator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void instantiate(ProcessingEnv processingEnv, Node node, ResultHandler resultHandler) throws XSLException {
        if (this.nesting > 0) {
            processingEnv.reportError(this.getNamespaceContext(), "pe3", this.name.getQName());
            return;
        }
        ++this.nesting;
        processingEnv.getContext().pushState();
        try {
            processingEnv.pushParameters();
            try {
                if (this.attributeSets != null) {
                    this.attributeSets.instantiate(processingEnv, node, resultHandler);
                }
                Iterator iterator = this.attributes.iterator();
                while (iterator.hasNext()) {
                    ((AttributeTemplate)iterator.next()).instantiate(processingEnv, node, resultHandler);
                }
                Object var6_5 = null;
                processingEnv.popParameters();
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                processingEnv.popParameters();
                throw throwable;
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            processingEnv.getContext().popState();
            --this.nesting;
            throw throwable;
        }
        processingEnv.getContext().popState();
        --this.nesting;
        {
        }
    }

    public Node getNamespaceContext() {
        return this.nsContext;
    }

    public void dump(PrintWriter printWriter, int n) {
        Util.indent(printWriter, n);
        printWriter.println("attribute-set");
        Util.indent(printWriter, n + 1);
        printWriter.println("name: " + this.name.getQName());
        Util.indent(printWriter, n + 1);
        printWriter.println("attributes: ");
        Iterator iterator = this.attributes.iterator();
        while (iterator.hasNext()) {
            ((AttributeTemplate)iterator.next()).dump(printWriter, n + 2);
        }
    }

    static class AttributeTemplateComparator
    implements Comparator {
        AttributeTemplateComparator() {
        }

        public int compare(Object object, Object object2) {
            AttributeTemplate attributeTemplate = (AttributeTemplate)object;
            AttributeTemplate attributeTemplate2 = (AttributeTemplate)object2;
            if (attributeTemplate.getImportance() != attributeTemplate2.getImportance()) {
                return attributeTemplate.getImportance() - attributeTemplate2.getImportance();
            }
            return attributeTemplate.getPosition() - attributeTemplate2.getPosition();
        }
    }
}

