/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.process;

import com.novell.xsl.XSLException;
import com.novell.xsl.debug.Trace;
import com.novell.xsl.process.ProcessingEnv;
import com.novell.xsl.process.Template;
import com.novell.xsl.process.TemplateCollection;
import com.novell.xsl.result.IllegalNodeException;
import com.novell.xsl.result.ResultException;
import com.novell.xsl.result.ResultHandler;
import com.novell.xsl.result.TextResultHandler;
import com.novell.xsl.util.Util;
import java.io.PrintWriter;
import org.w3c.dom.Node;

public class CommentTemplate
extends TemplateCollection {
    public CommentTemplate(Template[] templateArray, Node node) {
        super(templateArray, node);
    }

    public void instantiate(ProcessingEnv processingEnv, Node node, ResultHandler resultHandler) throws XSLException {
        Trace.traceTemplate("comment");
        TextResultHandler textResultHandler = new TextResultHandler();
        this.instantiateTemplates(processingEnv, node, textResultHandler);
        String string = textResultHandler.getText();
        int n = string.lastIndexOf("--");
        if (n > 0) {
            processingEnv.reportError(this.getNamespaceContext(), "pe10");
            StringBuffer stringBuffer = new StringBuffer(string);
            do {
                stringBuffer.insert(n + 1, ' ');
            } while ((n = string.lastIndexOf("--", n - 1)) > 0);
            string = stringBuffer.toString();
        }
        if (string.endsWith("-")) {
            processingEnv.reportError(this.getNamespaceContext(), "pe10");
            string = string + " ";
        }
        try {
            resultHandler.comment(string);
        }
        catch (IllegalNodeException illegalNodeException) {
            processingEnv.reportError(this.getNamespaceContext(), "pe7");
        }
        catch (ResultException resultException) {
            processingEnv.reportError(this.getNamespaceContext(), "pe8", resultException.getMessage());
        }
    }

    public void dump(PrintWriter printWriter, int n) {
        Util.indent(printWriter, n);
        printWriter.println("comment");
        super.dump(printWriter, n);
    }
}

