/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.process;

import com.novell.xml.util.XMLUtil;
import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xsl.XSLException;
import com.novell.xsl.debug.Trace;
import com.novell.xsl.process.ProcessingEnv;
import com.novell.xsl.process.Template;
import com.novell.xsl.process.TemplateCollection;
import com.novell.xsl.result.IllegalNameException;
import com.novell.xsl.result.IllegalNodeException;
import com.novell.xsl.result.ResultException;
import com.novell.xsl.result.ResultHandler;
import com.novell.xsl.result.TextResultHandler;
import com.novell.xsl.util.Util;
import java.io.PrintWriter;
import org.w3c.dom.Node;

public class PITemplate
extends TemplateCollection {
    private final Expression name;

    public PITemplate(Expression expression, Template[] templateArray, Node node) {
        super(templateArray, node);
        this.name = expression;
    }

    public void instantiate(ProcessingEnv processingEnv, Node node, ResultHandler resultHandler) throws XSLException {
        String string;
        Trace.traceTemplate("processing-instruction");
        try {
            string = processingEnv.getContext().evaluate(node, this.name).getStringValue();
        }
        catch (XPathEvaluationException xPathEvaluationException) {
            processingEnv.reportError(this.getNamespaceContext(), "pe2", xPathEvaluationException.getMessage());
            return;
        }
        if (!XMLUtil.isNCName(string) || !XMLUtil.isPITarget(string)) {
            processingEnv.reportError(this.getNamespaceContext(), "pe5", string);
            return;
        }
        TextResultHandler textResultHandler = new TextResultHandler();
        this.instantiateTemplates(processingEnv, node, textResultHandler);
        String string2 = textResultHandler.getText();
        int n = string2.lastIndexOf("?>");
        if (n > 0) {
            processingEnv.reportError(this.getNamespaceContext(), "pe10");
            StringBuffer stringBuffer = new StringBuffer(string2);
            do {
                stringBuffer.insert(n + 1, ' ');
            } while ((n = string2.lastIndexOf("?>", n - 2)) > 0);
            string2 = stringBuffer.toString();
        }
        try {
            resultHandler.processingInstruction(string, string2);
        }
        catch (IllegalNameException illegalNameException) {
            processingEnv.reportError(this.getNamespaceContext(), "pe5", string);
        }
        catch (IllegalNodeException illegalNodeException) {
            processingEnv.reportError(this.getNamespaceContext(), "pe7");
        }
        catch (ResultException resultException) {
            processingEnv.reportError(this.getNamespaceContext(), "pe8", resultException.getMessage());
        }
    }

    public void dump(PrintWriter printWriter, int n) {
        Util.indent(printWriter, n);
        printWriter.println("processing-instruction");
        Util.indent(printWriter, n + 1);
        printWriter.println("name");
        this.name.dump(printWriter, n + 2);
        super.dump(printWriter, n);
    }
}

