/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.process;

import com.novell.xml.dom.DOMUtil;
import com.novell.xml.dom.NodeImpl;
import com.novell.xml.util.ExpandedQName;
import com.novell.xml.util.NamespaceName;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xsl.ErrorHandler;
import com.novell.xsl.MessageHandler;
import com.novell.xsl.Stylesheet;
import com.novell.xsl.XSLException;
import com.novell.xsl.debug.Trace;
import com.novell.xsl.process.Context;
import com.novell.xsl.process.Mode;
import com.novell.xsl.process.ProcessException;
import com.novell.xsl.process.Rule;
import com.novell.xsl.process.TemplateRule;
import com.novell.xsl.process.VariableTemplate;
import com.novell.xsl.result.ResultException;
import com.novell.xsl.result.ResultHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ProcessingEnv {
    private static final int INITIAL_NODE_MODE_SIZE = 8;
    private Stylesheet stylesheet;
    private Context context;
    private ErrorHandler errorHandler;
    private MessageHandler messageHandler;
    private Node[] nodeStack = new Node[8];
    private Mode[] modeStack = new Mode[8];
    private int[] importanceStack = new int[8];
    private ResultHandler topLevelResultHandler;
    private int stackSize = 0;
    private Map parameters = new HashMap();
    private Stack parameterStack = new Stack();
    private List variables = null;
    private Stack variableStack = new Stack();
    private Stack currentRuleStack = new Stack();
    private Document nodeFactory;

    public ProcessingEnv(Stylesheet stylesheet, Context context, Document document, ErrorHandler errorHandler, MessageHandler messageHandler, ResultHandler resultHandler) {
        this.stylesheet = stylesheet;
        this.context = context;
        this.nodeFactory = document;
        this.errorHandler = errorHandler;
        this.messageHandler = messageHandler;
        this.topLevelResultHandler = resultHandler;
    }

    public ProcessingEnv(ProcessingEnv processingEnv) {
        this(processingEnv.stylesheet, new Context(processingEnv.context), processingEnv.nodeFactory, processingEnv.errorHandler, processingEnv.messageHandler, processingEnv.topLevelResultHandler);
        this.nodeStack = (Node[])processingEnv.nodeStack.clone();
        this.modeStack = (Mode[])processingEnv.modeStack.clone();
        this.importanceStack = (int[])processingEnv.importanceStack.clone();
        this.stackSize = processingEnv.stackSize;
        this.parameters = new HashMap(processingEnv.parameters);
        this.parameterStack = (Stack)processingEnv.parameterStack.clone();
        this.currentRuleStack = (Stack)processingEnv.currentRuleStack.clone();
        if (processingEnv.variables != null) {
            this.variables = new ArrayList(processingEnv.variables);
        }
        this.variableStack = (Stack)processingEnv.variableStack.clone();
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public MessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    public Context getContext() {
        return this.context;
    }

    public void process(Node node, Mode mode, ResultHandler resultHandler) throws XSLException {
        Trace.traceSource(node, mode);
        Rule rule = this.stylesheet.getTemplateRules().findMatchingRule(node, this, mode);
        if (rule != null) {
            this.processWithRule(node, mode, resultHandler, rule);
        }
    }

    public void processWithImports(Node node, ResultHandler resultHandler) throws XSLException {
        Trace.traceSource(node, this.getCurrentRule().getMode());
        Rule rule = this.stylesheet.getTemplateRules().findMatchingImportedRule(node, this, this.getCurrentRule());
        if (rule != null) {
            this.processWithRule(node, this.getCurrentRule().getMode(), resultHandler, rule);
        }
    }

    public void processWithRule(Node node, Mode mode, ResultHandler resultHandler, Rule rule) throws XSLException {
        int n = rule.getImportance();
        int n2 = this.stackSize - 1;
        while (n2 >= 0) {
            if (this.nodeStack[n2] == node && this.modeStack[n2] == mode && this.importanceStack[n2] == n) {
                this.reportError(ProcessException.constructMessage("pe12", new String[]{mode == Mode.DEFAULT_MODE ? "" : mode.getName().getQName(), DOMUtil.describeNode(node)}));
                return;
            }
            --n2;
        }
        if (this.stackSize == this.nodeStack.length) {
            Node[] nodeArray = new Node[this.stackSize * 2];
            Mode[] modeArray = new Mode[this.stackSize * 2];
            int[] nArray = new int[this.stackSize * 2];
            System.arraycopy(this.nodeStack, 0, nodeArray, 0, this.stackSize);
            System.arraycopy(this.modeStack, 0, modeArray, 0, this.stackSize);
            System.arraycopy(this.importanceStack, 0, nArray, 0, this.stackSize);
            this.nodeStack = nodeArray;
            this.modeStack = modeArray;
            this.importanceStack = nArray;
        }
        this.nodeStack[this.stackSize] = node;
        this.modeStack[this.stackSize] = mode;
        this.importanceStack[this.stackSize] = n;
        ++this.stackSize;
        this.pushCurrentRule(rule);
        ((TemplateRule)rule).instantiate(this, node, mode, resultHandler);
        this.popCurrentRule();
        --this.stackSize;
    }

    public Stylesheet getStylesheet() {
        return this.stylesheet;
    }

    public void bindParameter(ExpandedQName expandedQName, ExpressionValue expressionValue) {
        this.parameters.remove(expandedQName);
        this.parameters.put(expandedQName, expressionValue);
    }

    public ExpressionValue getParameter(ExpandedQName expandedQName) {
        return (ExpressionValue)this.parameters.get(expandedQName);
    }

    public void clearParameters() {
        this.parameters.clear();
    }

    public void pushParameters() {
        this.parameterStack.push(new HashMap(this.parameters));
        this.clearParameters();
    }

    public void popParameters() {
        this.parameters = (Map)this.parameterStack.pop();
    }

    public void setVariable(VariableTemplate variableTemplate) {
        if (this.variables == null) {
            this.variables = new ArrayList();
        }
        this.variables.add(new LocalVariable(variableTemplate));
    }

    public void pushVariables() {
        this.variableStack.push(this.variables);
        this.variables = null;
    }

    public void popVariables() {
        this.variables = (List)this.variableStack.pop();
        if (this.variables != null) {
            Iterator iterator = this.variables.iterator();
            while (iterator.hasNext()) {
                ((LocalVariable)iterator.next()).restore();
            }
        }
    }

    public ResultHandler getTopLevelResultHandler() {
        return this.topLevelResultHandler;
    }

    public Rule getCurrentRule() {
        return this.currentRuleStack.empty() ? null : (Rule)this.currentRuleStack.peek();
    }

    public void pushCurrentRule(Rule rule) {
        this.currentRuleStack.push(rule);
    }

    public Rule popCurrentRule() {
        return (Rule)this.currentRuleStack.pop();
    }

    public Document getNodeFactory() {
        return this.nodeFactory;
    }

    public void setNodeFactory(Document document) {
        this.nodeFactory = document;
    }

    public static void resultNamespace(ResultHandler resultHandler, String string, NamespaceName namespaceName) throws ResultException {
        if (!namespaceName.equals(NamespaceName.XML_NAMESPACE)) {
            resultHandler.namespace(string, namespaceName);
        }
    }

    public void reportError(String string) throws XSLException {
        try {
            this.errorHandler.error(string);
        }
        catch (XSLException xSLException) {
            throw new ProcessException(xSLException.getMessage());
        }
    }

    public void reportError(Node node, String string) throws XSLException {
        this.reportError(node, string, (Object[])null);
    }

    public void reportError(Node node, String string, String string2) throws XSLException {
        this.reportError(node, string, new String[]{string2});
    }

    public void reportError(Node node, String string, String string2, String string3) throws XSLException {
        this.reportError(node, string, new String[]{string2, string3});
    }

    public void reportError(Node node, String string, Object[] objectArray) throws XSLException {
        StringBuffer stringBuffer = ProcessingEnv.buildMsgPrologue(null, node);
        String string2 = ProcessException.constructMessage(string, objectArray);
        stringBuffer.append(string2);
        this.reportError(stringBuffer.toString());
    }

    public void reportWarning(Node node, String string, Object[] objectArray) {
        StringBuffer stringBuffer = ProcessingEnv.buildMsgPrologue(null, node);
        String string2 = ProcessException.constructMessage(string, objectArray);
        stringBuffer.append(string2);
        this.errorHandler.warning(stringBuffer.toString());
    }

    public static StringBuffer buildMsgPrologue(StringBuffer stringBuffer, Node node) {
        Object object;
        if (stringBuffer == null) {
            stringBuffer = new StringBuffer();
        }
        if (node == null) {
            return stringBuffer;
        }
        if (node instanceof NodeImpl) {
            object = ((NodeImpl)node).getBaseURI();
            stringBuffer.append((String)object);
            if (((NodeImpl)node).getLineNumber() != -1) {
                stringBuffer.append(" (");
                stringBuffer.append(((NodeImpl)node).getLineNumber());
                stringBuffer.append(')');
            }
            stringBuffer.append(": ");
        }
        object = node;
        if (node.getNodeType() != 1) {
            object = node.getParentNode();
        }
        if (object != null && object.getNodeType() == 1) {
            stringBuffer.append('<');
            stringBuffer.append(((Element)object).getTagName());
            stringBuffer.append(">: ");
        }
        return stringBuffer;
    }

    static class LocalVariable {
        private VariableTemplate variable;
        private ExpressionValue value;

        LocalVariable(VariableTemplate variableTemplate) {
            this.variable = variableTemplate;
            this.value = variableTemplate.getCurrentValue();
        }

        void restore() {
            this.variable.setCurrentValue(this.value);
        }
    }
}

