/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.process;

import com.novell.xsl.process.ElementMatch;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class StripList {
    private List matchList = new ArrayList();
    private ElementMatch[] matchArray = null;

    public void add(ElementMatch elementMatch) {
        this.unoptimize();
        this.matchList.add(elementMatch);
    }

    public void clear() {
        if (this.matchArray != null || this.matchList.size() > 0) {
            this.matchList = new ArrayList();
            this.matchArray = null;
        }
    }

    public int size() {
        if (this.matchArray != null) {
            return this.matchArray.length;
        }
        return this.matchList.size();
    }

    public ElementMatch[] getList() {
        if (this.matchArray == null) {
            this.optimize();
        }
        return this.matchArray;
    }

    public boolean checkStrip(Node node) {
        if (node != null && node.getNodeType() == 1) {
            ElementMatch[] elementMatchArray = this.getList();
            int n = 0;
            while (n < elementMatchArray.length) {
                if (elementMatchArray[n].matches((Element)node)) {
                    return elementMatchArray[n].isStrip();
                }
                ++n;
            }
        }
        return false;
    }

    public void dump(PrintWriter printWriter, int n) {
        ArrayList<ElementMatch> arrayList = this.matchList;
        if (arrayList == null) {
            arrayList = new ArrayList<ElementMatch>(Arrays.asList(this.matchArray));
        }
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                int n = ((ElementMatch)object).getNumber();
                int n2 = ((ElementMatch)object2).getNumber();
                return n - n2;
            }
        });
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ElementMatch elementMatch = (ElementMatch)iterator.next();
            elementMatch.dump(printWriter, n);
        }
    }

    public void optimize() {
        if (this.matchArray == null) {
            Collections.sort(this.matchList);
            this.matchArray = new ElementMatch[this.matchList.size()];
            this.matchList.toArray(this.matchArray);
            this.matchList = null;
        }
    }

    private void unoptimize() {
        if (this.matchList == null) {
            this.matchList = new ArrayList<ElementMatch>(Arrays.asList(this.matchArray));
            this.matchArray = null;
        }
    }
}

