/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.process;

import com.novell.xml.util.ExpandedQName;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xsl.XSLException;
import com.novell.xsl.pattern.Pattern;
import com.novell.xsl.process.Mode;
import com.novell.xsl.process.Priority;
import com.novell.xsl.process.ProcessingEnv;
import com.novell.xsl.process.Rule;
import com.novell.xsl.process.Template;
import com.novell.xsl.process.VariableTemplate;
import com.novell.xsl.result.ResultHandler;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Iterator;
import org.w3c.dom.Node;

public class TemplateRule
extends Rule {
    private Template[] templates;
    private Collection variables;
    protected RecursionCounter recursionLevel;

    public TemplateRule(Pattern pattern, ExpandedQName expandedQName, Template[] templateArray, Collection collection, Mode mode, int n, Priority priority, int n2, Node node) {
        super(pattern, expandedQName, mode, n, priority, n2, node);
        this.recursionLevel = new RecursionCounter();
        this.templates = templateArray;
        this.variables = collection;
    }

    protected TemplateRule(TemplateRule templateRule, Pattern pattern) {
        super(templateRule, pattern);
        this.recursionLevel = templateRule.recursionLevel;
        this.templates = templateRule.templates;
        this.variables = templateRule.variables;
    }

    public Template[] getTemplates() {
        return this.templates;
    }

    public Rule cloneForUnion(Pattern pattern) {
        return new TemplateRule(this, pattern);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void instantiate(ProcessingEnv processingEnv, Node node, Mode mode, ResultHandler resultHandler) throws XSLException {
        if (this.templates != null) {
            processingEnv.getContext().pushState();
            ExpressionValue[] expressionValueArray = this.pushVariables();
            this.recursionLevel.increment();
            try {
                int n = 0;
                while (n < this.templates.length) {
                    processingEnv.getContext().setNamespaceContext(this.templates[n].getNamespaceContext());
                    this.templates[n].instantiate(processingEnv, node, resultHandler);
                    ++n;
                }
                Object var8_7 = null;
                this.recursionLevel.decrement();
                this.popVariables(expressionValueArray);
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                this.recursionLevel.decrement();
                this.popVariables(expressionValueArray);
                processingEnv.getContext().popState();
                throw throwable;
            }
            processingEnv.getContext().popState();
            {
            }
        }
    }

    protected ExpressionValue[] pushVariables() {
        if (this.recursionLevel.getLevel() > 0 && this.variables != null) {
            ExpressionValue[] expressionValueArray = new ExpressionValue[this.variables.size()];
            Iterator iterator = this.variables.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                expressionValueArray[n++] = ((VariableTemplate)iterator.next()).getCurrentValue();
            }
            return expressionValueArray;
        }
        return null;
    }

    protected void popVariables(ExpressionValue[] expressionValueArray) {
        if (expressionValueArray != null) {
            Iterator iterator = this.variables.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                ((VariableTemplate)iterator.next()).setCurrentValue(expressionValueArray[n++]);
            }
        }
    }

    public void dump(PrintWriter printWriter, int n) {
        Rule.indent(printWriter, n);
        printWriter.println("(" + this.getNumber() + ") mode=" + this.getMode().getName() + " importance=" + this.getImportance() + " priority=" + this.getPriority());
        printWriter.println(n + "    match pattern");
        this.getPattern().dump(printWriter, n + 1);
        printWriter.println(n + "    templates");
        if (this.templates != null) {
            int n2 = 0;
            while (n2 < this.templates.length) {
                this.templates[n2].dump(printWriter, n + 1);
                ++n2;
            }
        }
    }

    protected static class RecursionCounter {
        private int level = 0;

        protected RecursionCounter() {
        }

        void increment() {
            ++this.level;
        }

        void decrement() {
            --this.level;
        }

        int getLevel() {
            return this.level;
        }
    }
}

