/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.process;

import com.novell.xml.util.ExpandedQName;
import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.ExpressionContext;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.StringValue;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xml.xpath.XPathResetRegistrar;
import com.novell.xml.xpath.XPathUtil;
import com.novell.xsl.XSLException;
import com.novell.xsl.debug.Trace;
import com.novell.xsl.process.ProcessingEnv;
import com.novell.xsl.process.ResultTreeFragment;
import com.novell.xsl.process.Template;
import com.novell.xsl.process.TemplateCollection;
import com.novell.xsl.result.FragmentHandler;
import com.novell.xsl.result.ResultHandler;
import com.novell.xsl.util.Util;
import java.io.PrintWriter;
import org.w3c.dom.Node;

public class VariableTemplate
extends TemplateCollection
implements Expression {
    private ExpandedQName name;
    private Expression select;
    private boolean isParam;
    protected ExpressionValue currentValue = null;
    private int level = 0;
    private static Class returnType = null;

    public VariableTemplate(ExpandedQName expandedQName, Expression expression, Template[] templateArray, Node node) {
        this(expandedQName, expression, templateArray, false, node);
    }

    public VariableTemplate(ExpandedQName expandedQName, Expression expression, Template[] templateArray, boolean bl, Node node) {
        super(templateArray, node);
        this.name = expandedQName;
        this.select = expression;
        this.isParam = bl;
    }

    public ExpandedQName getName() {
        return this.name;
    }

    public Expression getSelect() {
        return this.select;
    }

    public boolean isParam() {
        return this.isParam;
    }

    public ExpressionValue getCurrentValue() {
        return this.currentValue;
    }

    public void setCurrentValue(ExpressionValue expressionValue) {
        this.currentValue = expressionValue;
    }

    public void instantiate(ProcessingEnv processingEnv, Node node, ResultHandler resultHandler) throws XSLException {
        Trace.traceTemplate(this.isParam() ? "param" : "variable");
        try {
            if (this.isParam) {
                this.currentValue = processingEnv.getParameter(this.name);
                if (this.currentValue != null) {
                    return;
                }
            }
            if (this.select != null) {
                this.currentValue = processingEnv.getContext().evaluate(node, this.select);
                Trace.traceSelect(this.select, this.currentValue);
            } else if (this.getTemplates().length == 0) {
                this.currentValue = new StringValue();
            } else {
                FragmentHandler fragmentHandler = new FragmentHandler(processingEnv.getNodeFactory());
                this.instantiateTemplates(processingEnv, node, fragmentHandler);
                this.currentValue = new ResultTreeFragment(fragmentHandler.getFragment());
            }
            if (!this.isParam) {
                processingEnv.setVariable(this);
            }
        }
        catch (XPathEvaluationException xPathEvaluationException) {
            processingEnv.reportError(this.getNamespaceContext(), "pe2", xPathEvaluationException.getMessage());
        }
    }

    public void dump(PrintWriter printWriter, int n) {
        Util.indent(printWriter, n);
        printWriter.println(this.isParam() ? "param" : "variable");
        Util.indent(printWriter, n + 1);
        printWriter.println("name: " + this.name);
        if (this.select != null) {
            printWriter.println("select: " + this.select.toString());
        }
        super.dump(printWriter, n);
    }

    public ExpressionValue evaluate(Node node, ExpressionContext expressionContext) throws XPathEvaluationException {
        return this.currentValue;
    }

    public boolean isConstant() {
        return false;
    }

    public Class getResultType() {
        if (this.isParam) {
            if (returnType == null) {
                returnType = XPathUtil.doGetClass("com.novell.xml.xpath.ExpressionValue");
            }
            return returnType;
        }
        if (this.select != null) {
            return this.select.getResultType();
        }
        if (this.getTemplates().length == 0) {
            return StringValue.getArgType();
        }
        return ResultTreeFragment.getArgType();
    }

    public void registerForReset(XPathResetRegistrar xPathResetRegistrar) {
        if (++this.level == 1 && this.select != null) {
            this.select.registerForReset(xPathResetRegistrar);
        }
        --this.level;
    }
}

