/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.result;

import com.novell.xml.dom.AttrImpl;
import com.novell.xml.dom.DOMUtil;
import com.novell.xml.util.ExpandedQName;
import com.novell.xml.util.NamespaceName;
import com.novell.xml.util.NamespaceStack;
import com.novell.xml.xpath.XPathAttributeNode;
import com.novell.xsl.debug.Assert;
import com.novell.xsl.result.AttributeAfterChildException;
import com.novell.xsl.result.DOMResult;
import com.novell.xsl.result.IllegalNameException;
import com.novell.xsl.result.IllegalNodeException;
import com.novell.xsl.result.ResultException;
import com.novell.xsl.result.ResultHandler;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class DOMResultHandler
implements ResultHandler,
DOMResult {
    private Document document;
    protected Node currentNode;
    private NamespaceStack currentNamespaces = new NamespaceStack();
    private boolean isLevel2DOM;

    public DOMResultHandler(Document document) {
        this.document = document;
        this.isLevel2DOM = document.getImplementation().hasFeature("XML", "2.0");
    }

    public Document getDocument() {
        return this.document;
    }

    public void startDocument() throws ResultException {
        Node node;
        while ((node = this.document.getFirstChild()) != null) {
            this.document.removeChild(node);
        }
        this.currentNode = this.document;
    }

    public void endDocument() throws ResultException {
        Assert.assertCondition(this.currentNode == this.document, "too few calls to endElement");
    }

    public void startElement(String string, String string2) throws IllegalNameException, IllegalNodeException, ResultException {
        Element element = null;
        try {
            if (this.isLevel2DOM) {
                if (string2.length() == 0 && string.indexOf(58) == -1) {
                    string2 = null;
                }
                element = this.document.createElementNS(string2, string);
            } else {
                element = this.document.createElement(string);
            }
            this.currentNode = this.currentNode.appendChild(element);
            this.currentNamespaces.push();
        }
        catch (DOMException dOMException) {
            if (dOMException.code == 3) {
                throw new IllegalNodeException();
            }
            if (dOMException.code == 5) {
                throw new IllegalNameException();
            }
            throw new ResultException(dOMException);
        }
    }

    public void endElement(String string) throws ResultException {
        Assert.assertCondition(this.currentNode != this.document, "too many calls to endElement");
        this.currentNode = this.currentNode.getParentNode();
        this.currentNamespaces.pop();
    }

    public void attribute(String string, String string2) throws AttributeAfterChildException, IllegalNameException, IllegalNodeException, ResultException {
        try {
            Element element = (Element)this.currentNode;
            if (element.hasChildNodes()) {
                throw new AttributeAfterChildException();
            }
            String string3 = null;
            int n = string.indexOf(58);
            if (n != -1 && !string.startsWith("xmlns:")) {
                NamedNodeMap namedNodeMap = element.getAttributes();
                int n2 = namedNodeMap.getLength();
                ExpandedQName expandedQName = new ExpandedQName(string, element);
                string3 = expandedQName.getNamespaceURI();
                if (n2 > 0) {
                    int n3 = 0;
                    while (n3 < n2) {
                        Attr attr;
                        Node node = attr = (Attr)namedNodeMap.item(n3);
                        if (!(attr instanceof AttrImpl)) {
                            node = new XPathAttributeNode(attr, element);
                        }
                        if (expandedQName.equals(DOMUtil.getExpandedName(node))) {
                            element.removeAttributeNode(attr);
                            break;
                        }
                        ++n3;
                    }
                }
            }
            if (this.isLevel2DOM) {
                element.setAttributeNS(string3, string, string2);
            } else {
                element.setAttribute(string, string2);
            }
        }
        catch (ClassCastException classCastException) {
            throw new IllegalNodeException();
        }
        catch (DOMException dOMException) {
            if (dOMException.code == 5) {
                throw new IllegalNameException();
            }
            throw new ResultException(dOMException);
        }
    }

    public void characters(String string) throws IllegalNodeException, ResultException {
        try {
            Node node = this.currentNode.getLastChild();
            if (node != null && node.getNodeType() == 3) {
                ((Text)node).appendData(string);
            } else {
                this.currentNode.appendChild(this.document.createTextNode(string));
            }
        }
        catch (DOMException dOMException) {
            if (dOMException.code == 3) {
                throw new IllegalNodeException();
            }
            throw new ResultException(dOMException);
        }
    }

    public void processingInstruction(String string, String string2) throws IllegalNameException, IllegalNodeException, ResultException {
        try {
            this.currentNode.appendChild(this.document.createProcessingInstruction(string, string2));
        }
        catch (DOMException dOMException) {
            if (dOMException.code == 3) {
                throw new IllegalNodeException();
            }
            if (dOMException.code == 5) {
                throw new IllegalNameException();
            }
            throw new ResultException(dOMException);
        }
    }

    public void comment(String string) throws IllegalNodeException, ResultException {
        try {
            this.currentNode.appendChild(this.document.createComment(string));
        }
        catch (DOMException dOMException) {
            if (dOMException.code == 3) {
                throw new IllegalNodeException();
            }
            throw new ResultException(dOMException);
        }
    }

    public void namespace(String string, NamespaceName namespaceName) throws IllegalNodeException, ResultException {
        try {
            if (this.currentNamespaces.add(string, namespaceName)) {
                Element element = (Element)this.currentNode;
                String string2 = string.length() > 0 ? "xmlns:" + string : "xmlns";
                if (this.isLevel2DOM) {
                    element.setAttributeNS(NamespaceName.XMLNS_NAMESPACE.getString(), string2, namespaceName.getString());
                } else {
                    element.setAttribute(string2, namespaceName.getString());
                }
            }
        }
        catch (ClassCastException classCastException) {
            throw new IllegalNodeException();
        }
        catch (DOMException dOMException) {
            if (dOMException.code == 5) {
                throw new IllegalNameException();
            }
            throw new ResultException(dOMException);
        }
    }
}

