/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.result;

import com.novell.xml.util.NamespaceName;
import com.novell.xml.util.XMLUtil;
import com.novell.xsl.result.AttributeAfterChildException;
import com.novell.xsl.result.HTMLSerializer;
import com.novell.xsl.result.IllegalNameException;
import com.novell.xsl.result.IllegalNodeException;
import com.novell.xsl.result.ResultException;
import com.novell.xsl.result.ResultHandler;
import com.novell.xsl.result.Serializer;
import com.novell.xsl.result.SerializerOptions;
import com.novell.xsl.result.XMLSerializer;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DefaultSerializer
implements ResultHandler,
Serializer {
    private ResultHandler impl = null;
    private OutputStream stream = null;
    private SerializerOptions options = null;
    private List bufferedStuff = null;
    private boolean noEscape = false;
    private boolean firstElement = false;
    private static final int USE_XML = 0;
    private static final int USE_HTML = 1;

    public DefaultSerializer() {
    }

    public DefaultSerializer(OutputStream outputStream) {
        this.stream = outputStream;
    }

    public void startDocument() throws ResultException {
        if (this.impl != null) {
            this.impl.startDocument();
        } else {
            this.initState();
        }
    }

    public void endDocument() throws ResultException {
        if (this.impl != null) {
            this.impl.endDocument();
        } else {
            this.startForReal();
        }
    }

    public void startElement(String string, String string2) throws IllegalNameException, IllegalNodeException, ResultException {
        if (this.impl != null) {
            this.impl.startElement(string, string2);
        } else {
            if (!XMLUtil.isQName(string)) {
                throw new IllegalNameException();
            }
            this.bufferNode(string, string2, 1);
        }
    }

    public void endElement(String string) throws ResultException {
        if (this.impl != null) {
            this.impl.endElement(string);
        } else {
            this.startForReal();
            this.impl.endElement(string);
        }
    }

    public void attribute(String string, String string2) throws AttributeAfterChildException, IllegalNameException, IllegalNodeException, ResultException {
        if (this.impl != null) {
            this.impl.attribute(string, string2);
        } else {
            if (!this.firstElement) {
                throw new IllegalNodeException();
            }
            if (!XMLUtil.isQName(string)) {
                throw new IllegalNameException();
            }
            this.bufferNode(string, string2, 2);
        }
    }

    public void characters(String string) throws IllegalNodeException, ResultException {
        if (this.impl != null) {
            this.impl.characters(string);
        } else {
            this.bufferNode(null, string, 3);
        }
    }

    public void processingInstruction(String string, String string2) throws IllegalNameException, IllegalNodeException, ResultException {
        if (this.impl != null) {
            this.impl.processingInstruction(string, string2);
        } else {
            if (!XMLUtil.isPITarget(string)) {
                throw new IllegalNameException();
            }
            this.bufferNode(string, string2, 7);
        }
    }

    public void comment(String string) throws IllegalNodeException, ResultException {
        if (this.impl != null) {
            this.impl.comment(string);
        } else {
            this.bufferNode(null, string, 8);
        }
    }

    public void namespace(String string, NamespaceName namespaceName) throws IllegalNodeException, ResultException {
        if (this.impl != null) {
            this.impl.namespace(string, namespaceName);
        } else {
            if (!this.firstElement) {
                throw new IllegalNodeException();
            }
            this.bufferNode(string, namespaceName.getString(), -1);
        }
    }

    public SerializerOptions getOptions() {
        if (this.impl != null) {
            return ((Serializer)((Object)this.impl)).getOptions();
        }
        return this.options;
    }

    public void setOptions(SerializerOptions serializerOptions) {
        if (this.impl != null) {
            ((Serializer)((Object)this.impl)).setOptions(serializerOptions);
            this.options = serializerOptions;
        } else {
            if (serializerOptions == null) {
                throw new IllegalArgumentException("DefaultSerializer.setOptions: null options");
            }
            this.options = serializerOptions;
        }
    }

    public OutputStream getStream() {
        if (this.impl != null) {
            return ((Serializer)((Object)this.impl)).getStream();
        }
        return this.stream;
    }

    public void setStream(OutputStream outputStream) {
        if (this.impl != null) {
            ((Serializer)((Object)this.impl)).setStream(outputStream);
        } else {
            this.stream = outputStream;
        }
    }

    public void noTextEscaping(boolean bl) {
        if (this.impl != null) {
            ((Serializer)((Object)this.impl)).noTextEscaping(bl);
        } else {
            this.noEscape = bl;
        }
    }

    private void bufferNode(String string, String string2, int n) throws ResultException {
        if (this.bufferedStuff == null) {
            this.bufferedStuff = new ArrayList(8);
        }
        this.bufferedStuff.add(new NodeBuffer(string, string2, n, this.noEscape));
        if (this.firstElement && n != 2 && n != -1 || n == 3 && !XMLUtil.isXMLWhitespace(string2)) {
            this.startForReal();
            return;
        }
        if (n == 1) {
            this.firstElement = true;
        }
    }

    private void startForReal() throws ResultException {
        boolean bl;
        int n;
        Iterator iterator;
        if (this.bufferedStuff != null) {
            iterator = this.bufferedStuff.iterator();
            boolean bl2 = true;
            n = 0;
            while (iterator.hasNext()) {
                NodeBuffer nodeBuffer = (NodeBuffer)iterator.next();
                if (nodeBuffer.getType() == 3) {
                    if (XMLUtil.isXMLWhitespace(nodeBuffer.getValue())) continue;
                    bl2 = false;
                    break;
                }
                if (nodeBuffer.getType() != 1) continue;
                String string = nodeBuffer.getName();
                if (!string.equalsIgnoreCase("html")) break;
                while (iterator.hasNext()) {
                    nodeBuffer = (NodeBuffer)iterator.next();
                    if (nodeBuffer.getType() == -1 && nodeBuffer.getName().equals("")) break;
                }
                if (iterator.hasNext()) break;
                n = 1;
                break;
            }
            bl = bl2 && n != 0;
        } else {
            bl = false;
        }
        this.impl = bl ? new HTMLSerializer(this.stream) : new XMLSerializer(this.stream);
        if (this.options != null) {
            ((Serializer)((Object)this.impl)).setOptions(this.options);
        }
        this.impl.startDocument();
        if (this.bufferedStuff != null) {
            iterator = this.bufferedStuff.iterator();
            while (iterator.hasNext()) {
                NodeBuffer nodeBuffer = (NodeBuffer)iterator.next();
                n = nodeBuffer.getType();
                if (n == 3) {
                    if (nodeBuffer.getNoEscape()) {
                        ((Serializer)((Object)this.impl)).noTextEscaping(true);
                        this.impl.characters(nodeBuffer.getValue());
                        ((Serializer)((Object)this.impl)).noTextEscaping(false);
                        continue;
                    }
                    this.impl.characters(nodeBuffer.getValue());
                    continue;
                }
                if (n == 8) {
                    this.impl.comment(nodeBuffer.getValue());
                    continue;
                }
                if (n == 7) {
                    this.impl.processingInstruction(nodeBuffer.getName(), nodeBuffer.getValue());
                    continue;
                }
                if (n == 1) {
                    this.impl.startElement(nodeBuffer.getName(), nodeBuffer.getValue());
                    continue;
                }
                if (n == 2) {
                    this.impl.attribute(nodeBuffer.getName(), nodeBuffer.getValue());
                    continue;
                }
                if (n != -1) continue;
                this.impl.namespace(nodeBuffer.getName(), new NamespaceName(nodeBuffer.getValue()));
            }
            this.bufferedStuff.clear();
            this.bufferedStuff = null;
        }
    }

    private void initState() {
        if (this.bufferedStuff != null) {
            this.bufferedStuff.clear();
        }
        this.impl = null;
        this.noEscape = false;
        this.firstElement = false;
    }

    static class NodeBuffer {
        private final int type;
        private final String name;
        private final String value;
        private final boolean noEscape;

        public NodeBuffer(String string, String string2, int n, boolean bl) {
            this.name = string;
            this.value = string2;
            this.type = n;
            this.noEscape = bl;
        }

        public int getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public boolean getNoEscape() {
            return this.noEscape;
        }
    }
}

