/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.result;

import com.novell.xml.dom.DocumentImpl;
import com.novell.xml.parser.SAXParserImpl;
import com.novell.xml.parser.XMLParser;
import com.novell.xml.parser.XMLParserFactory;
import com.novell.xml.sax.DocumentCommentHandler;
import com.novell.xml.sax.SAXtoDOM;
import com.novell.xml.util.ExpandedQName;
import com.novell.xml.util.NamespaceName;
import com.novell.xml.util.NamespaceStack;
import com.novell.xml.util.XMLUtil;
import com.novell.xsl.DefaultErrorHandler;
import com.novell.xsl.DefaultMessageHandler;
import com.novell.xsl.SAXtoDOMStrip;
import com.novell.xsl.Stylesheet;
import com.novell.xsl.XSLException;
import com.novell.xsl.result.AttributeAfterChildException;
import com.novell.xsl.result.IllegalNameException;
import com.novell.xsl.result.IllegalNodeException;
import com.novell.xsl.result.ResultException;
import com.novell.xsl.result.ResultHandler;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Stack;
import org.w3c.dom.Document;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributeListImpl;

public class SAXResultHandler
implements ResultHandler,
Parser {
    protected DocumentHandler documentHandler = null;
    protected ErrorHandler errorHandler = null;
    protected boolean doPIComments = false;
    protected String elementName;
    protected boolean startTagOpen = false;
    protected List attributeNames = new ArrayList(16);
    protected List attributeValues = new ArrayList(16);
    protected NamespaceStack currentNamespaces = new NamespaceStack();
    protected Stack stateStack = new Stack();
    protected AttributeListImpl attrList = new AttributeListImpl();
    protected Stylesheet stylesheet;
    protected Parser parser = null;
    protected Document sourceDocument = null;

    public SAXResultHandler(String string) throws IOException, XSLException {
        XMLParser xMLParser = XMLParserFactory.newParser();
        Document document = xMLParser.parse(string);
        if (xMLParser.anyErrors()) {
            throw new XSLException(xMLParser.getErrorMsgString());
        }
        DefaultErrorHandler defaultErrorHandler = new DefaultErrorHandler();
        DefaultMessageHandler defaultMessageHandler = new DefaultMessageHandler();
        this.stylesheet = new Stylesheet();
        this.stylesheet.setErrorHandler(defaultErrorHandler);
        this.stylesheet.setMessageHandler(defaultMessageHandler);
        this.stylesheet.setBaseURI(string);
        this.stylesheet.load(document);
    }

    public SAXResultHandler(Parser parser, Stylesheet stylesheet) {
        this.parser = parser;
        this.stylesheet = stylesheet;
    }

    public SAXResultHandler(Document document, Stylesheet stylesheet) {
        this.sourceDocument = document;
        this.stylesheet = stylesheet;
    }

    public SAXResultHandler(Stylesheet stylesheet) {
        this.stylesheet = stylesheet;
    }

    public SAXResultHandler() {
        this.stylesheet = null;
    }

    public void setUsePIComment(boolean bl) {
        this.doPIComments = bl;
    }

    public void startDocument() throws ResultException {
        if (this.documentHandler != null) {
            try {
                this.documentHandler.startDocument();
            }
            catch (SAXException sAXException) {
                throw new ResultException(sAXException);
            }
        }
    }

    public void endDocument() throws ResultException {
        if (this.documentHandler != null) {
            try {
                this.documentHandler.endDocument();
            }
            catch (SAXException sAXException) {
                throw new ResultException(sAXException);
            }
        }
    }

    public void startElement(String string, String string2) throws IllegalNameException, IllegalNodeException, ResultException {
        this.closeStartTag();
        if (!XMLUtil.isQName(string)) {
            throw new IllegalNameException();
        }
        this.pushState();
        this.elementName = string;
        this.startTagOpen = true;
        this.attributeNames.clear();
        this.attributeValues.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endElement(String string) throws ResultException {
        try {
            this.closeStartTag();
            if (this.documentHandler != null) {
                try {
                    this.documentHandler.endElement(string);
                }
                catch (SAXException sAXException) {
                    throw new ResultException(sAXException);
                }
            }
            Object var4_3 = null;
            this.popState();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.popState();
            throw throwable;
        }
    }

    public void attribute(String string, String string2) throws AttributeAfterChildException, IllegalNameException, IllegalNodeException, ResultException {
        ExpandedQName expandedQName;
        if (this.elementName == null) {
            throw new IllegalNodeException();
        }
        if (this.startTagOpen) {
            if (!XMLUtil.isQName(string)) {
                throw new IllegalNameException();
            }
            expandedQName = this.getExpandedName(string, true);
            int n = 0;
            while (n < this.attributeNames.size()) {
                if (expandedQName.equals((ExpandedQName)this.attributeNames.get(n))) {
                    this.attributeNames.set(n, expandedQName);
                    this.attributeValues.set(n, string2);
                    return;
                }
                ++n;
            }
        } else {
            throw new AttributeAfterChildException();
        }
        this.attributeNames.add(expandedQName);
        this.attributeValues.add(string2);
    }

    public void characters(String string) throws IllegalNodeException, ResultException {
        this.closeStartTag();
        if (this.documentHandler != null) {
            try {
                char[] cArray = string.toCharArray();
                this.documentHandler.characters(cArray, 0, cArray.length);
            }
            catch (SAXException sAXException) {
                throw new ResultException(sAXException);
            }
        }
    }

    public void processingInstruction(String string, String string2) throws IllegalNameException, IllegalNodeException, ResultException {
        if (!XMLUtil.isPITarget(string)) {
            throw new IllegalNameException();
        }
        this.closeStartTag();
        if (this.documentHandler != null) {
            try {
                this.documentHandler.processingInstruction(string, string2);
            }
            catch (SAXException sAXException) {
                throw new ResultException(sAXException);
            }
        }
    }

    public void comment(String string) throws IllegalNodeException, ResultException {
        this.closeStartTag();
        if (this.documentHandler != null) {
            try {
                if (this.documentHandler instanceof DocumentCommentHandler) {
                    ((DocumentCommentHandler)this.documentHandler).comment(string);
                } else if (this.doPIComments) {
                    this.documentHandler.processingInstruction(null, string);
                }
            }
            catch (SAXException sAXException) {
                throw new ResultException(sAXException);
            }
        }
    }

    public void namespace(String string, NamespaceName namespaceName) throws IllegalNodeException, ResultException {
        if (!this.startTagOpen) {
            throw new IllegalNodeException();
        }
        if (this.currentNamespaces.add(string, namespaceName)) {
            String string2 = string.length() > 0 ? "xmlns:" + string : "xmlns";
            this.attribute(string2, namespaceName.getString());
        }
    }

    public void setLocale(Locale locale) throws SAXException {
    }

    public void setEntityResolver(EntityResolver entityResolver) {
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
    }

    public void setDocumentHandler(DocumentHandler documentHandler) {
        this.documentHandler = documentHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void parse(InputSource inputSource) throws SAXException, IOException {
        Document document;
        Object object;
        if (this.stylesheet == null) {
            throw new SAXException("SAXResultHandler: no stylesheet associated with object");
        }
        boolean bl = false;
        if (this.sourceDocument == null) {
            if (this.parser == null) {
                object = XMLParserFactory.newParser();
                if (object instanceof SAXParserImpl) {
                    ((SAXParserImpl)object).setConverter(new SAXtoDOMStrip(DocumentImpl.newDocument(), this.stylesheet.getStripList()));
                    bl = true;
                }
                document = object.parse(inputSource);
                if (object.anyErrors()) {
                    throw new SAXException(object.getErrorMsgString());
                }
            } else {
                object = new SAXtoDOMStrip(DocumentImpl.newDocument(), this.stylesheet.getStripList());
                this.parser.setDocumentHandler((DocumentHandler)object);
                this.parser.setDTDHandler((DTDHandler)object);
                this.parser.parse(inputSource);
                document = ((SAXtoDOM)object).getResult();
                bl = true;
            }
        } else {
            document = this.sourceDocument;
        }
        this.stylesheet.setResultHandler(this);
        object = null;
        String string = inputSource.getSystemId();
        if (string != null) {
            object = new URL(string);
        }
        try {
            this.stylesheet.process(document, (URL)object, bl);
        }
        catch (XSLException xSLException) {
            throw new SAXException(xSLException);
        }
    }

    public void parse(String string) throws SAXException, IOException {
        this.parse(new InputSource(string));
    }

    protected void closeStartTag() throws ResultException {
        if (this.startTagOpen) {
            this.startTagOpen = false;
            if (this.documentHandler != null) {
                this.attrList.clear();
                int n = 0;
                while (n < this.attributeNames.size()) {
                    this.attrList.addAttribute(((ExpandedQName)this.attributeNames.get(n)).getQName(), "CDATA", (String)this.attributeValues.get(n));
                    ++n;
                }
                try {
                    this.documentHandler.startElement(this.elementName, this.attrList);
                }
                catch (SAXException sAXException) {
                    throw new ResultException(sAXException);
                }
            }
        }
    }

    protected ExpandedQName getExpandedName(String string, boolean bl) throws IllegalNameException {
        String string2;
        String string3;
        int n = string.indexOf(58);
        if (n == -1 || bl && string.startsWith("xmlns")) {
            if (bl) {
                return new ExpandedQName("", string, "");
            }
            string3 = "";
            string2 = string;
        } else {
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1, string.length());
        }
        NamespaceName namespaceName = this.currentNamespaces.getNamespaceName(string3);
        if (namespaceName == null) {
            throw new IllegalNameException();
        }
        return new ExpandedQName(namespaceName, string2, string3);
    }

    protected void pushState() {
        this.stateStack.push(this.elementName);
        this.currentNamespaces.push();
    }

    protected void popState() {
        this.currentNamespaces.pop();
        this.elementName = (String)this.stateStack.pop();
    }
}

