/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.result;

import com.novell.xml.util.ExpandedQName;
import java.util.Collection;
import java.util.Iterator;

public class SerializerOptions {
    private ExpandedQName method = null;
    private String version = null;
    private boolean indent = false;
    private String encoding = null;
    private String mediaType = null;
    private String doctypeSystem = null;
    private String doctypePublic = null;
    private boolean declaration = false;
    private boolean standalone = false;
    private Collection cdataSectionElements = null;
    private int flags = 0;
    private static int INDENT_SET = 1;
    private static int DECLARATION_SET = 2;
    private static int STANDALONE_SET = 4;

    public ExpandedQName getMethod() {
        return this.method;
    }

    public void setMethod(ExpandedQName expandedQName) {
        this.method = expandedQName;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public boolean getIndent() {
        return this.indent;
    }

    public void setIndent(boolean bl) {
        this.indent = bl;
        this.flags |= INDENT_SET;
    }

    public boolean wasIndentSet() {
        return (this.flags & INDENT_SET) != 0;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(String string) {
        this.mediaType = string;
    }

    public String getDoctypeSystem() {
        return this.doctypeSystem;
    }

    public void setDoctypeSystem(String string) {
        this.doctypeSystem = string;
    }

    public String getDoctypePublic() {
        return this.doctypePublic;
    }

    public void setDoctypePublic(String string) {
        this.doctypePublic = string;
    }

    public boolean getDeclaration() {
        return this.declaration;
    }

    public void setDeclaration(boolean bl) {
        this.declaration = bl;
        this.flags |= DECLARATION_SET;
    }

    public boolean wasDeclarationSet() {
        return (this.flags & DECLARATION_SET) != 0;
    }

    public boolean getStandalone() {
        return this.declaration;
    }

    public void setStandalone(boolean bl) {
        this.standalone = bl;
        this.flags |= STANDALONE_SET;
    }

    public boolean wasStandaloneSet() {
        return (this.flags & STANDALONE_SET) != 0;
    }

    public Collection getCdataSectionElements() {
        return this.cdataSectionElements;
    }

    public void setCdataSectionElements(Collection collection) {
        this.cdataSectionElements = collection;
    }

    public void merge(SerializerOptions serializerOptions) {
        if (this.method == null || this.method.getLocalPart().length() == 0) {
            this.method = serializerOptions.method;
        }
        if (this.version == null || this.version.length() == 0) {
            this.version = serializerOptions.version;
        }
        if ((this.flags & INDENT_SET) != 0) {
            this.indent = serializerOptions.indent;
            this.flags = this.flags & ~INDENT_SET | serializerOptions.flags & INDENT_SET;
        }
        if (this.encoding == null || this.encoding.length() == 0) {
            this.encoding = serializerOptions.encoding;
        }
        if (this.mediaType == null || this.mediaType.length() == 0) {
            this.mediaType = serializerOptions.mediaType;
        }
        if (this.doctypeSystem == null || this.doctypeSystem.length() == 0) {
            this.doctypeSystem = serializerOptions.doctypeSystem;
        }
        if (this.doctypePublic == null || this.doctypePublic.length() == 0) {
            this.doctypePublic = serializerOptions.doctypePublic;
        }
        if ((this.flags & DECLARATION_SET) != 0) {
            this.declaration = serializerOptions.declaration;
            this.flags = this.flags & ~DECLARATION_SET | serializerOptions.flags & DECLARATION_SET;
        }
        if ((this.flags & STANDALONE_SET) != 0) {
            this.standalone = serializerOptions.standalone;
            this.flags = this.flags & ~STANDALONE_SET | serializerOptions.flags & STANDALONE_SET;
        }
        if (this.cdataSectionElements == null || this.cdataSectionElements.isEmpty()) {
            this.cdataSectionElements = serializerOptions.cdataSectionElements;
        } else if (serializerOptions.cdataSectionElements != null && !serializerOptions.cdataSectionElements.isEmpty()) {
            Iterator iterator = serializerOptions.cdataSectionElements.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (this.cdataSectionElements.contains(e)) continue;
                this.cdataSectionElements.add(e);
            }
        }
    }
}

