/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.result;

import com.novell.xml.util.ExpandedQName;
import com.novell.xml.util.NamespaceName;
import com.novell.xml.util.NamespaceStack;
import com.novell.xml.util.XMLUtil;
import com.novell.xsl.debug.Assert;
import com.novell.xsl.result.AttributeAfterChildException;
import com.novell.xsl.result.IllegalNameException;
import com.novell.xsl.result.IllegalNodeException;
import com.novell.xsl.result.ResultException;
import com.novell.xsl.result.ResultHandler;
import com.novell.xsl.result.Serializer;
import com.novell.xsl.result.SerializerImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Stack;

public class XMLSerializer
extends SerializerImpl
implements ResultHandler,
Serializer {
    protected int elementCount = 0;
    protected boolean startTagOpen = false;
    protected boolean noEscape = false;
    protected boolean forceDTD = false;
    protected int indentLevel = 0;
    protected int nodeType = -1;
    protected List attributeNames = new ArrayList(16);
    protected List attributeValues = new ArrayList(16);
    protected boolean children = false;
    protected String elementName;
    protected NamespaceStack currentNamespaces = new NamespaceStack();
    protected boolean cdataOutput = false;
    protected Stack stateStack = new Stack();
    protected static final int XML_SPACE_DEFAULT = 0;
    protected static final int XML_SPACE_PRESERVE = 1;
    protected static final Integer xmlSpaceDefault = new Integer(0);
    protected static final Integer xmlSpacePreserve = new Integer(1);
    protected int xmlSpace = 0;

    public XMLSerializer() {
    }

    public XMLSerializer(OutputStream outputStream) {
        this.setStream(outputStream);
    }

    public void startDocument() throws ResultException {
        try {
            this.initWriter();
            this.initState();
            if (this.options.getDeclaration()) {
                this.writer.write("<?xml version=\"1.0\"");
                this.writer.write(" encoding=\"");
                this.writer.write(this.actualEncoding);
                this.writer.write(34);
                if (this.options.getStandalone()) {
                    this.writer.write(" standalone=\"yes\"");
                }
                this.writer.write("?>");
                if (this.options.getIndent() && this.xmlSpace != 1) {
                    this.writer.write(10);
                    this.nodeType = 3;
                }
            }
        }
        catch (IOException iOException) {
            throw new ResultException(iOException);
        }
    }

    public void endDocument() throws ResultException {
        try {
            this.writer.flush();
        }
        catch (IOException iOException) {
            throw new ResultException(iOException);
        }
    }

    public void startElement(String string, String string2) throws IllegalNameException, IllegalNodeException, ResultException {
        try {
            if (!XMLUtil.isQName(string)) {
                throw new IllegalNameException();
            }
            if (this.elementCount == 0 && (this.forceDTD || this.options.getDoctypeSystem() != null && this.options.getDoctypeSystem().length() > 0)) {
                this.writeDTD(string);
            }
            ++this.elementCount;
            this.children = true;
            this.pushState();
            this.closeStartTag();
            this.children = false;
            this.elementName = string;
            this.cdataOutput = this.useCdataOutput(string);
            this.attributeNames.clear();
            this.attributeValues.clear();
            this.injectWhitespace(1, this.nodeType);
            this.writer.write(60);
            this.writer.write(string);
            this.startTagOpen = true;
            ++this.indentLevel;
            this.nodeType = 1;
        }
        catch (IOException iOException) {
            throw new ResultException(iOException);
        }
    }

    public void endElement(String string) throws ResultException {
        try {
            Assert.assertCondition(!this.stateStack.empty(), "XMLSerializer: too many calls to endElement()");
            if (!this.children) {
                this.closeStartTag();
            } else {
                if (this.options.getIndent() && this.nodeType != 3 && this.xmlSpace != 1) {
                    this.writer.write(10);
                    this.doIndent(this.indentLevel - 1);
                }
                this.writer.write("</");
                this.writer.write(string);
                this.writer.write(62);
            }
            --this.indentLevel;
            this.popState();
            this.nodeType = 1;
        }
        catch (IOException iOException) {
            throw new ResultException(iOException);
        }
    }

    public void attribute(String string, String string2) throws AttributeAfterChildException, IllegalNameException, IllegalNodeException, ResultException {
        if (this.elementName == null) {
            throw new IllegalNodeException();
        }
        if (this.startTagOpen) {
            if (!XMLUtil.isQName(string)) {
                throw new IllegalNameException();
            }
            ExpandedQName expandedQName = this.getExpandedName(string, true);
            int n = 0;
            while (n < this.attributeNames.size()) {
                if (expandedQName.equals((ExpandedQName)this.attributeNames.get(n))) {
                    this.attributeNames.set(n, expandedQName);
                    this.attributeValues.set(n, string2);
                    return;
                }
                ++n;
            }
            this.attributeNames.add(expandedQName);
            this.attributeValues.add(string2);
            if (string.equals("xml:space")) {
                this.xmlSpace = string2.equals("preserve") ? 1 : 0;
            }
        } else {
            throw new AttributeAfterChildException();
        }
    }

    public void characters(String string) throws IllegalNodeException, ResultException {
        try {
            this.children = true;
            this.closeStartTag();
            if (this.noEscape) {
                this.writer.write(string);
            } else if (this.cdataOutput) {
                XMLUtil.encodeAsCData(this.writer, string);
            } else {
                XMLUtil.encodeText(this.writer, string);
            }
            this.nodeType = 3;
        }
        catch (IOException iOException) {
            throw new ResultException(iOException);
        }
    }

    public void processingInstruction(String string, String string2) throws IllegalNameException, IllegalNodeException, ResultException {
        try {
            if (!XMLUtil.isPITarget(string)) {
                throw new IllegalNameException();
            }
            this.children = true;
            this.closeStartTag();
            this.injectWhitespace(7, this.nodeType);
            this.writer.write("<?");
            this.writer.write(string);
            if (string2 != null && string2.length() > 0) {
                this.writer.write(32);
                this.writer.write(string2);
            }
            this.writer.write("?>");
            this.nodeType = 7;
        }
        catch (IOException iOException) {
            throw new ResultException(iOException);
        }
    }

    public void comment(String string) throws IllegalNodeException, ResultException {
        try {
            this.children = true;
            this.closeStartTag();
            this.injectWhitespace(8, this.nodeType);
            this.writer.write("<!--");
            this.writer.write(string);
            this.writer.write("-->");
            this.nodeType = 8;
        }
        catch (IOException iOException) {
            throw new ResultException(iOException);
        }
    }

    public void namespace(String string, NamespaceName namespaceName) throws IllegalNodeException, ResultException {
        if (!this.startTagOpen) {
            throw new IllegalNodeException();
        }
        if (this.currentNamespaces.add(string, namespaceName)) {
            String string2 = string.length() > 0 ? "xmlns:" + string : "xmlns";
            this.attribute(string2, namespaceName.getString());
        }
    }

    public void noTextEscaping(boolean bl) {
        this.noEscape = bl;
    }

    protected void writeDTD(String string) throws IOException {
        this.writer.write("<!DOCTYPE ");
        this.writer.write(string);
        String string2 = this.options.getDoctypePublic();
        String string3 = this.options.getDoctypeSystem();
        if (string2 != null && string2.length() > 0) {
            this.writer.write(" PUBLIC ");
            int n = string2.indexOf(34) != -1 ? 39 : 34;
            this.writer.write(n);
            this.writer.write(string2);
            this.writer.write(n);
            this.writer.write(32);
            n = string3.indexOf(34) != -1 ? 39 : 34;
            this.writer.write(n);
            this.writer.write(string3);
            this.writer.write(n);
        } else {
            this.writer.write(" SYSTEM ");
            int n = string3.indexOf(34) != -1 ? 39 : 34;
            this.writer.write(n);
            this.writer.write(string3);
            this.writer.write(n);
        }
        this.writer.write(" >");
    }

    protected void closeStartTag() throws IOException, ResultException {
        if (this.startTagOpen) {
            this.startTagOpen = false;
            int n = 0;
            while (n < this.attributeNames.size()) {
                this.outputXMLAttribute((ExpandedQName)this.attributeNames.get(n), (String)this.attributeValues.get(n));
                ++n;
            }
            if (this.children) {
                this.writer.write(62);
            } else {
                this.writer.write("/>");
            }
        }
    }

    protected void injectWhitespace(int n, int n2) throws IOException {
        if (!this.options.getIndent() || this.xmlSpace == 1) {
            return;
        }
        switch (n) {
            case 1: 
            case 7: 
            case 8: {
                if (n2 == 3) break;
                this.writer.write(10);
                this.doIndent(this.indentLevel);
                break;
            }
        }
    }

    protected void doIndent(int n) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            this.writer.write(9);
            ++n2;
        }
    }

    protected boolean useCdataOutput(String string) throws IllegalNameException {
        Collection collection = this.options.getCdataSectionElements();
        if (collection == null || collection.isEmpty()) {
            return false;
        }
        return collection.contains(this.getExpandedName(string, false));
    }

    protected void initState() {
        this.elementCount = 0;
        this.startTagOpen = false;
        this.noEscape = false;
        this.indentLevel = 0;
        this.nodeType = -1;
        this.forceDTD = false;
    }

    protected void pushState() {
        this.stateStack.push(this.children ? Boolean.TRUE : Boolean.FALSE);
        this.stateStack.push(this.elementName);
        this.stateStack.push(this.cdataOutput ? Boolean.TRUE : Boolean.FALSE);
        this.stateStack.push(this.xmlSpace == 0 ? xmlSpaceDefault : xmlSpacePreserve);
        this.currentNamespaces.push();
    }

    protected void popState() {
        this.currentNamespaces.pop();
        this.xmlSpace = (Integer)this.stateStack.pop();
        this.cdataOutput = (Boolean)this.stateStack.pop();
        this.elementName = (String)this.stateStack.pop();
        this.children = (Boolean)this.stateStack.pop();
    }

    protected ExpandedQName getExpandedName(String string, boolean bl) throws IllegalNameException {
        String string2;
        String string3;
        int n = string.indexOf(58);
        if (n == -1 || bl && string.startsWith("xmlns")) {
            if (bl) {
                return new ExpandedQName("", string, "");
            }
            string3 = "";
            string2 = string;
        } else {
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1, string.length());
        }
        NamespaceName namespaceName = this.currentNamespaces.getNamespaceName(string3);
        if (namespaceName == null) {
            throw new IllegalNameException();
        }
        return new ExpandedQName(namespaceName, string2, string3);
    }

    protected void outputXMLAttribute(ExpandedQName expandedQName, String string) throws IOException {
        this.writer.write(32);
        String string2 = expandedQName.getPrefix();
        if (string2 != null && string2.length() > 0) {
            this.writer.write(string2);
            this.writer.write(58);
        }
        this.writer.write(expandedQName.getLocalPart());
        this.writer.write(61);
        XMLUtil.encodeAttribute(this.writer, string);
    }
}

