/*=============================================================================
  $Id: Login.java,v 1.1.1.1 2001/05/09 12:46:34 rommel Exp $

  Copyright (c) 1997-2000 Novell, Inc.  All Rights Reserved.

  THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL PROPRIETARY
  AND TRADE SECRET INFORMATION OF NOVELL, INC. ACCESS  TO  THIS  WORK IS
  RESTRICTED TO (I) NOVELL, INC.  EMPLOYEES WHO HAVE A NEED TO  KNOW HOW
  TO  PERFORM  TASKS WITHIN  THE SCOPE  OF  THEIR   ASSIGNMENTS AND (II)
  ENTITIES OTHER  THAN  NOVELL, INC.  WHO  HAVE ENTERED INTO APPROPRIATE
  LICENSE   AGREEMENTS.  NO  PART  OF  THIS WORK MAY BE USED, PRACTICED,
  PERFORMED COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED, ABRIDGED,
  CONDENSED, EXPANDED, COLLECTED, COMPILED, LINKED,  RECAST, TRANSFORMED
  OR ADAPTED  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC.  ANY USE
  OR EXPLOITATION  OF  THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE
  PERPETRATOR  TO CRIMINAL AND CIVIL LIABILITY.
==============================================================================*/
package com.novell.admin.common.security;

import java.awt.*;
import java.awt.event.*;
import java.lang.*;
import java.util.*;
import java.io.*;
import java.text.*;
import javax.swing.*;

import com.novell.admin.ns.*;
import com.novell.admin.common.ui.*;
import com.novell.admin.common.exceptions.*;
import com.novell.admin.common.util.*;
import com.novell.application.console.snapin.*;
import com.novell.application.console.widgets.*;
import com.novell.utility.nmsgbox.*;
import com.novell.application.console.shell.*;


/**
 * Authentication Dialog
 */
public class Login
{
   private Object nameSpace;
   private String contextDelimiter;
   public static final int ID_LOGIN    =  1;
public static final int ID_CANCEL    =  0;

   
   public Login(Shell shell, Object ns, String hostLabel, String delimiter)
   {
      contextDelimiter = delimiter;
      nameSpace = ns;
      doTheLogin(shell, hostLabel, "");
   }

   public Login(Shell shell, Object ns, String hostLabel, String hostName,
                String delimiter)
   {
      contextDelimiter = delimiter;
      nameSpace = ns;
      doTheLogin(shell, hostLabel, hostName);
   }

   private void doTheLogin(Shell shell, String hostLabel, String hostName)
   {
      NLoginDlg dlg;
      boolean again = true;
      
      while (again)
      {
         dlg = new NLoginDlg(shell, hostLabel, hostName);

         if (dlg.launch() == NLoginDlg.ID_LOGIN)
         {
            shell.setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
            String host = dlg.getHost().toUpperCase();
            String name = dlg.getLoginName();
            String context = dlg.getContext();
            String password = dlg.getPassword();
            
            String fdn = name + contextDelimiter + context;
            nameSpace = (AuthenticationNamespace)nameSpace;
            
            try
            {
               ((AuthenticationNamespace)nameSpace).authenticate(fdn, host, password);
               
               try
               {
                  ((NamespaceSnapin)nameSpace).getInitialObjectEntries();
                  
                  ObjectEntry ndsOE = shell.getPlaceholderObjectEntry(AdminID.PLACEHOLDER_THE_NETWORK);

                  shell.refreshTreeEntry(ndsOE);
               }
               catch (SPIException x)
               {
                  throw x;  // pass it to to the outer try block so it is handled
               }
               catch (Exception x)
               {
                  x.printStackTrace();
               }
            }
            catch (SPIException e)
            {
               // Catch -223 error that is thrown when the user's password has expired but the user still
               // has at least one grace login.
               if ((e instanceof UniqueSPIException) && (((UniqueSPIException)e).getErrorCode() == -223))
               {
                  // Set up the message format information
                  String pattern = security.getString(security.PASSWORD_EXPIRED_PATTERN);
                  AdminNamespace ns = ((AdminNamespace)nameSpace);
                  
                  String msg = MessageFormat.format(pattern,
                     new Object[]{name});
                  
                  // The users password has expired. Ask them if they want to change their password.
                  NMsgBox box = new NMsgBox(shell.getShellFrame(),
      	            security.getString(security.CONFIRM),
      	            msg,
      	            NMsgBox.CONFIRM);
      	         box.setVisible(true);
                  
                  if (box.getPressedButton() == NMsgBox.YES_BUTTON)
                  {
                     try
                     {
                        ObjectEntry userOe = ((AdminNamespace)nameSpace).getObjectEntry(fdn);
                        
                        NChangeExpiredPasswordDlg expDlg = new NChangeExpiredPasswordDlg(shell);
      
                        int rval = expDlg.launch();
                        switch (rval)
                        {
                           case ID_LOGIN:
                           {
                              shell.setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
                              String newPassword = expDlg.getNewPassword();

                              try
                              {
                                 ((AuthenticationNamespace)nameSpace).changePassword(userOe, password, newPassword);
                                 shell.setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
                              }
                              catch (SPIException exception)
                              {
                                 shell.setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
                                 NSPIExceptionMsgBox nbox = new NSPIExceptionMsgBox(shell, exception);
                                 nbox.setVisible(true);
                              }
                              break;
                           }

                           case ID_CANCEL:
                           {
                              // User canceled. Don't do anything
                           }
                        }
                     }
                     catch (Exception ex)
                     {
                        ex.printStackTrace();
                     }
                     
                     // The user should already be authenticated. Display the tree name
                     try
                     {
                        ((NamespaceSnapin)nameSpace).getInitialObjectEntries();
                        
                        ObjectEntry ndsOE = shell.getPlaceholderObjectEntry(AdminID.PLACEHOLDER_THE_NETWORK);

                        shell.refreshTreeEntry(ndsOE);
                     }
                     catch (Exception x)
                     {
                        x.printStackTrace();
                     }
                  }
                  else
                  {
                  	// The user is authenticated but chose not to change password. Need to refresh the tree.
                     shell.refreshEntireTree();
                  }
               }
               else
               {
                  NSPIExceptionMsgBox nbox = new NSPIExceptionMsgBox( shell, e );
                  nbox.setVisible( true );
                  
                  // Let the user try it again if something fails.
                  continue;
               }
            }
            finally
            {
               shell.setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
            }
         }
         else
         {
            break;
         }

         again = false;
      }
   }
}