/*
   $RCSfile: ShellFocusEvent.java,v $
   $Revision: 1.1.1.1 $ $Name:  $
   $Date: 2001/05/09 12:43:25 $

   $ProjectName: V:/PROJECT/houston/snapin.pj $
   $ProjectRevision: 1.172 $

   For revision information, see the history log at the end of this file.

   Copyright (c) 1997-1999 Novell, Inc.  All Rights Reserved.

   THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL,
   PROPRIETARY AND TRADE SECRET INFORMATION OF NOVELL, INC. ACCESS TO
   THIS WORK IS RESTRICTED TO (I) NOVELL, INC. EMPLOYEES WHO HAVE A
   NEED TO KNOW HOW TO PERFORM TASKS WITHIN THE SCOPE OF THEIR
   ASSIGNMENTS AND (II) ENTITIES OTHER THAN NOVELL, INC. WHO HAVE
   ENTERED INTO APPROPRIATE LICENSE AGREEMENTS. NO PART OF THIS WORK
   MAY BE USED, PRACTICED, PERFORMED, COPIED, DISTRIBUTED, REVISED,
   MODIFIED, TRANSLATED, ABRIDGED, CONDENSED, EXPANDED, COLLECTED,
   COMPILED, LINKED, RECAST, TRANSFORMED OR ADAPTED WITHOUT THE PRIOR
   WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION OF THIS WORK
   WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO CRIMINAL AND
   CIVIL LIABILITY.
*/
package com.novell.application.console.snapin;

/**
 * Defines a shell focus event.  
 * 
 * <p>This event is broadcasted when focus changes from 
 * the tree to the view or from the view to the tree.
 *
 * @see ShellSelectionListener
*/

public class ShellFocusEvent extends java.util.EventObject
{
   /**
    * @exclude
    * Focus change occured.
    *
    * <p>(FOCUS_CHANGE = 1)
    * </p>
    */
   public static final int FOCUS_CHANGE = 1;

   /**
    * Tree currently has focus.  May be returned from getFocusState().
    *
    * <p>(FOCUS_STATE_TREE = Shell.FOCUS_TREE)
    * </p>
    */
   public static final int FOCUS_STATE_TREE = Shell.FOCUS_TREE;

   /**
    * View currently has focus.  May be returned from getFocusState().
    *
    * <p>(FOCUS_STATE_VIEW = Shell.FOCUS_VIEW)
    * </p>
    */
   public static final int FOCUS_STATE_VIEW = Shell.FOCUS_VIEW;
   
   // private field variables
   private int m_id;
   private int m_focus;

   /**
   * Creates a focus changed event object.
   *
   * @param focus An integer specifying what gained focus.
   * @param id An integer specifying the action that occurred on the event.
   *
   * @see #FOCUS_CHANGE
   */
  	public ShellFocusEvent(int focus, int id)
	{
      super("FocusEvent");
      Debug.n_assert(focus == FOCUS_STATE_TREE || focus == FOCUS_STATE_VIEW, "ShellFocusEvent:constructor focus parameter must be FOCUS_STATE_TREE or FOCUS_STATE_VIEW");
      m_id = id;
      m_focus = focus;
	}

  /**
   * @exclude
   * Returns the action performed.
   *
   * @return An integer representing the action performed.
   *
   * @see #FOCUS_CHANGE
   */
	public int getID()
	{
		return m_id;
	}

   /**
    * Returns which panel in ConsoleOne currently has focus, the tree or the
    * view - (ShellEvent.FOCUS_STATE_TREE or ShellEvent.FOCUS_STATE_VIEW)
    *
    * @return The panel that has focus when this event was fired.
    */
   public int getFocusState()
   {
      return m_focus;
   }
}

/*
$Log: ShellFocusEvent.java,v $
Revision 1.1.1.1  2001/05/09 12:43:25  rommel
Sandbox initial version uploaded from novell cd 1/3

Revision 1.4  2000/07/26 16:54:46  DChamberlain
Discovered @@exclude was the right tag, changed back.
Revision 1.3  2000/06/29 19:26:38Z  DChamberlain
Changed @@exclude javadoc tag to proper @@excluded tag.
Revision 1.2  2000/01/25 19:49:38Z  DChamberlain
Updated javadoc.
Revision 1.1  1999/08/12 20:15:52  DChamberlain
Initial revision
*/
