/*
   For revision information, see the history log at the end of this file.

   Copyright (c) 1997-1999 Novell, Inc.  All Rights Reserved.

   THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL,
   PROPRIETARY AND TRADE SECRET INFORMATION OF NOVELL, INC. ACCESS TO
   THIS WORK IS RESTRICTED TO (I) NOVELL, INC. EMPLOYEES WHO HAVE A
   NEED TO KNOW HOW TO PERFORM TASKS WITHIN THE SCOPE OF THEIR
   ASSIGNMENTS AND (II) ENTITIES OTHER THAN NOVELL, INC. WHO HAVE
   ENTERED INTO APPROPRIATE LICENSE AGREEMENTS. NO PART OF THIS WORK
   MAY BE USED, PRACTICED, PERFORMED, COPIED, DISTRIBUTED, REVISED,
   MODIFIED, TRANSLATED, ABRIDGED, CONDENSED, EXPANDED, COLLECTED,
   COMPILED, LINKED, RECAST, TRANSFORMED OR ADAPTED WITHOUT THE PRIOR
   WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION OF THIS WORK
   WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO CRIMINAL AND
   CIVIL LIABILITY.
*/

package com.novell.application.console.snapin.context;

import com.novell.application.console.snapin.*;

/**
 * Contains information about the state of the Object Browser window
 * on calls to the getView() method.
 *
 * <p>A ViewSnapinContext object is used by a View snap-in to obtain
 * context information about the state of the Object Browser window
 * upon calls to the ViewSnapin getView() method. The getView()
 * method is called with a ViewSnapinContext parameter. Calling the
 * ViewSnapinContext getObjectEntry() method returns the currently
 * selected ObjectEntry in the Object Browser window for which a view
 * is needed.</p>
 * <p>Note: The current Object Browser context is also stored in the
 * InitSnapin <i>info</i> parameter supplied to the initSnapin() method
 * during ViewSnapin initalization.  A call to the getSnapinContext()
 * method will return a valid ViewSnapinContext for that point in time.
 * But the context can change between initialization and the call to
 * the getView() method. Therefore, the context should be obtained from
 * the ViewSnapinContext parameter supplied in the getView() call and
 * not from the context provided during initialization.</p>
 *
 * @see com.novell.application.console.snapin.ViewSnapin#getView(ViewSnapinContext)
 */
public class ViewSnapinContext extends SnapinContext
{
   /**
   * @internal
   */
   protected ObjectEntry objectEntry = null;
   protected ResultModifier resultModifier = null;
	protected Shell shell = null;

   /**
   * @internal
   */
   public ViewSnapinContext(ObjectEntry objectEntry, ResultModifier resultModifier)
   {
      this.objectEntry = objectEntry;
      this.resultModifier = resultModifier;
   }

   /**
   * @internal
   */
   public ViewSnapinContext(ObjectEntry objectEntry)
   {
      this(objectEntry, null);
   }

   /**
   * @internal
   */
   public void setObjectEntry(ObjectEntry objectEntry)
   {
      this.objectEntry = objectEntry;
   }

   /**
   * @internal
   */
   public void setResultModifier(ResultModifier resultModifier)
   {
      this.resultModifier = resultModifier;
   }

   /**
   * @internal
   */
	public void setShell(Shell shell)
	{
		this.shell = shell;
	}

   /**
   * @internal
   */
	public Shell getShell()
	{
		return shell;
	}

   /**
   * Returns the currently selected ObjectEntry in the Object Browser
   * window for which a view is needed.
   *
   * @return The currently selected ObjectEntry.
   *
   */
   public ObjectEntry getObjectEntry()
   {
      return objectEntry;
   }

   /**
   * Returns the current result modifier being applied to this view.
   *
   * @return The current resultModifier.
   *
   */
   public ResultModifier getResultModifier()
   {
      return resultModifier;
   }

   /**
   * @internal
   */
   public void promote(ObjectEntry oe)
   {
      shell.promote(oe);
   }

   /**
   * @internal
   */
	public void setContainerSelection(ObjectEntry oe)
	{
      shell.setTreeSelection(oe);
	}

   /**
   * @internal
   */
	public ObjectEntry getContainerSelection()
	{
		return shell.getTreeSelection();
	}
}

/*
$Log: ViewSnapinContext.java,v $
Revision 1.1.1.1  2001/05/09 12:43:27  rommel
Sandbox initial version uploaded from novell cd 1/3

Revision 1.18  1999/01/07 19:22:02  DChamberlain
Updated copyright to include 1999.
Revision 1.17  1998/12/21 21:39:42  JWilliams
Doc review
Revision 1.16  1998/12/18 01:05:08  DChamberlain
Cleaned up docs.
Revision 1.15  1998/11/10 01:27:27  mharris
Added a constructor which takes a result modifier.
Revision 1.14  1998/09/24 20:42:13  DChamberlain
Fixed bug in promote.
Revision 1.13  1998/09/24 20:18:18  DChamberlain
Added promote.
Revision 1.12  1998/06/16 20:48:58  SHerrin
Added @internal flag to new methods.
Revision 1.11  1998/06/11 17:58:51  ksondere
Added setShell, getShell, getContainerSelection, setContainerSelection
Revision 1.8  1998/05/12 22:49:23  SHerrin
Added information from Mike Harris to Javadoc comments.
Revision 1.7  1998/04/07 17:22:23  DChamberlain
Cleaned up docs.
Revision 1.6  1998/04/06 17:55:55  SHerrin
Added Javadoc comments.
Revision 1.5  1998/04/01 17:35:38  SHerrin
Edited Javadoc comments.
Revision 1.4  1998/03/20 01:57:27  DChamberlain
Bug fix, added constructor first line, seems to have been deleted.
*/

