<!--
//   Name:  ConfigurationStoreExampleTemplate.jsp
//
//   Copyright (c) 1997-2004 Novell, Inc.  All Rights Reserved.
//
//   THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND TREATIES.
//   USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE AGREEMENT
//   ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS THIS WORK.
//   PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO DEVELOPER A
//   ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE CODE IN ITS
//   PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS TO MARKET,
//   DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF DEVELOPER'S
//   PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR DEVELOPER'S
//   CUSTOMERS WITH RESPECT TO THIS CODE.
-->

<%@ page import="com.novell.emframe.fw.LookAndFeelDefaults"%>
<%@  page pageEncoding="utf-8" contentType="text/html;charset=utf-8" %>

<%@ taglib uri="/WEB-INF/iman.tld" prefix="iman" %>
<%@ taglib uri="/WEB-INF/c.tld" prefix="c" %>
<%@ taglib uri="/WEB-INF/x.tld" prefix="x" %>

<iman:stringtable bundle="DevResources"/>
<iman:stringtable bundle="FwResources"/>

<HTML>
<HEAD>
   <TITLE><iman:string key="ProductName"/></TITLE>
   <LINK rel="stylesheet" href="<c:out value="${ContextPath}" />/portal/modules/dev/css/hf_style.css">
   <iman:eMFrameScripts/>

   <script>
      function save()
      {
         document.form.submit();
      }
   </script>

</HEAD>

<BODY>
<FORM name="form">
   <INPUT type="hidden" name="taskId" value="<c:out value="${taskId}"/>">
   <INPUT type="hidden" name="nextState" value="save">

   <iman:taskHeader title="Configuration Store Example"/>

   The configuration store can be used to store systemwide settings as well as user-specific settings. This example illustrates the use of the SystemConfig object, found in the dev.config package in iManager.
   <br/>
   <br/>
   The following values are read from the configuration store when this task runs and are written to the configuration store when the "OK" button is clicked. To view the Java code for reading from and writing to the configuration store, see the ConfigurationStoreExampleTask.java file in the iManagerSamples area of the SDK.
   <br/>
   <br/>
   Your name:
   <br/>
   <input type="text" name="ConfigurationExample_Name" value="<c:out value="${ConfigurationExample_Name}"/>" size="30"/>
   <br/>
   <br/>
   Your favorite color:
   <br/>
   <input type="text" name="ConfigurationExample_Color" value="<c:out value="${ConfigurationExample_Color}"/>" size="30"/>
   <BR/><BR/>
   <iman:bar/>
   <iman:button key="OK" onClick="save()"/>
   <iman:cancelBtn/>
</BODY>
</HTML>
