<?xml version="1.0"?>
<!--

  xsl-xslt-converter.xslt
  
  Stylesheet for transforming Microsoft Internet Explorer 5 XSL
  to W3C-compliant XSLT for use in the Microsoft Jan 2000 MSXML
  Web Release.  See http://msdn.microsoft.com/xml.
  
  Author: Jonathan Marsh <jmarsh@microsoft.com>
  Copyright 2000 Microsoft Corp.
  
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
                xmlns:oldxsl="http://www.w3.org/TR/WD-xsl"
>
                
<!-- <xsl:output method="xml" omit-xml-declaration="yes"/> -->
<xsl:output method="xml"/>

<xsl:template match="processing-instruction('xml')"/>

<xsl:template match="/">
  <xsl:apply-templates select="@*|node()|oldxsl:stylesheet"/>
</xsl:template>
  
<xsl:template match="oldxsl:stylesheet">
  <xsl:element name="xsl:stylesheet">
    <xsl:attribute name="version">1.0</xsl:attribute>
    <xsl:apply-templates select="@*"/>
<!--    <xsl:element name="xsl:output">
      <xsl:attribute name="method">xml</xsl:attribute>
      <xsl:attribute name="indent">yes</xsl:attribute>
      <xsl:attribute name="omit-xml-declaration">yes</xsl:attribute>
    </xsl:element>
    <xsl:text xml:space="preserve">
  
  </xsl:text>
    <xsl:comment> [XSL-XSLT] Simulate lack of built-in templates </xsl:comment>
    <xsl:text xml:space="preserve">
  </xsl:text>
-->
<!--    <xsl:element name="xsl:template">
      <xsl:attribute name="match">@*|/|node()</xsl:attribute>
    </xsl:element>
    <xsl:text xml:space="preserve">
	</xsl:text>
-->
    <xsl:apply-templates select="node()"/>
    
    <xsl:text xml:space="preserve">
  </xsl:text>

</xsl:element>

</xsl:template>

<xsl:template match="node()">
  <xsl:copy>
    <xsl:apply-templates select="@*|node()"/>
  </xsl:copy>
</xsl:template>

<xsl:template match="@*">
  <xsl:copy>
    <xsl:apply-templates select="@*|node()"/>
  </xsl:copy>
</xsl:template>



<xsl:template match="xsl:stylesheet/@indent-result"/>
<xsl:template match="oldxsl:script"/>

<xsl:template match="oldxsl:eval">
  <xsl:comment> [XSL-XSLT] Converted xsl:eval to xsl:value-of </xsl:comment>
  <xsl:element name="xsl:value-of">
    <xsl:if test="@no-entities">
      <xsl:attribute name="disable-output-escaping">yes</xsl:attribute>
    </xsl:if>
    <xsl:attribute name="select">local:eval_<xsl:value-of select="local:xtlruntime_uniqueID(.)"/>(.)</xsl:attribute>
  </xsl:element>
</xsl:template>

<xsl:template match="oldxsl:template">
  <xsl:element name="xsl:template">
    <xsl:if test="not(@match)"><xsl:attribute name="match">@*|/|node()</xsl:attribute></xsl:if>
    <xsl:apply-templates select="@*|node()"/>
  </xsl:element>
  <xsl:apply-templates select=".//oldxsl:template" mode="nested"/>
</xsl:template>
<xsl:template match="oldxsl:template" mode="nested">
    <xsl:text xml:space="preserve">
  </xsl:text>
  <xsl:comment> [XSL-XSLT] Converted nested template to a mode </xsl:comment>
  <xsl:element name="xsl:template">
    <xsl:if test="not(@match)"><xsl:attribute name="match">@*|/|node()</xsl:attribute></xsl:if>
    <xsl:attribute name="mode">mode_<xsl:value-of select="local:xtlruntime_uniqueID(..)"/></xsl:attribute>
    <xsl:apply-templates select="@*|node()"/>
  </xsl:element>
</xsl:template>

<xsl:template match="oldxsl:for-each">
  <xsl:element name="xsl:for-each">
    <xsl:apply-templates select="@*"/>
    <xsl:if test="@order-by">
      <xsl:variable name="orderByString" select="@order-by"/>
       <xsl:element name="xsl:sort">
          <xsl:attribute name="select"><xsl:value-of select="$orderByString"/></xsl:attribute>
        </xsl:element>
    </xsl:if>
    <xsl:apply-templates select="node()"/>
  </xsl:element>
</xsl:template>
<xsl:template match="@order-by"/>

<xsl:template match="oldxsl:value-of">
  <xsl:element name="xsl:value-of">
    <xsl:if test="not(@select)"><xsl:attribute name="select">.</xsl:attribute></xsl:if>
    <xsl:apply-templates select="@*|node()"/>
  </xsl:element>
</xsl:template>

<xsl:template match="oldxsl:apply-templates">
  <xsl:element name="xsl:apply-templates">
    <xsl:apply-templates select="@*"/>
    <xsl:if test="@order-by">
      <xsl:variable name="orderByString" select="@order-by"/>
    </xsl:if>
  </xsl:element>
</xsl:template>

<xsl:template match="oldxsl:if">
  <xsl:element name="xsl:if">
    <xsl:choose>
      <xsl:when test="@test">
        <xsl:attribute name="test"><xsl:value-of select="@test"/></xsl:attribute>
      </xsl:when>
      <xsl:otherwise>
        <xsl:attribute name="test">node()|@*</xsl:attribute>    
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates select="@*|node()"/>
  </xsl:element>
</xsl:template>

<xsl:template match="oldxsl:choose">
  <xsl:element name="xsl:choose">
    <xsl:apply-templates select="@*|node()"/>
  </xsl:element>
</xsl:template>

<xsl:template match="oldxsl:when">
  <xsl:element name="xsl:when">
    <xsl:choose>
      <xsl:when test="@test">
        <xsl:attribute name="test"><xsl:value-of select="@test"/></xsl:attribute>
      </xsl:when>
      <xsl:otherwise>
        <xsl:attribute name="test">node()|@*</xsl:attribute>    
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates select="@*|node()"/>
  </xsl:element>
</xsl:template>
<xsl:template match="@test"/>
<xsl:template match="@expr"/>

<xsl:template match="oldxsl:otherwise">
  <xsl:element name="xsl:otherwise">
    <xsl:apply-templates select="@*|node()"/>
  </xsl:element>
</xsl:template>

<xsl:template match="oldxsl:copy">
  <xsl:element name="xsl:copy">
    <xsl:apply-templates select="@*|node()"/>
  </xsl:element>
</xsl:template>

<xsl:template match="oldxsl:element">
  <xsl:element name="xsl:element">
    <xsl:apply-templates select="@*|node()"/>
  </xsl:element>
</xsl:template>

<xsl:template match="oldxsl:attribute">
  <xsl:element name="xsl:attribute">
    <xsl:apply-templates select="@*|node()"/>
  </xsl:element>
</xsl:template>

<xsl:template match="oldxsl:pi">
  <xsl:element name="xsl:processing-instruction">
    <xsl:apply-templates select="@*"/>
    <xsl:comment> [XSL-XSLT] Renamed xsl:pi to xsl:processing-instruction </xsl:comment>
    <xsl:apply-templates select="node()"/>
  </xsl:element>
</xsl:template>

<xsl:template match="oldxsl:pi[@name='xml']">
  <xsl:comment> [XSL-XSLT] Cannot create the XML declaration using xsl:processing-instruction.  Use xsl:output instead. </xsl:comment>
</xsl:template>

<xsl:template match="oldxsl:comment">
  <xsl:element name="xsl:comment">
    <xsl:apply-templates select="@*|node()"/>
  </xsl:element>
</xsl:template>

<xsl:template match="oldxsl:node-name">
  <xsl:comment> [XSL-XSLT] Converted xsl:node-name to xsl:value-of </xsl:comment>
  <xsl:element name="xsl:value-of">
    <xsl:attribute name="select">name()</xsl:attribute>
  </xsl:element>
</xsl:template>

<xsl:template match="oldxsl:entity-ref">
  <xsl:comment> [XSL-XSLT] Converted xsl:entity-ref to xsl:text </xsl:comment>
  <xsl:element name="xsl:text">
    <xsl:attribute name="disable-output-escaping">yes</xsl:attribute>
    <xsl:text>&amp;</xsl:text>
    <xsl:value-of select="@name|text()"/>
    <xsl:text>;</xsl:text>
  </xsl:element>
</xsl:template>

<xsl:template match="@match | @select | @test">
  <xsl:copy>
    <xsl:apply-templates select="." mode="content-only">
      <xsl:with-param name="XPath" select="string(.)"/>
    </xsl:apply-templates>
  </xsl:copy>
</xsl:template>

<xsl:template match="@match | @select | @test" mode="content-only">
  <xsl:param name="XPath"/>
  <xsl:choose>
    <!-- BUGBUG contains seems broken -->
    <xsl:when test="local:contains(string($XPath),'nodeName()')">
      <xsl:apply-templates select="." mode="content-only">
        <xsl:with-param name="XPath" select="concat(substring-before(string($XPath),'nodeName()'), 'name()', substring-after(string($XPath),'nodeName()'))"/>
      </xsl:apply-templates>
    </xsl:when>
    <xsl:when test="local:contains(string($XPath),'index()')">
      <xsl:apply-templates select="." mode="content-only">
        <xsl:with-param name="XPath" select="concat(substring-before(string($XPath),'index()'), 'position()', substring-after(string($XPath),'index()'))"/>
      </xsl:apply-templates>
    </xsl:when>
    <xsl:when test="local:contains(string($XPath),'not(end())')">
      <xsl:apply-templates select="." mode="content-only">
        <xsl:with-param name="XPath" select="concat(substring-before(string($XPath),'not(end())'), 'position()!=last()', substring-after(string($XPath),'not(end())'))"/>
      </xsl:apply-templates>
    </xsl:when>
    <xsl:when test="local:contains(string($XPath),'end()')">
      <xsl:apply-templates select="." mode="content-only">
        <xsl:with-param name="XPath" select="concat(substring-before(string($XPath),'end()'), 'position()=last()', substring-after(string($XPath),'end()'))"/>
      </xsl:apply-templates>
    </xsl:when>
    <xsl:when test="local:contains(string($XPath),'$gt$')">
      <xsl:apply-templates select="." mode="content-only">
        <xsl:with-param name="XPath" select="concat(substring-before(string($XPath),'$gt$'), '&gt;', substring-after(string($XPath),'$gt$'))"/>
      </xsl:apply-templates>
    </xsl:when>
    <xsl:when test="local:contains(string($XPath),'$lt$')">
      <xsl:apply-templates select="." mode="content-only">
        <xsl:with-param name="XPath" select="concat(substring-before(string($XPath),'$lt$'), '&lt;', substring-after(string($XPath),'$lt$'))"/>
      </xsl:apply-templates>
    </xsl:when>
    <xsl:when test="local:contains(string($XPath),'$ge$')">
      <xsl:apply-templates select="." mode="content-only">
        <xsl:with-param name="XPath" select="concat(substring-before(string($XPath),'$ge$'), '&gt;=', substring-after(string($XPath),'$ge$'))"/>
      </xsl:apply-templates>
    </xsl:when>
    <xsl:when test="local:contains(string($XPath),'$le$')">
      <xsl:apply-templates select="." mode="content-only">
        <xsl:with-param name="XPath" select="concat(substring-before(string($XPath),'$le$'), '&lt;=', substring-after(string($XPath),'$le$'))"/>
      </xsl:apply-templates>
    </xsl:when>
    <xsl:when test="local:contains(string($XPath),'$eq$')">
      <xsl:apply-templates select="." mode="content-only">
        <xsl:with-param name="XPath" select="concat(substring-before(string($XPath),'$eq$'), '=', substring-after(string($XPath),'$eq$'))"/>
      </xsl:apply-templates>
    </xsl:when>
    <xsl:when test="local:contains(string($XPath),'$ne$')">
      <xsl:apply-templates select="." mode="content-only">
        <xsl:with-param name="XPath" select="concat(substring-before(string($XPath),'$ne$'), '!=', substring-after(string($XPath),'$ne$'))"/>
      </xsl:apply-templates>
    </xsl:when>
    <xsl:when test="local:contains(string($XPath),'$and$')">
      <xsl:apply-templates select="." mode="content-only">
        <xsl:with-param name="XPath" select="concat(substring-before(string($XPath),'$and$'), ' and ', substring-after(string($XPath),'$and$'))"/>
      </xsl:apply-templates>
    </xsl:when>
    <xsl:when test="local:contains(string($XPath),'$or$')">
      <xsl:apply-templates select="." mode="content-only">
        <xsl:with-param name="XPath" select="concat(substring-before(string($XPath),'$or$'), ' or ', substring-after(string($XPath),'$or$'))"/>
      </xsl:apply-templates>
    </xsl:when>
    <xsl:when test="local:contains(string($XPath),'$any$')">
      <xsl:apply-templates select="." mode="content-only">
        <xsl:with-param name="XPath" select="concat(substring-before(string($XPath),'$any$'), '', substring-after(string($XPath),'$any$'))"/>
      </xsl:apply-templates>
    </xsl:when>
    <xsl:when test="local:contains(string($XPath),'&amp;&amp;')">
      <xsl:apply-templates select="." mode="content-only">
        <xsl:with-param name="XPath" select="concat(substring-before(string($XPath),'&amp;&amp;'), ' and ', substring-after(string($XPath),'&amp;&amp;'))"/>
      </xsl:apply-templates>
    </xsl:when>
    <xsl:when test="local:contains(string($XPath),'||')">
      <xsl:apply-templates select="." mode="content-only">
        <xsl:with-param name="XPath" select="concat(substring-before(string($XPath),'||'), ' or ', substring-after(string($XPath),'||'))"/>
      </xsl:apply-templates>
    </xsl:when>
    <xsl:when test="local:contains(string($XPath),'context()')">
      <xsl:apply-templates select="." mode="content-only">
        <xsl:with-param name="XPath" select="concat(substring-before(string($XPath),'context()'), 'current()', substring-after(string($XPath),'context()'))"/>
      </xsl:apply-templates>
    </xsl:when>
    <xsl:when test="local:contains(string($XPath),'context(-1)')">
      <xsl:apply-templates select="." mode="content-only">
        <xsl:with-param name="XPath" select="concat(substring-before(string($XPath),'context(-1)'), 'current()', substring-after(string($XPath),'context(-1)'))"/>
      </xsl:apply-templates>
    </xsl:when>
    <xsl:when test="local:contains(string($XPath),'pi(')">
      <xsl:apply-templates select="." mode="content-only">
        <xsl:with-param name="XPath" select="concat(substring-before(string($XPath),'pi('), 'processing-instruction(', substring-after(string($XPath),'pi('))"/>
      </xsl:apply-templates>
    </xsl:when>
    <xsl:when test="local:contains(string($XPath),'textnode()')">
      <xsl:apply-templates select="." mode="content-only">
        <xsl:with-param name="XPath" select="concat(substring-before(string($XPath),'textnode()'), 'node()[xql:textNode(.)]', substring-after(string($XPath),'textnode()'))"/>
      </xsl:apply-templates>  
      <xsl:value-of select="local:usedXQL()"/>
    </xsl:when>
    <xsl:when test="local:contains(string($XPath),'textNode()')">
      <xsl:apply-templates select="." mode="content-only">
        <xsl:with-param name="XPath" select="concat(substring-before(string($XPath),'textNode()'), 'node()[xql:textNode(.)]', substring-after(string($XPath),'textNode()'))"/>
      </xsl:apply-templates>
      <xsl:value-of select="local:usedXQL()"/>
    </xsl:when>
    <xsl:when test="local:contains(string($XPath),'cdata()')">
      <xsl:apply-templates select="." mode="content-only">
        <xsl:with-param name="XPath" select="concat(substring-before(string($XPath),'cdata()'), 'node()[xql:cdata(.)]', substring-after(string($XPath),'cdata()'))"/>
      </xsl:apply-templates>
      <xsl:value-of select="local:usedXQL()"/>
    </xsl:when>
    <xsl:when test="local:contains(string($XPath),'nodeType()')">
      <xsl:apply-templates select="." mode="content-only">
        <xsl:with-param name="XPath" select="concat(substring-before(string($XPath),'nodeType()'), 'xql:nodeType(.)', substring-after(string($XPath),'nodeType()'))"/>
      </xsl:apply-templates>
      <xsl:value-of select="local:usedXQL()"/>
    </xsl:when>
    <xsl:when test="local:contains(string($XPath),'element()')">
      <xsl:apply-templates select="." mode="content-only">
        <xsl:with-param name="XPath" select="concat(substring-before(string($XPath),'element()'), 'xql:element(.)', substring-after(string($XPath),'element()'))"/>
      </xsl:apply-templates>
      <xsl:value-of select="local:usedXQL()"/>
    </xsl:when>
    <xsl:when test="local:contains(string($XPath),'attribute()')">
      <xsl:apply-templates select="." mode="content-only">
        <xsl:with-param name="XPath" select="concat(substring-before(string($XPath),'attribute()'), 'xql:attribute(.)', substring-after(string($XPath),'attribute()'))"/>
      </xsl:apply-templates>
      <xsl:value-of select="local:usedXQL()"/>
    </xsl:when>
    <xsl:otherwise><xsl:value-of select="local:updateIndexes(string($XPath))"/></xsl:otherwise>
  </xsl:choose>
</xsl:template>

  <msxsl:script implements-prefix="local"><![CDATA[
    var usesXQLlibrary = false;
    
    function usedXQL()
    {
      usesXQLlibrary = true;
      return "";
    }

    function needsXQL()
    {
      return usesXQLlibrary;
    }
    
    function countSortCriteria(sortString)
    {
      return sortString.split(";").length + 1;
    }
    
    function splitSortCriteria(sortString, position)
    {
      var criteriaN = sortString.split(";")[position - 1];
      while (criteriaN.charAt(0) == '+' || criteriaN.charAt(0) == '-' || criteriaN.charAt(0) == ' ')
      {
        criteriaN = criteriaN.substring(1);
      }
      return criteriaN;
    }
    
    function splitSortDirection(sortString, position)
    {
      var criteriaN = sortString.split(";")[position - 1];
      while (criteriaN.charAt(0) == '+' || criteriaN.charAt(0) == '-' || criteriaN.charAt(0) == ' ')
      {
        if (criteriaN.charAt(0) == '+') return "ascending";
        if (criteriaN.charAt(0) == '-') return "descending";
      }
      return "";
    }
    
    function contains(s, sub)
    {
      return (s.indexOf(sub) >= 0);
    }

    function replaceToken(s, token, newToken)
    {
      var re = new RegExp(token, "g");
      return s.replace(re,newToken);
    }
    
    function updateIndexes(s)
    {
      var s = s.replace(/(\[9\])/g, "[10]");
      var s = s.replace(/(\[8\])/g, "[9]");
      var s = s.replace(/(\[7\])/g, "[8]");
      var s = s.replace(/(\[6\])/g, "[7]");
      var s = s.replace(/(\[5\])/g, "[6]");
      var s = s.replace(/(\[4\])/g, "[5]");
      var s = s.replace(/(\[3\])/g, "[4]");
      var s = s.replace(/(\[2\])/g, "[3]");
      var s = s.replace(/(\[1\])/g, "[2]");
      var s = s.replace(/(\[0\])/g, "[1]");
      
      return s;
    }
    
    function absoluteChildNumber(pNode)
    {
      var n = 1;
      while (pNode = pNode.previousSibling)
        n++;
      return n;
    }
    function xtlruntime_absoluteChildNumber(pNodeList)
    {
      if (pNodeList)
        return absoluteChildNumber(pNodeList.item(0));
      else
        return "";
    }
  

    // Note that this now returns a string instead of a number
    function uniqueID(pNode)
    {
      if (pNode)
      {
        if (pNode.nodeType == 2)
          return uniqueID(pNode.selectSingleNode("..")) + "_" + pNode.nodeName;
        else if (pNode.parentNode)
          return uniqueID(pNode.parentNode) + "_" + absoluteChildNumber(pNode);
        else
          return absoluteChildNumber(pNode);
      }
      return "";
    }
    function xtlruntime_uniqueID(pNodeList)
    {
      if (pNodeList)
        return uniqueID(pNodeList.item(0));
      else
        return "";
    }

  ]]></msxsl:script>

</xsl:stylesheet>