<%@  page pageEncoding="utf-8" contentType="text/html;charset=utf-8" import="com.novell.webaccess.common.JSPConduit, com.novell.emframe.dev.eMFrameUtils" %>

<%@ taglib uri="/WEB-INF/iman.tld" prefix="iman" %>
<%@ taglib uri="/WEB-INF/fmt.tld" prefix="fmt" %>
<%@ taglib uri="/WEB-INF/c.tld" prefix="c" %>
<%@ taglib uri="/WEB-INF/x.tld" prefix="x" %>
<iman:stringtable bundle="DevResources" />
<iman:stringtable bundle="FwResources" />
<%
   JSPConduit c = JSPConduit.getJSPConduit(request);
   c.stringTable("FwResources");
   c.stringTable("BaseResources");
%>


<%-- Empty xml, since we don't have an object to read --%>
<x:parse xml="<edas></edas>" var="edasXml"/>

<HTML>
<HEAD>
   <TITLE><iman:string key="ProductName"/></TITLE>
   <iman:stylesheet/>
   <iman:uihandlerTools/>

   <iman:eMFrameScripts/>
   <iman:validateNumberScripts/>
   <iman:mvedScripts/>
   <iman:osScripts/>
   <iman:dialogScripts/>

   <SCRIPT>
      function onInit()
      {
         var form = document.forms[0];
         form._cn.focus();
         returnFromOS();
      }

      function onExit()
      {
         var form=document.forms[0];

         var success = notifyAllOfExit();
         if(!success)
         {
            return false;
         }
         if(form.eDir$target$cn.value.indexOf('<value')<0)
         {
            alert(formatMessage("<iman:string key="General.provideMandatoryAttribute"/>", ["<%= eMFrameUtils.toScript(c.formatMessage(c.string("Creator.NamePrompt"), new String[]{c.var("TranslatedClass")} ) )%>"]));
            return false;
         }

         if(form.eDir$target$uid.value.indexOf('<value')<0)
         {
            alert(formatMessage("<iman:string key="General.provideMandatoryAttribute"/>", ["<iman:toScript><iman:string key="Attribute.uid"/></iman:toScript>"]));
            return false;
         }
         if(form.eDir$target$sn.value.indexOf('<value')<0)
         {
            alert(formatMessage("<iman:string key="General.provideMandatoryAttribute"/>", ["<iman:toScript><iman:string key="Attribute.sn"/></iman:toScript>"]));
            return false;
         }



         var containerInput = document.form.eDir$target$createContext.value;
         var radioButton = (form.eDir$target$createContext[0] && form.eDir$target$createContext[0].type == "radio");
         if(!radioButton)
         {
            if ((containerInput==null) || (containerInput.length==0))
            {
               alert("<iman:string key="Creator.InvalidContainerName"/>");
               return false;
            }
         }

         if (document.form.edirpassword.value != document.form.retypepassword.value)
         {
            alert("<%= c.string("CreateUser.PassDontMatch") %>");
            document.form.edirpassword.focus();
            return false;
         }

         if (document.form.edirpassword.value.length == 0)
         {
            activateImanDialog('checkPassword');
            return false;

<%--            var message = "<%= c.toScript(c.string("CreateUser.PasswordAlert")) %>";--%>
<%--            if (!confirm(message))--%>
<%--            {--%>
<%--               document.form.edirpassword.focus();--%>
<%--               return false;--%>
<%--            }--%>
         }

         return true;
      }

      function submitForm()
      {
         document.form.submit();
      }


      var ENABLED_COLOR = "white";
      var DISABLED_COLOR = "#EFEEE9";

      function enableTemplate(control)
      {
         with(document.forms[0])
         {
            var tf = eDir$target$createSourceObjectForClone;
            if (control.checked == true)
            {
               tf.disabled = false;
               tf.style.backgroundColor = ENABLED_COLOR;
            }
            else
            {
               tf.disabled = true;
               tf.value = "";
               tf.style.backgroundColor = DISABLED_COLOR;
            }
         }
      }

	   function checkDefaultKey(evt)
      {
         var form = document.forms[0];
         var keyCode = evt.which ? evt.which : evt.keyCode;
         // 13 is the Enter key code
         if (keyCode == 13)
         {
            if(onExit() != false)
            {
               document.forms[0].submit();
               return false;
            }
         }
         return true;
      }
   </SCRIPT>
</HEAD>


<body onLoad="onInit();">
<FORM name="form" method="post" action="webacc" onSubmit="onExit();">

   <!---- EDAS and System Variables ---->
   <INPUT type=hidden name="taskId" value="<c:out value="${taskId}"/>">
   <INPUT type=hidden name="eDirCommand" value="create">
   <INPUT type=hidden name="merge" value="dev.GenConf">
   <INPUT type=hidden name="error" value="dev.GenErr">
   <INPUT type=hidden name="nextState" value="eDasServiceAccess">
   <INPUT type=hidden name="eDir$target$createClassName" value="<c:out value="${createClassName}"/>">
   <input type=hidden name="TranslatedClass" value="<%= c.var("TranslatedClass") %>">
   <input type=hidden name="GifName" value="<%= c.var("GifName") %>">
   <input type=hidden name="targetNames" value="<%= c.var("targetNames") %>">

   <c:set var="eDirCommandString" value="create" />

   <!---- Shared Form Code ---->

   <%
      c.set("TaskHeader.title", c.formatMessage(c.string("Creator.Create"), new String[]{c.var("TranslatedClass")}));
      c.set("TaskHeader.iconUrl", c.plus("dir/", c.var("GifName")));
      c.set("TaskHeader.iconAlt", c.var("TranslatedClass"));

   %>
   <jsp:include page='<%= c.getPath("dev/TaskHeader_inc.jsp") %>' flush="true" />

   <!---- UI Created by UiHandlers ---->
   <TABLE class="mediumtext" border="0" bgcolor="#FFFFFF" cellpadding="0" cellspacing="0">



   <TR><TD height="27"></TD></TR>

   <%-- cn --%>
   <TR>
      <TD align="left">
         <%= c.string("LDAPName")%>:&nbsp;
      </TD>
      <TD>
         <c:if test="${edasRights.target.cn.writeable}">
            <INPUT type="hidden" name="eDir$target$cn" value="<c:out value="${eDir$target$cn}" escapeXml="false"/>">
         </c:if>
         <INPUT type="text" name="_cn" id="spinner_cn" value="<x:out select="$edasXml/edas/cn/value"/>" size=<iman:string key="UI.textboxSize"/> style="width:<iman:string key="UI.textboxPixel"/>"  maxlength=64 onChange='return validateLengthField(this, 1, 64); postUiHandlerEvent("cn", "change")'<c:if test="${!edasRights.target.cn.writeable}">DISABLED</c:if> onkeypress="return checkDefaultKey(event)"  >
      </TD>
      <TD valign="top">
         <c:set var="mode"><x:out select="$edasXml/edas/cn/@mode"/></c:set>
         <iman:mooMode name="_cn_mode" value="${mode}" multi="true" />
      </TD>
   </TR>
   <SCRIPT>
      window.uiObject_cn = new UiObject();
      <c:if test="${edasRights.target.cn.writeable}">
         addToNotificationList('cn', 'uih_textfield');
         addActionHandler('cn', 'uiah_textfield');
      </c:if>
   </SCRIPT>
   <SCRIPT>
      window.uiObject_cn.m_lowerBound = 1;
      window.uiObject_cn.m_upperBound = 64;
      window.uiObject_cn.m_type = "string";
   </SCRIPT>
   <TR><TD height="9"></TD></TR>

   <%-- uid --%>
   <TR>
      <TD align="left">
         <%= eMFrameUtils.toScript(c.string("Attribute.uid"))%>:&nbsp;
      </TD>
      <TD>
         <c:if test="${edasRights.target.uid.writeable}">
            <INPUT type="hidden" name="eDir$target$uid" value="<c:out value="${eDir$target$uid}" escapeXml="false"/>">
         </c:if>
         <INPUT type="text" name="_uid" id="spinner_uid" value="<x:out select="$edasXml/edas/uid/value"/>" maxlength="64" size=<iman:string key="UI.textboxSize"/> style="width:<iman:string key="UI.textboxPixel"/>"  <c:if test="${!edasRights.target.uid.writeable}">DISABLED</c:if> onkeypress="return checkDefaultKey(event)"  >
      </TD>
      <TD valign="top">
         <c:set var="mode"><x:out select="$edasXml/edas/uid/@mode"/></c:set>
         <iman:mooMode name="_uid_mode" value="${mode}" multi="true" />
      </TD>
   </TR>
   <SCRIPT>
      window.uiObject_uid = new UiObject();
      <c:if test="${edasRights.target.uid.writeable}">
         addToNotificationList('uid', 'uih_textfield');
         addActionHandler('uid', 'uiah_textfield');
      </c:if>
   </SCRIPT>
   <SCRIPT>
      window.uiObject_uid.m_lowerBound = null;
      window.uiObject_uid.m_upperBound = null;
      window.uiObject_uid.m_type = "string";
   </SCRIPT>
   <TR><TD height="9"></TD></TR>

   <%-- sn --%>
   <TR>
      <TD align="left" >
         <%= eMFrameUtils.toScript(c.string("Attribute.sn"))%>:&nbsp;
      </TD>
      <TD>
         <c:if test="${edasRights.target.sn.writeable}">
            <INPUT type="hidden" name="eDir$target$sn" value="<c:out value="${eDir$target$sn}" escapeXml="false"/>">
         </c:if>
         <x:set var="MVStringEditor_xmlNodeSet" select="$edasXml/edas/sn" scope="request"/>
         <iman:mved readonly="${!edasRights.target.sn.writeable}" enforceUnique="true" name="_sn"         />
      </TD>
      <TD valign="top">
         <c:set var="mode"><x:out select="$edasXml/edas/sn/@mode"/></c:set>
         <iman:mooMode name="_sn_mode" value="${mode}" multi="true" />
      </TD>
   </TR>
   <SCRIPT>
      window.uiObject_sn = new UiObject();
      <c:if test="${edasRights.target.sn.writeable}">
         addToNotificationList('sn', 'uih_mvStringEditor');
      </c:if>
   </SCRIPT>
   <TR><TD height="9"></TD></TR>


   <%-- context --%>
   <TR>
      <TD><iman:string key="Creator.Context"/></TD>
      <TD>
         <INPUT type=text name="eDir$target$createContext" value="<%= eMFrameUtils.getSingleTarget(request) %>" size="<iman:string key="UI.textboxSize"/>" style="width:<iman:string key="UI.textboxPixel"/>" maxlength="256" onkeypress="return checkDefaultKey(event)">
         <iman:os typeFilter="${CreatorSearchFilter}" control="eDir$target$createContext" history="true"/>
      </TD>
   </TR>
   <SCRIPT>
      window.uiObject_context = new UiObject();
      <c:if test="${true}">
      </c:if>
   </SCRIPT>
   <TR><TD height="9"></TD></TR>
   <TR><TD height="9"></TD></TR>


   <%-- -------------------------- --%>
   <%-- pop up dialog for password --%>
   <%-- -------------------------- --%>
  <TR>
    <TD colspan="2" class="smalltext2d">
      <iman:dialog id="checkPassword" title='<%= c.string("CreateUser.PasswordPopupTitle") %>' width="400" height="190" dialogColor="efeeec" titleBarColor="458ab9">
      <div class="marginleft1 instructions"><b><%= c.string("CreateUser.PasswordPopupInstruction") %></b></div>
      <div class="marginleft2 margintop3"><input type="radio" name="blankPassword" value="true" checked="checked"><label><%= c.string("CreateUser.PasswordPopupBlankPassword") %></label></div>
      <div class="marginleft2 margintop1"><input type="radio" name="blankPassword" value="false" ><label><%= c.string("CreateUser.PasswordPopupNoPassword") %></label></div>
      <div style="text-align: center; margin-top: 2em"><img class="margin5r" name="OK" onclick="submitForm();" alt="<%= c.string("Button.OK.alt") %>" src="<%= c.getModulesUrl() + "/dev/images/" + c.string("Button.OK.image") %>" border=0 >&nbsp;<A href="#" onClick="javascript:deactivateImanDialog('checkPassword');return false"><img class="margin5r" name="Cancel" alt="<%= c.string("Button.Cancel.alt") %>" src="<%= c.getModulesUrl() + "/dev/images/" + c.string("Button.Cancel.image") %>" border=0 ></A></div>
      </iman:dialog>
    </TD>
  </TR>


   <TR>
      <TD colspan="2"><hr noshade size="1"></TD>
   </TR>
   <TR><TD height="9"></TD></TR>
   <TR>
      <TD class=mediumtext nowrap><%= c.string("CreateUser.Password") %></TD>
      <TD class=smalltext2d><input type=password name="edirpassword" size="<%= c.string("UI.textboxSize") %>" maxlength="127" onkeypress="return checkDefaultKey(event)"></TD>
   </TR>
   <TR>
      <TD class=mediumtext nowrap><%= c.string("CreateUser.RetypePassword") %></TD>
      <TD class=smalltext2d><input type=password name="retypepassword" size="<%= c.string("UI.textboxSize") %>" maxlength="127" onkeypress="return checkDefaultKey(event)"></TD>
   </TR>

   <TR>
      <TD colspan="2" class="smalltext2d"><%= c.string("CreateUser.PasswordNote") %></TD>
   </TR>

   <TR><TD height="9"></TD></TR>

   </TABLE><BR>

   <iman:bar/>
   <iman:button key="OK" onClick="if(onExit() != false) submitForm();" />
   <iman:cancelBtn/>

</FORM>
<iman:osFooter/>
</BODY>
</HTML>



